/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistBroadcastPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistBroadcastRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsDistBroadcastDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsDistBroadcastRepo repo;
    private final QPmsDistBroadcastDO qdo = QPmsDistBroadcastDO.pmsDistBroadcastDO;
    private final QPmsDistributeRespondDO respondQdo = QPmsDistributeRespondDO.pmsDistributeRespondDO;

    private JPAQuery<PmsDistBroadcastVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistBroadcastVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.distId, this.qdo.respNumber, this.qdo.broadcastDays, this.qdo.remainingDays})).from((EntityPath)this.qdo);
    }

    public List<PmsDistBroadcastVO> findListByRespondentResId(Long respondentResId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistBroadcastVO.class, (Expression[])new Expression[]{this.qdo.id})).from((EntityPath)this.qdo)).innerJoin((EntityPath)this.respondQdo)).on((Predicate)this.qdo.distId.eq(this.respondQdo.distId));
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        List<String> status = Arrays.asList("NO RESPONDING", "INTERESTED");
        list.add(this.respondQdo.respStatus.isNotNull().and((Predicate)this.respondQdo.respStatus.notIn(status)));
        list.add(this.respondQdo.disterResId.eq((Object)respondentResId));
        list.add(this.respondQdo.deleteFlag.eq((Object)0));
        jpaQuery.where(ExpressionUtils.allOf(list));
        return jpaQuery.fetch();
    }

    private JPAQuery<PmsDistBroadcastVO> getJpaQueryWhere(PmsDistBroadcastQuery query) {
        JPAQuery<PmsDistBroadcastVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsDistBroadcastQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsDistBroadcastQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistId())) {
            list.add(this.qdo.distId.eq((Object)query.getDistId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRespNumber())) {
            list.add(this.qdo.respNumber.eq((Object)query.getRespNumber()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBroadcastDays())) {
            list.add(this.qdo.broadcastDays.eq((Object)query.getBroadcastDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemainingDays())) {
            list.add(this.qdo.remainingDays.eq((Object)query.getRemainingDays()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsDistBroadcastVO queryByKey(Long id) {
        JPAQuery<PmsDistBroadcastVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsDistBroadcastVO)jpaQuery.fetchFirst();
    }

    public List<PmsDistBroadcastVO> queryListDynamic(PmsDistBroadcastQuery query) {
        JPAQuery<PmsDistBroadcastVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsDistBroadcastVO> queryPaging(PmsDistBroadcastQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsDistBroadcastVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsDistBroadcastDO save(PmsDistBroadcastDO ado) {
        return (PmsDistBroadcastDO)this.repo.save(ado);
    }

    public List<PmsDistBroadcastDO> saveAll(List<PmsDistBroadcastDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsDistBroadcastPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getDistId() != null) {
            update.set(this.qdo.distId, (Object)payload.getDistId());
        }
        if (payload.getRespNumber() != null) {
            update.set(this.qdo.respNumber, (Object)payload.getRespNumber());
        }
        if (payload.getBroadcastDays() != null) {
            update.set(this.qdo.broadcastDays, (Object)payload.getBroadcastDays());
        }
        if (payload.getRemainingDays() != null) {
            update.set(this.qdo.remainingDays, (Object)payload.getRemainingDays());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("distId")) {
                update.setNull(this.qdo.distId);
            }
            if (nullFields.contains("respNumber")) {
                update.setNull(this.qdo.respNumber);
            }
            if (nullFields.contains("broadcastDays")) {
                update.setNull(this.qdo.broadcastDays);
            }
            if (nullFields.contains("remainingDays")) {
                update.setNull(this.qdo.remainingDays);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteByDistIds(List<Long> distIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.distId.in(distIds)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsDistBroadcastDAO(JPAQueryFactory jpaQueryFactory, PmsDistBroadcastRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

