/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsDistributeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsDistributeRepo repo;
    private final QPmsDistributeDO qdo = QPmsDistributeDO.pmsDistributeDO;
    private final QPmsDistributeRespondDO respondQdo = QPmsDistributeRespondDO.pmsDistributeRespondDO;
    private final QPmsDistBroadcastDO broadQdo = QPmsDistBroadcastDO.pmsDistBroadcastDO;

    private JPAQuery<PmsDistributeVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistributeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.distNo, this.qdo.disterResId, this.qdo.receiverResId, this.qdo.distStatus, this.qdo.apprStatus, this.qdo.distMethod, this.qdo.distDesc, this.qdo.capasetLevelId, this.qdo.capaIds, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.procInstId, this.qdo.procInstStatus})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsDistributeVO> distInnerJoinRespond() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistributeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.distNo, this.qdo.disterResId, this.qdo.receiverResId, this.qdo.distStatus, this.qdo.apprStatus, this.qdo.distMethod, this.qdo.distDesc, this.qdo.capasetLevelId, this.qdo.capaIds, this.qdo.planStartDate, this.qdo.planEndDate, this.respondQdo.respDesc, this.respondQdo.respStatus, this.respondQdo.respTime, this.respondQdo.respondentResId, this.respondQdo.inviteFlag, this.respondQdo.id.as("respondId")})).from((EntityPath)this.qdo)).innerJoin((EntityPath)this.respondQdo)).on((Predicate)this.qdo.id.eq(this.respondQdo.distId));
    }

    private JPAQuery<PmsDistributeVO> broadcastJoinDist() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistributeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.distNo, this.qdo.disterResId, this.qdo.receiverResId, this.qdo.distStatus, this.qdo.apprStatus, this.qdo.distMethod, this.qdo.distDesc, this.qdo.capasetLevelId, this.qdo.capaIds, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.workCountry, this.qdo.workProvince, this.qdo.workStyle, this.qdo.timeRequirement, this.qdo.workMethod, this.qdo.workPlace})).from((EntityPath)this.broadQdo)).innerJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.id.eq(this.broadQdo.distId));
    }

    private JPAQuery<PmsDistributeVO> respondInnerJoinDist() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsDistributeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.distNo, this.qdo.disterResId, this.qdo.receiverResId, this.qdo.distStatus, this.qdo.apprStatus, this.qdo.distMethod, this.qdo.distDesc, this.qdo.capasetLevelId, this.qdo.capaIds, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.workCountry, this.qdo.workProvince, this.qdo.workStyle, this.qdo.timeRequirement, this.qdo.workMethod, this.qdo.workPlace})).from((EntityPath)this.respondQdo)).innerJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.id.eq(this.respondQdo.distId));
    }

    private JPAQuery<PmsDistributeVO> getJpaQueryWhere(PmsDistributeQuery query) {
        JPAQuery<PmsDistributeVO> jpaQuery = query.getDistInnerJoinRespondFlag() != false ? this.distInnerJoinRespond() : (query.getRespondInnerJoinDistFlag() != false ? this.respondInnerJoinDist() : (query.getBroadcastJoinDistFlag() != false ? this.broadcastJoinDist() : this.getJpaQuerySelect()));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsDistributeQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsDistributeQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.qdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            list.add(this.qdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            list.add(this.qdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistNo())) {
            list.add(this.qdo.distNo.like(SqlUtil.toSqlLikeString(query.getDistNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterResId())) {
            list.add(this.qdo.disterResId.eq((Object)query.getDisterResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverResId())) {
            list.add(this.qdo.receiverResId.eq((Object)query.getReceiverResId()));
        }
        if (query.getMyDistFlag().booleanValue()) {
            list.add(this.qdo.receiverResId.eq((Object)GlobalUtil.getLoginUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistStatus()) && !ObjectUtils.isEmpty((Object)query.getDistStatusType())) {
            if ("0".equals(query.getDistStatusType())) {
                list.add(this.qdo.distStatus.ne((Object)query.getDistStatus()));
            } else {
                list.add(this.qdo.distStatus.eq((Object)query.getDistStatus()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            list.add(this.qdo.apprStatus.eq((Object)query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistMethod())) {
            list.add(this.qdo.distMethod.eq((Object)query.getDistMethod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistDesc())) {
            list.add(this.qdo.distDesc.eq((Object)query.getDistDesc()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCapasetLevelId())) {
            list.add(this.qdo.capasetLevelId.eq((Object)query.getCapasetLevelId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStartDate())) {
            list.add(this.qdo.planStartDate.eq((Object)query.getPlanStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEndDate())) {
            list.add(this.qdo.planEndDate.eq((Object)query.getPlanEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkStyle())) {
            list.add(this.qdo.workStyle.eq((Object)query.getWorkStyle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTimeRequirement())) {
            list.add(this.qdo.timeRequirement.eq((Object)query.getTimeRequirement()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkCountry())) {
            list.add(this.qdo.workCountry.eq((Object)query.getWorkCountry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkProvince())) {
            list.add(this.qdo.workProvince.eq((Object)query.getWorkProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkPlace())) {
            list.add(this.qdo.workPlace.eq((Object)query.getWorkPlace()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate()) && !ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.createTime.between((Comparable)query.getStartDate().atStartOfDay(), (Comparable)query.getEndDate().atStartOfDay()));
        }
        if (query.getRespondInnerJoinDistFlag().booleanValue() || query.getDistInnerJoinRespondFlag().booleanValue()) {
            if (!ObjectUtils.isEmpty((Object)query.getRespondentResId())) {
                list.add(this.respondQdo.respondentResId.eq((Object)query.getRespondentResId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getInviteFlag())) {
                list.add(this.respondQdo.inviteFlag.eq((Object)query.getInviteFlag()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getRespStatus())) {
                list.add(this.respondQdo.respStatus.eq((Object)query.getRespStatus()));
            }
        }
        if (query.getBroadcastJoinDistFlag().booleanValue() && !ObjectUtils.isEmpty((Object)query.getNotInIds())) {
            list.add(this.broadQdo.id.notIn((Collection)query.getNotInIds()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            list.add(this.qdo.disterResId.eq((Object)query.getLoginUserId()).or((Predicate)this.qdo.receiverResId.eq((Object)query.getLoginUserId())));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsDistributeVO queryByKey(Long id) {
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsDistributeVO)jpaQuery.fetchFirst();
    }

    public List<PmsDistributeVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsDistributeVO queryByReason(Long reasonId, String reasonType) {
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.reasonId.eq((Object)reasonId));
        jpaQuery.where((Predicate)this.qdo.reasonType.eq((Object)reasonType));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsDistributeVO)jpaQuery.fetchFirst();
    }

    public List<PmsDistributeVO> queryByReasons(List<Long> reasonId, String reasonType) {
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.reasonId.in(reasonId));
        jpaQuery.where((Predicate)this.qdo.reasonType.eq((Object)reasonType));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsDistributeVO> queryListDynamic(PmsDistributeQuery query) {
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsDistributeVO> queryPaging(PmsDistributeQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsDistributeVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsDistributeDO save(PmsDistributeDO ado) {
        return (PmsDistributeDO)this.repo.save(ado);
    }

    public List<PmsDistributeDO> saveAll(List<PmsDistributeDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsDistributePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getReasonType() != null) {
            update.set((Path)this.qdo.reasonType, (Object)payload.getReasonType());
        }
        if (payload.getReasonId() != null) {
            update.set(this.qdo.reasonId, (Object)payload.getReasonId());
        }
        if (payload.getDistNo() != null) {
            update.set((Path)this.qdo.distNo, (Object)payload.getDistNo());
        }
        if (payload.getDisterResId() != null) {
            update.set(this.qdo.disterResId, (Object)payload.getDisterResId());
        }
        if (payload.getReceiverResId() != null) {
            update.set(this.qdo.receiverResId, (Object)payload.getReceiverResId());
        }
        if (payload.getDistStatus() != null) {
            update.set((Path)this.qdo.distStatus, (Object)payload.getDistStatus());
        }
        if (payload.getApprStatus() != null) {
            update.set((Path)this.qdo.apprStatus, (Object)payload.getApprStatus());
        }
        if (payload.getDistMethod() != null) {
            update.set((Path)this.qdo.distMethod, (Object)payload.getDistMethod());
        }
        if (payload.getDistDesc() != null) {
            update.set((Path)this.qdo.distDesc, (Object)payload.getDistDesc());
        }
        if (payload.getPlanStartDate() != null) {
            update.set(this.qdo.planStartDate, (Object)payload.getPlanStartDate());
        }
        if (payload.getPlanEndDate() != null) {
            update.set(this.qdo.planEndDate, (Object)payload.getPlanEndDate());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("reasonType")) {
                update.setNull((Path)this.qdo.reasonType);
            }
            if (nullFields.contains("reasonId")) {
                update.setNull(this.qdo.reasonId);
            }
            if (nullFields.contains("distNo")) {
                update.setNull((Path)this.qdo.distNo);
            }
            if (nullFields.contains("disterResId")) {
                update.setNull(this.qdo.disterResId);
            }
            if (nullFields.contains("receiverResId")) {
                update.setNull(this.qdo.receiverResId);
            }
            if (nullFields.contains("distStatus")) {
                update.setNull((Path)this.qdo.distStatus);
            }
            if (nullFields.contains("apprStatus")) {
                update.setNull((Path)this.qdo.apprStatus);
            }
            if (nullFields.contains("distMethod")) {
                update.setNull((Path)this.qdo.distMethod);
            }
            if (nullFields.contains("distDesc")) {
                update.setNull((Path)this.qdo.distDesc);
            }
            if (nullFields.contains("planStartDate")) {
                update.setNull(this.qdo.planStartDate);
            }
            if (nullFields.contains("planEndDate")) {
                update.setNull(this.qdo.planEndDate);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateWorkFlow(PmsDistributePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprovedTime())) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDistStatus())) {
            update.set((Path)this.qdo.distStatus, (Object)payload.getDistStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsDistributeDAO(JPAQueryFactory jpaQueryFactory, PmsDistributeRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

