/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummaryPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummaryQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummaryVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSummaryDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectSummaryDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSummaryRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectSummaryDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectSummaryRepo repo;
    private final QPmsProjectSummaryDO qdo = QPmsProjectSummaryDO.pmsProjectSummaryDO;
    private final QPmsProjectDO qdoProject = QPmsProjectDO.pmsProjectDO;

    private JPAQuery<PmsProjectSummaryVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectSummaryVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.createTime, this.qdo.summaryNo, this.qdo.summaryName, this.qdo.projId, this.qdo.summaryContent, this.qdo.summaryStatus, this.qdo.summaryDate, this.qdoProject.projName, this.qdoProject.projNo, this.qdoProject.deliBuId, this.qdoProject.pmResId, this.qdoProject.deliUserId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdo.projId.eq(this.qdoProject.id));
    }

    private JPAQuery<PmsProjectSummaryVO> getJpaQueryWhere(PmsProjectSummaryQuery query) {
        JPAQuery<PmsProjectSummaryVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsProjectSummaryQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdo.projId.eq(this.qdoProject.id));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsProjectSummaryQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryNo())) {
            list.add(this.qdo.summaryNo.eq((Object)query.getSummaryNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryName())) {
            list.add(this.qdo.summaryName.like(SqlUtil.toSqlLikeString(query.getSummaryName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            list.add(this.qdo.projId.eq((Object)query.getProjId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryContent())) {
            list.add(this.qdo.summaryContent.eq((Object)query.getSummaryContent()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSummaryStatus())) {
            list.add(this.qdo.summaryStatus.eq((Object)query.getSummaryStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjSearch())) {
            list.add(this.qdoProject.projName.like(SqlUtil.toSqlLikeString(query.getProjSearch())).or((Predicate)this.qdoProject.projNo.like(SqlUtil.toSqlLikeString(query.getProjSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            list.add(this.qdoProject.pmResId.eq((Object)query.getPmResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            list.add(this.qdoProject.deliBuId.eq((Object)query.getDeliBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            list.add(this.qdoProject.deliUserId.eq((Object)query.getDeliUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectSummaryVO queryByKey(Long id) {
        JPAQuery<PmsProjectSummaryVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectSummaryVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectSummaryVO> queryListDynamic(PmsProjectSummaryQuery query) {
        JPAQuery<PmsProjectSummaryVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsProjectSummaryVO> queryPaging(PmsProjectSummaryQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectSummaryVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectSummaryDO save(PmsProjectSummaryDO ado) {
        return (PmsProjectSummaryDO)this.repo.save(ado);
    }

    public List<PmsProjectSummaryDO> saveAll(List<PmsProjectSummaryDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectSummaryPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSummaryNo() != null) {
            update.set((Path)this.qdo.summaryNo, (Object)payload.getSummaryNo());
        }
        if (payload.getSummaryName() != null) {
            update.set((Path)this.qdo.summaryName, (Object)payload.getSummaryName());
        }
        if (payload.getProjId() != null) {
            update.set(this.qdo.projId, (Object)payload.getProjId());
        }
        if (payload.getSummaryContent() != null) {
            update.set((Path)this.qdo.summaryContent, (Object)payload.getSummaryContent());
        }
        if (payload.getSummaryStatus() != null) {
            update.set(this.qdo.summaryStatus, (Object)payload.getSummaryStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("summaryNo")) {
                update.setNull((Path)this.qdo.summaryNo);
            }
            if (nullFields.contains("summaryName")) {
                update.setNull((Path)this.qdo.summaryName);
            }
            if (nullFields.contains("projId")) {
                update.setNull(this.qdo.projId);
            }
            if (nullFields.contains("summaryContent")) {
                update.setNull((Path)this.qdo.summaryContent);
            }
            if (nullFields.contains("summaryStatus")) {
                update.setNull(this.qdo.summaryStatus);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectSummaryDAO(JPAQueryFactory jpaQueryFactory, PmsProjectSummaryRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

