/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaCheckPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaCheckQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsMaCheckService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaCheckVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsMaCheckConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsMaCheckDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsMaCheckDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsMaCheckRepo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsMaCheckServiceImpl
extends BaseServiceImpl
implements PmsMaCheckService {
    private static final Logger log = LoggerFactory.getLogger(PmsMaCheckServiceImpl.class);
    private final PmsMaCheckRepo pmsMaCheckRepo;
    private final PmsMaCheckDAO pmsMaCheckDAO;

    @Transactional(rollbackFor={Exception.class})
    public PmsMaCheckVO insertOrUpdate(PmsMaCheckPayload payload) {
        PmsMaCheckDO entityDo = PmsMaCheckConvert.INSTANCE.toDo(payload);
        if (entityDo.getFinishFlag() != null && entityDo.getFinishFlag() == 1) {
            entityDo.setFinishTime(LocalDateTime.now());
        } else {
            entityDo.setFinishTime(null);
        }
        return PmsMaCheckConvert.INSTANCE.toVo((PmsMaCheckDO)this.pmsMaCheckRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsertOrUpdate(List<PmsMaCheckPayload> payloads) {
        if (ObjectUtils.isEmpty(payloads)) {
            throw TwException.error("", "\u4fdd\u5b58\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ArrayList dos = new ArrayList();
        payloads.forEach(payload -> {
            PmsMaCheckDO entityDo = PmsMaCheckConvert.INSTANCE.toDo((PmsMaCheckPayload)payload);
            if (entityDo.getFinishFlag() != null && entityDo.getFinishFlag() == 1) {
                entityDo.setFinishTime(LocalDateTime.now());
            } else {
                entityDo.setFinishTime(null);
            }
            dos.add(entityDo);
        });
        this.pmsMaCheckRepo.saveAll(dos);
    }

    public PagingVO<PmsMaCheckVO> queryPaging(PmsMaCheckQuery query) {
        return this.pmsMaCheckDAO.queryPaging(query);
    }

    public List<PmsMaCheckVO> queryListDynamic(PmsMaCheckQuery query) {
        List<PmsMaCheckVO> pmsMaCheckVOS1;
        List<PmsMaCheckVO> pmsMaCheckVOS = this.pmsMaCheckDAO.queryConfigList(query);
        if (!ObjectUtils.isEmpty(pmsMaCheckVOS) && !ObjectUtils.isEmpty(pmsMaCheckVOS1 = this.pmsMaCheckDAO.queryListDynamic(query))) {
            pmsMaCheckVOS.forEach(vo -> {
                Optional<PmsMaCheckVO> first = pmsMaCheckVOS1.stream().filter(vo1 -> vo.getConfigId().equals(vo1.getConfigId())).findFirst();
                if (first.isPresent()) {
                    PmsMaCheckVO pmsMaCheckVO = first.get();
                    vo.setFinishFlag(pmsMaCheckVO.getFinishFlag());
                    vo.setFinishTime(pmsMaCheckVO.getFinishTime());
                    vo.setId(pmsMaCheckVO.getId());
                    vo.setProjId(pmsMaCheckVO.getProjId());
                }
            });
        }
        pmsMaCheckVOS.sort(Comparator.comparing(PmsMaCheckVO::getSortIndex));
        return pmsMaCheckVOS;
    }

    public PmsMaCheckVO queryByKey(Long key) {
        PmsMaCheckDO entity = this.pmsMaCheckRepo.findById(key).orElseGet(PmsMaCheckDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsMaCheckVO vo = PmsMaCheckConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsMaCheckPayload payload) {
        PmsMaCheckDO entity = this.pmsMaCheckRepo.findById(payload.getId()).orElseGet(PmsMaCheckDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsMaCheckDAO.updateByKeyDynamic(payload);
        return result;
    }

    public PmsMaCheckServiceImpl(PmsMaCheckRepo pmsMaCheckRepo, PmsMaCheckDAO pmsMaCheckDAO) {
        this.pmsMaCheckRepo = pmsMaCheckRepo;
        this.pmsMaCheckDAO = pmsMaCheckDAO;
    }
}

