/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectTemplateEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectTemplateConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectTemplateDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectTemplateRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectTemplateServiceImpl
extends BaseServiceImpl
implements PmsProjectTemplateService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectTemplateServiceImpl.class);
    private final PmsProjectTemplateRepo pmsProjectTemplateRepo;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final CacheUtil cacheUtil;
    private final PmsProjectTemplateActService pmsProjectTemplateActService;

    public PagingVO<PmsProjectTemplateVO> paging(PmsProjectTemplateQuery query) {
        PagingVO<PmsProjectTemplateVO> paging = this.pmsProjectTemplateDAO.paging(query);
        if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
            paging.getRecords().forEach(record -> this.transferData((PmsProjectTemplateVO)record));
        }
        return paging;
    }

    void transferData(PmsProjectTemplateVO vo) {
        if (ProjectTemplateEnum.ENABLE.getCode().equals(vo.getTemplateStatus())) {
            vo.setTemplateStatusName(ProjectTemplateEnum.ENABLE.getDesc());
        }
        if (ProjectTemplateEnum.DISABLE.getCode().equals(vo.getTemplateStatus())) {
            vo.setTemplateStatusName(ProjectTemplateEnum.DISABLE.getDesc());
        }
        vo.setSuitProjectTypeDesc(this.cacheUtil.transferSystemSelection("salecon:work_type", vo.getSuitProjectType()));
        vo.setTmplTypeDesc(this.cacheUtil.transferSystemSelection("BU:SUIT_TYPY", vo.getTmplType()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public List<PmsProjectTemplateVO> queryListDynamic(PmsProjectTemplateQuery query) {
        List<PmsProjectTemplateVO> records = this.pmsProjectTemplateDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(records)) {
            records.forEach(record -> this.transferData((PmsProjectTemplateVO)record));
        }
        return records;
    }

    public PmsProjectTemplateVO queryByKey(Long key) {
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(key);
        if (!ObjectUtils.isEmpty((Object)pmsProjectTemplateVO)) {
            this.transferData(pmsProjectTemplateVO);
            pmsProjectTemplateVO.setActList(this.pmsProjectTemplateActService.queryByTemplateId(key));
        }
        return pmsProjectTemplateVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateVO insert(PmsProjectTemplatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getTemplateName())) {
            throw TwException.error("", "\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByName(payload.getTemplateName());
        if (!ObjectUtils.isEmpty((Object)pmsProjectTemplateVO)) {
            throw TwException.error("", "\u540d\u79f0\u53ef\u4e0d\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getTemplateStatus())) {
            payload.setTemplateStatus(ProjectTemplateEnum.ENABLE.getCode());
        }
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entityDo = (PmsProjectTemplateDO)this.pmsProjectTemplateRepo.save(entityDo);
        PmsProjectTemplateVO templateVO = PmsProjectTemplateConvert.INSTANCE.toVo(entityDo);
        List actList = payload.getActList();
        if (!ObjectUtils.isEmpty((Object)actList)) {
            actList.forEach(v -> v.setTemplateId(templateVO.getId()));
            templateVO.setActList(this.pmsProjectTemplateActService.batchSave(actList));
        }
        return templateVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateVO update(PmsProjectTemplatePayload payload) {
        PmsProjectTemplateVO pmsProjectTemplateVO;
        PmsProjectTemplateDO entity = this.pmsProjectTemplateRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateDO::new);
        if (!entity.getTemplateName().equals(payload.getTemplateName()) && !ObjectUtils.isEmpty((Object)(pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByName(payload.getTemplateName())))) {
            throw TwException.error("", "\u540d\u79f0\u53ef\u4e0d\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PmsProjectTemplateVO templateVO = PmsProjectTemplateConvert.INSTANCE.toVo((PmsProjectTemplateDO)this.pmsProjectTemplateRepo.save(entity));
        List actList = payload.getActList();
        if (!ObjectUtils.isEmpty((Object)actList)) {
            actList.forEach(v -> v.setTemplateId(payload.getId()));
            templateVO.setActList(this.pmsProjectTemplateActService.batchSave(actList));
        }
        return templateVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectTemplateDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(List<Long> keys, Integer templateStatus) {
        if (ObjectUtils.isEmpty((Object)templateStatus)) {
            throw TwException.error("", "\u5207\u6362\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!templateStatus.equals(ProjectTemplateEnum.DISABLE.getCode()) && !templateStatus.equals(ProjectTemplateEnum.ENABLE.getCode())) {
            throw TwException.error("", "\u72b6\u6001\u503c\u4e0d\u7b26\u5408\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!keys.isEmpty()) {
            return this.pmsProjectTemplateDAO.updateStatus(keys, templateStatus);
        }
        throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public PmsProjectTemplateServiceImpl(PmsProjectTemplateRepo pmsProjectTemplateRepo, PmsProjectTemplateDAO pmsProjectTemplateDAO, CacheUtil cacheUtil, PmsProjectTemplateActService pmsProjectTemplateActService) {
        this.pmsProjectTemplateRepo = pmsProjectTemplateRepo;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.cacheUtil = cacheUtil;
        this.pmsProjectTemplateActService = pmsProjectTemplateActService;
    }
}

