/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSitePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSiteDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemSiteDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemSiteRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemSitePurDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemSiteRepo repo;
    private final QPrdSystemSiteDO qdo = QPrdSystemSiteDO.prdSystemSiteDO;

    private JPAQuery<PrdSystemSiteVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemSiteVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.modifyTime, this.qdo.siteDesc, this.qdo.siteLongitude, this.qdo.siteLatitude})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdSystemSiteVO> getJpaQueryWhere(PrdSystemSiteQuery query) {
        JPAQuery<PrdSystemSiteVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PrdSystemSiteQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PrdSystemSiteQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSiteDesc())) {
            list.add(this.qdo.siteDesc.like(SqlUtil.toSqlLikeString(query.getSiteDesc())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSiteLongitude())) {
            list.add(this.qdo.siteLongitude.eq((Object)query.getSiteLongitude()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSiteLatitude())) {
            list.add(this.qdo.siteLatitude.eq((Object)query.getSiteLatitude()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PrdSystemSiteVO queryByKey(Long id) {
        JPAQuery<PrdSystemSiteVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemSiteVO)jpaQuery.fetchFirst();
    }

    public List<PrdSystemSiteVO> queryListDynamic(PrdSystemSiteQuery query) {
        JPAQuery<PrdSystemSiteVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdSystemSiteVO> queryPaging(PrdSystemSiteQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemSiteVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PrdSystemSiteDO save(PrdSystemSiteDO ado) {
        return (PrdSystemSiteDO)this.repo.save(ado);
    }

    public List<PrdSystemSiteDO> saveAll(List<PrdSystemSiteDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PrdSystemSitePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSiteDesc() != null) {
            update.set((Path)this.qdo.siteDesc, (Object)payload.getSiteDesc());
        }
        if (payload.getSiteLongitude() != null) {
            update.set((Path)this.qdo.siteLongitude, (Object)payload.getSiteLongitude());
        }
        if (payload.getSiteLatitude() != null) {
            update.set((Path)this.qdo.siteLatitude, (Object)payload.getSiteLatitude());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("siteDesc")) {
                update.setNull((Path)this.qdo.siteDesc);
            }
            if (nullFields.contains("siteLongitude")) {
                update.setNull((Path)this.qdo.siteLongitude);
            }
            if (nullFields.contains("siteLatitude")) {
                update.setNull((Path)this.qdo.siteLatitude);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PrdSystemSitePurDAO(JPAQueryFactory jpaQueryFactory, PrdSystemSiteRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

