/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiSignetApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/BUSI_SIGNET_APPLY/callBack"})
@Transactional
public class BusiSignetApplyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(BusiSignetApplyWorkflowCallBackController.class);
    private final TBusiSignetApplyService service;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TBusiSignetApplyPayload busiSignetApplyPayload = new TBusiSignetApplyPayload();
        busiSignetApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        TBusiSignetApplyVO tBusiSignetApplyVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (tBusiSignetApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    busiSignetApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    busiSignetApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    busiSignetApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    busiSignetApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    busiSignetApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    busiSignetApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    busiSignetApplyPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    busiSignetApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.service.updateByKeyDynamic(busiSignetApplyPayload);
        }
        return WorkflowResult.success(null);
    }

    public BusiSignetApplyWorkflowCallBackController(TBusiSignetApplyService service) {
        this.service = service;
    }
}

