/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedocref;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.yeedocref.CommonFormulaFunction;
import com.elitesland.tw.tw5.server.yeedocref.TwFormulaFunctionAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/yeedoc"})
public class YeedocController {
    private static final Logger log = LoggerFactory.getLogger(YeedocController.class);
    @Autowired
    private Map<String, CommonFormulaFunction> formulaFunctionsMap;
    private final List<FormulaFunctionInfo> functionList = new ArrayList<FormulaFunctionInfo>();

    @PostConstruct
    private void initList() {
        this.formulaFunctionsMap.forEach((key, value) -> {
            TwFormulaFunctionAnnotation annotation = value.getClass().getAnnotation(TwFormulaFunctionAnnotation.class);
            this.functionList.add(new FormulaFunctionInfo(annotation.name(), annotation.code(), annotation.scope(), annotation.tableName(), annotation.params(), annotation.description(), annotation.enabled()));
        });
    }

    @GetMapping(value={"/function/list"})
    public TwOutputUtil eventList(String scope, String tableName, boolean allFlag) {
        List result = this.functionList.stream().filter(eventInfo -> {
            boolean bool = true;
            if (scope != null && !scope.equals(eventInfo.getScope())) {
                bool = false;
            }
            if (tableName != null && !tableName.equals(eventInfo.getTableName())) {
                bool = false;
            }
            if (!allFlag && !eventInfo.enabled) {
                bool = false;
            }
            return bool;
        }).collect(Collectors.toList());
        return TwOutputUtil.ok(result);
    }

    public static class FormulaFunctionInfo {
        private final String name;
        private final String code;
        private final String scope;
        private final String tableName;
        private final String params;
        private final String description;
        private final boolean enabled;

        public FormulaFunctionInfo(String name, String code, String scope, String tableName, String params, String description, boolean enabled) {
            this.name = name;
            this.code = code;
            this.scope = scope;
            this.tableName = tableName;
            this.params = params;
            this.description = description;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getParams() {
            return this.params;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

