package com.elitesland.tw.tw5.server.common.crontask.payload;

import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售合同
 *
 * @author eason.shi
 * @since 2018/11/6
 */
@Data
public class TwContractEntity implements Serializable {

    //错误码
    private String errorCode;
    /**
     * - T_CONTRACT.ID
     */
    private Long id;

    /**
     * 租户ID - T_CONTRACT.TENANT_ID
     */
    private Long tenantId;

    /**
     * 合同编号 - T_CONTRACT.CONTRACT_NO
     */
    private String contractNo;

    /**
     * 合同名称 - T_CONTRACT.CONTRACT_NAME
     */
    private String contractName;

    /**
     * 合同状态 - T_CONTRACT.CONTRACT_STATUS
     */
    private String contractStatus;

    /**
     * 合同s审批状态 - T_CONTRACT.APPR_STATUS
     */
    private String apprStatus;

    /**
     * 商机ID - T_CONTRACT.OPPO_ID
     */
    private Long oppoId;

    /**
     * 签约公司ID - T_CONTRACT.OU_ID
     */
    private Long ouId;

    /**
     * 参考合同号 - T_CONTRACT.USERDEFINED_NO
     */
    private String userdefinedNo;

    /**
     * 主合同ID - T_CONTRACT.MAIN_CONTRACT_ID
     */
    private Long mainContractId;

    /**
     * 关联合同ID - T_CONTRACT.RELATED_CONTRACT_ID
     */
    private Long relatedContractId;

    /**
     * 客户ID - T_CONTRACT.CUST_ID
     */
    @NotNull(message = "客户ID为空,保存失败")
    private Long custId;

    /**
     * 签约时客户名称 - T_CONTRACT.CUST_NAME
     */
    private String custName;

    /**
     * 客户项目 - T_CONTRACT.CUST_PROJ
     */
    private String custProj;

    /**
     * 新客户合同 - T_CONTRACT.NEW_CONTRACT_FLAG
     */
    private String newContractFlag;

    /**
     * 交付地点 - T_CONTRACT.DELIVERY_ADDRESS
     */
    private String deliveryAddress;

    /**
     * 客户承担差旅 - T_CONTRACT.CUSTPAYTRAVEL_FLAG
     */
    private String custpaytravelFlag;

    /**
     * 报销说明 - T_CONTRACT.REIMBURSEMENT_DESC
     */
    private String reimbursementDesc;

    /**
     * 主合同类型 - T_CONTRACT.MAIN_TYPE
     */
    private String mainType;

    /**
     * 平台合同类型 - T_CONTRACT.PLAT_TYPE
     */
    private String platType;

    /**
     * 促销类型 - T_CONTRACT.PROMOTION_TYPE
     */
    private String promotionType;

    /**
     * 工作类型 - T_CONTRACT.WORK_TYPE
     */
    private String workType;

    /**
     * 范围性质 - T_CONTRACT.RANGE_PROP
     */
    private String rangeProp;

    /**
     * 半开口说明 - T_CONTRACT.HALF_OPEN_DESC
     */
    private String halfOpenDesc;

    /**
     * 品项属性 - T_CONTRACT.PROD_PROP
     */
    private String prodProp;

    /**
     * 项目属性 - T_CONTRACT.PROJ_PROP
     */
    private String projProp;

    /**
     * 简要说明 - T_CONTRACT.BRIEF_DESC
     */
    private String briefDesc;

    /**
     * 特别关注点 - T_CONTRACT.SPECIAL_CONCERNED
     */
    private String specialConcerned;

    /**
     * 合同总金额 - T_CONTRACT.AMT
     */
    private BigDecimal amt;

    /**
     * 其它费用 - T_CONTRACT.EXTRA_AMT
     */
    private BigDecimal extraAmt;

    /**
     * 税率 - T_CONTRACT.TAX_RATE
     */
    private BigDecimal taxRate;

    /**
     * 有效合同金额 - T_CONTRACT.EFFECTIVE_AMT
     */
    private BigDecimal effectiveAmt;

    /**
     * 折算后有效合同额 - T_CONTRACT.OBVERSIONED_EFFECTIVE_AMT
     */
    private BigDecimal obversionedEffectiveAmt;

    /**
     * 毛利 - T_CONTRACT.GROSS_PROFIT
     */
    private BigDecimal grossProfit;

    /**
     * 财务期间ID - T_CONTRACT.FIN_PERIOD_ID
     */
    private Long finPeriodId;

    /**
     * 销售大类 - T_CONTRACT.SALE_TYPE1
     */
    private String saleType1;
    private String saleType1Desc;

    /**
     * 销售大类 sphd1 M1 目前已被使用，不清楚使用场景
     */
    private String saleType1Sphd1;
    /**
     * 销售大类 sphd2  CASE 发起商机案例收集
     */
    private String saleType1Sphd2;
    /**
     * 销售大类 sphd3  AMT_CHECK 校验阈值金额（sphd1 = CASE,sphd2=AMT_CHECK  校验sphd3  ）
     */
    private String saleType1Sphd3;
    /**
     * 销售大类 sphd4 5000.00 阈值金额
     */
    private String saleType1Sphd4;
    /**
     * 销售大类 sphd5 SAME_CUST 同一客户有过运维类资料收集流程不发起
     */
    private String saleType1Sphd5;


    /**
     * 销售小类 - T_CONTRACT.SALE_TYPE2
     */
    private String saleType2;

    /**
     * 销售小类 sphd2  金额阈值
     */
    private String saleType2Sphd2;

    /**
     * 销售内容 - T_CONTRACT.SALE_CONTENT
     */
    private String saleContent;

    /**
     * 关联产品ID - T_CONTRACT.PRODUCT_ID
     */
    private Long productId;

    /**
     * 签单BU_ID - T_CONTRACT.SIGN_BU_ID
     */
    private Long signBuId;

    /**
     * 销售人员ID - T_CONTRACT.SALESMAN_RES_ID
     */
    private Long salesmanResId;

    @UdcName(udcName = "tw:res", codePropName = "salesmanResId")
    private String salesmanResName;

    /**
     * 副签单BU_ID - T_CONTRACT.CO_BU_ID
     */
    private Long coBuId;

    /**
     * 副签单负责人ID - T_CONTRACT.CO_RES_ID
     */
    private Long coResId;

    /**
     * 交付BU_ID - T_CONTRACT.DELI_BU_ID
     */
    private Long deliBuId;

    /**
     * 交付负责人ID - T_CONTRACT.DELI_RES_ID
     */
    private Long deliResId;

    /**
     * 副交付BU_ID - T_CONTRACT.CODELI_BU_ID
     */
    private Long codeliBuId;

    /**
     * 副交付负责人ID - T_CONTRACT.CODELI_RES_ID
     */
    private Long codeliResId;

    /**
     * 来源类型 - T_CONTRACT.SOURCE_TYPE
     */
    private String sourceType;

    /**
     * 外部来源标识 - T_CONTRACT.EXTERNAL_IDEN
     */
    private String externalIden;

    /**
     * 外部来源人 - T_CONTRACT.EXTERNAL_NAME
     */
    private String externalName;

    /**
     * 外部来源电话 - T_CONTRACT.EXTERNAL_PHONE
     */
    private String externalPhone;

    /**
     * 内部来源BU_ID - T_CONTRACT.INTERNAL_BU_ID
     */
    private Long internalBuId;

    /**
     * 内部来源人ID - T_CONTRACT.INTERNAL_RES_ID
     */
    private Long internalResId;

    /**
     * 利益承诺 - T_CONTRACT.PROFIT_DESC
     */
    private String profitDesc;

    /**
     * 签订日期 - T_CONTRACT.SIGN_DATE
     */
    private LocalDate signDate;

    /**
     * 合同开始日期 - T_CONTRACT.START_DATE
     */
    private LocalDate startDate;

    /**
     * 合同结束日期 - T_CONTRACT.END_DATE
     */
    private LocalDate endDate;

    /**
     * 提醒日期 - T_CONTRACT.INFORM_DATE
     */
    private LocalDate informDate;

    /**
     * 提醒对象 - T_CONTRACT.INFORM_RES_ID
     */

    private Long informResId;

    /**
     * 提醒内容 - T_CONTRACT.INFORM_CONTENT
     */
    private String informContent;

    /**
     * 激活日期 - T_CONTRACT.ACTIVATE_DATE
     */
    private LocalDate activateDate;

    /**
     * 关闭日期 - T_CONTRACT.CLOSE_DATE
     */
    private LocalDate closeDate;

    /**
     * 备注 - T_CONTRACT.REMARK
     */
    private String remark;

    /**
     * 关闭原因
     */
    private String closeReason;

    /**
     * 合作类型
     */
    private String cooperationType;

    /**
     * 渠道类型
     */

    private String channelType;

    /**
     * 币种
     */
    private String currCode;

    /**
     * 销售区域BU_ID - T_CONTRACT.REGION_BU_ID
     */
    private Long regionBuId;

    private String profitRuleNo;//PROFIT_RULE_NO 分配规则码

    private String paperStatus;//纸质合同状态

    private String paperDesc;//纸质合同状态描述

    private Long pmoResId; //POM_RES_ID

    private Long preSaleBuId;//售前bu

    private Long preSaleResId;//售前负责人

    private String source;//合同来源

    /**
     * 需求类别
     */
    private String demandType;

    /**
     * 创建人，外部应用需要手动传入该字段
     */
    private String createUserId;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人，外部应用需要手动传入该字段
     */
    private String modifyUserId;
    /**
     * 创建时间
     */
    private LocalDateTime modifyTime;

    /**
     * 合同标签
     */
    private String tagIds;

    /**
     * 销售分类
     */
    private String saleClass;

    /**
     * 净利润
     */
    private BigDecimal netProfit;

    /**
     * 额定当量
     */
    private BigDecimal ratedEqva;

    /**
     * 额定费用
     */
    private BigDecimal ratedExpense;


    /**
     * 编辑模式 可绕过合同状态校验  特殊：子合同激活流程ACC_A64 提交人节点 合同预审节点、财务经理节点 可编辑审批状态的合同
     */
    private Boolean editMode;

    private Long contractIdV5;

    private Boolean delFlag;

}
