package com.elitesland.tw.tw5.server.common.funConfig.dao;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRulePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigRuleDO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.QBusinessDocTypeConfigRuleDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRuleRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Repository
@RequiredArgsConstructor
public class BusinessDocTypeConfigRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessDocTypeConfigRuleRepo repo;
    private final QBusinessDocTypeConfigRuleDO qdo = QBusinessDocTypeConfigRuleDO.businessDocTypeConfigRuleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeConfigRuleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessDocTypeConfigRuleVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 文档类型配置主键 prd_business_doc_type_config.id
                qdo.configId,
                // 条件 =、 in、not in、.....
                qdo.conditions,
                // 条件值
                qdo.conditionsValue,
                // 易道壳itemId
                qdo.itemId,
                // 易稻壳libraryId
                qdo.libraryId,
                // 易稻壳libraryId翻译
                qdo.libraryName,
                // 易稻壳库下的文件路径 /A/B/C
                qdo.path,
                // 文档类型名称（冗余）prd_business_doc_type_config.name
                qdo.configName,
                // 文档类型编码（冗余）prd_business_doc_type_config.code
                qdo.configCode,
                // 功能主键(冗余) prd_system_function.id
                qdo.functionId,
                // 业务对象主键(冗余) prd_business_table.id
                qdo.tableId,
                // 数据库表名(冗余) prd_business_table.table_name
                qdo.tableName,
                // 业务对象字段明细主键(冗余) prd_business_table_fields.id
                qdo.fieldId,
                // 字段展示名称(冗余) prd_business_table_fields.show_name
                qdo.fieldShowName,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeConfigRuleVO> getJpaQueryWhere(BusinessDocTypeConfigRuleQuery query) {
        JPAQuery<BusinessDocTypeConfigRuleVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessDocTypeConfigRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessDocTypeConfigRuleQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getIdNe())) {
            list.add(qdo.id.ne(query.getIdNe()));
        }
        /** 文档类型配置主键 prd_business_doc_type_config.id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 条件 =、 in、not in、..... 精确 */
        if (!ObjectUtils.isEmpty(query.getConditions())) {
            list.add(qdo.conditions.eq(query.getConditions()));
        }
        /** 条件值 精确 */
        if (!ObjectUtils.isEmpty(query.getConditionsValue())) {
            list.add(qdo.conditionsValue.eq(query.getConditionsValue()));
        }
        /** 易道壳itemId 精确 */
        if (!ObjectUtils.isEmpty(query.getItemId())) {
            list.add(qdo.itemId.eq(query.getItemId()));
        }
        /** 易稻壳libraryId 精确 */
        if (!ObjectUtils.isEmpty(query.getLibraryId())) {
            list.add(qdo.libraryId.eq(query.getLibraryId()));
        }
        /** 易稻壳libraryId翻译 精确 */
        if (!ObjectUtils.isEmpty(query.getLibraryName())) {
            list.add(qdo.libraryName.eq(query.getLibraryName()));
        }
        /** 易稻壳库下的文件路径 /A/B/C 精确 */
        if (!ObjectUtils.isEmpty(query.getPath())) {
            list.add(qdo.path.eq(query.getPath()));
        }
        /** 文档类型名称（冗余）prd_business_doc_type_config.name 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigName())) {
            list.add(qdo.configName.eq(query.getConfigName()));
        }
        /** 文档类型编码（冗余）prd_business_doc_type_config.code 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigCode())) {
            list.add(qdo.configCode.eq(query.getConfigCode()));
        }
        /** 功能主键(冗余) prd_system_function.id 精确 */
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            list.add(qdo.functionId.eq(query.getFunctionId()));
        }
        /** 业务对象主键(冗余) prd_business_table.id 精确 */
        if (!ObjectUtils.isEmpty(query.getTableId())) {
            list.add(qdo.tableId.eq(query.getTableId()));
        }
        /** 数据库表名(冗余) prd_business_table.table_name 精确 */
        if (!ObjectUtils.isEmpty(query.getTableName())) {
            list.add(qdo.tableName.eq(query.getTableName()));
        }
        /** 业务对象字段明细主键(冗余) prd_business_table_fields.id 精确 */
        if (!ObjectUtils.isEmpty(query.getFieldId())) {
            list.add(qdo.fieldId.eq(query.getFieldId()));
        }
        /** 字段展示名称(冗余) prd_business_table_fields.show_name 精确 */
        if (!ObjectUtils.isEmpty(query.getFieldShowName())) {
            list.add(qdo.fieldShowName.eq(query.getFieldShowName()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessDocTypeConfigRuleVO queryByKey(Long id) {
        JPAQuery<BusinessDocTypeConfigRuleVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessDocTypeConfigRuleVO> queryListDynamic(BusinessDocTypeConfigRuleQuery query) {
        JPAQuery<BusinessDocTypeConfigRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessDocTypeConfigRuleVO> queryPaging(BusinessDocTypeConfigRuleQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessDocTypeConfigRuleVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessDocTypeConfigRuleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessDocTypeConfigRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessDocTypeConfigRuleDO save(BusinessDocTypeConfigRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessDocTypeConfigRuleDO> saveAll(List<BusinessDocTypeConfigRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessDocTypeConfigRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 文档类型配置主键 prd_business_doc_type_config.id
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 条件 =、 in、not in、.....
        if (payload.getConditions() != null) {
            update.set(qdo.conditions, payload.getConditions());
        }
        // 条件值
        if (payload.getConditionsValue() != null) {
            update.set(qdo.conditionsValue, payload.getConditionsValue());
        }
        // 易道壳itemId
        if (payload.getItemId() != null) {
            update.set(qdo.itemId, payload.getItemId());
        }
        // 易稻壳libraryId
        if (payload.getLibraryId() != null) {
            update.set(qdo.libraryId, payload.getLibraryId());
        }
        // 易稻壳libraryId翻译
        if (payload.getLibraryName() != null) {
            update.set(qdo.libraryName, payload.getLibraryName());
        }
        // 易稻壳库下的文件路径 /A/B/C
        if (payload.getPath() != null) {
            update.set(qdo.path, payload.getPath());
        }
        // 文档类型名称（冗余）prd_business_doc_type_config.name
        if (payload.getConfigName() != null) {
            update.set(qdo.configName, payload.getConfigName());
        }
        // 文档类型编码（冗余）prd_business_doc_type_config.code
        if (payload.getConfigCode() != null) {
            update.set(qdo.configCode, payload.getConfigCode());
        }
        // 功能主键(冗余) prd_system_function.id
        if (payload.getFunctionId() != null) {
            update.set(qdo.functionId, payload.getFunctionId());
        }
        // 业务对象主键(冗余) prd_business_table.id
        if (payload.getTableId() != null) {
            update.set(qdo.tableId, payload.getTableId());
        }
        // 数据库表名(冗余) prd_business_table.table_name
        if (payload.getTableName() != null) {
            update.set(qdo.tableName, payload.getTableName());
        }
        // 业务对象字段明细主键(冗余) prd_business_table_fields.id
        if (payload.getFieldId() != null) {
            update.set(qdo.fieldId, payload.getFieldId());
        }
        // 字段展示名称(冗余) prd_business_table_fields.show_name
        if (payload.getFieldShowName() != null) {
            update.set(qdo.fieldShowName, payload.getFieldShowName());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 文档类型配置主键 prd_business_doc_type_config.id
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 条件 =、 in、not in、.....
            if (nullFields.contains("conditions")) {
                update.setNull(qdo.conditions);
            }
            // 条件值
            if (nullFields.contains("conditionsValue")) {
                update.setNull(qdo.conditionsValue);
            }
            // 易道壳itemId
            if (nullFields.contains("itemId")) {
                update.setNull(qdo.itemId);
            }
            // 易稻壳libraryId
            if (nullFields.contains("libraryId")) {
                update.setNull(qdo.libraryId);
            }
            // 易稻壳libraryId翻译
            if (nullFields.contains("libraryName")) {
                update.setNull(qdo.libraryName);
            }
            // 易稻壳库下的文件路径 /A/B/C
            if (nullFields.contains("path")) {
                update.setNull(qdo.path);
            }
            // 文档类型名称（冗余）prd_business_doc_type_config.name
            if (nullFields.contains("configName")) {
                update.setNull(qdo.configName);
            }
            // 文档类型编码（冗余）prd_business_doc_type_config.code
            if (nullFields.contains("configCode")) {
                update.setNull(qdo.configCode);
            }
            // 功能主键(冗余) prd_system_function.id
            if (nullFields.contains("functionId")) {
                update.setNull(qdo.functionId);
            }
            // 业务对象主键(冗余) prd_business_table.id
            if (nullFields.contains("tableId")) {
                update.setNull(qdo.tableId);
            }
            // 数据库表名(冗余) prd_business_table.table_name
            if (nullFields.contains("tableName")) {
                update.setNull(qdo.tableName);
            }
            // 业务对象字段明细主键(冗余) prd_business_table_fields.id
            if (nullFields.contains("fieldId")) {
                update.setNull(qdo.fieldId);
            }
            // 字段展示名称(冗余) prd_business_table_fields.show_name
            if (nullFields.contains("fieldShowName")) {
                update.setNull(qdo.fieldShowName);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public Long checkUnique(Long configId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
            .select(qdo.count())
            .from(qdo);
        jpaQuery.where(qdo.configId.eq(configId).and(qdo.fieldId.isNull()));
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 按配置id删除
     *
     * @param keys 按键
     * @return long
     */
    public long deleteSoftByConfigId(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.configId.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

