package com.elitesland.tw.tw5.server.common.permission.enums;

/**
 * @Author Quruiqizz
 * @Date 2023/10/11 9:25
 **/
public enum PermissionFieldType {

    BUSINESS_USER("BUSINESS_USER", "业务用户属性"),
    BUSINESS_DEPT("BUSINESS_DEPT", "业务部门属性"),
    NORMAL("NORMAL", "普通属性"),
    DATE("DATE","日期属性"),
    ;

    private final String name;

    private final String desc;

    PermissionFieldType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static PermissionFieldType find(String name) {
        for (PermissionFieldType value : PermissionFieldType.values()) {
            if (value.getName().equals(name)) {
                return value;
            }
        }
        return null;
    }

}
