package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 13:42
 **/
@Service(value = "BUSINESS_OBJECT_TYPE_ALL_USERS_IN_ORGANIZATION")
public class BusinessObjectTypeAllUsersInOrg implements BusinessObjectTypeStrategyService {

    /**
     *本级组织下的所有用户
     *
     * @param rule
     * @param mapBuilder
     * @param ruleGroupExprList
     * @param loginUserId
     * @param defaultOrgId
     * @param childOrgIdSet
     * @param map
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, Map<String, Object> map) {
        mapBuilder.group(rule.getRuleCode());

        mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()), defaultOrgId).op(FieldOps.Equal);

        return true;
    }

}
