package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitRuleService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.*;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.*;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingLimitDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingLimitRuleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.*;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRuleRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingLimitServiceImpl extends BaseServiceImpl implements AccReimSettingLimitService {

    private final AccReimSettingLimitRepo accReimSettingLimitRepo;
    private final AccReimSettingLimitDAO accReimSettingLimitDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final AccReimSettingLimitRuleService accReimSettingLimitRuleService;
    private final AccReimSettingLimitRuleRepo accReimSettingLimitRuleRepo;
    private final AccReimSettingLimitRuleDAO accReimSettingLimitRuleDAO;
    private final PrdOrgEmployeeService employeeService;

    @Override
    public PagingVO<AccReimSettingLimitVO> queryPaging(AccReimSettingLimitQuery query){
        return accReimSettingLimitDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingLimitVO> queryListDynamic(AccReimSettingLimitQuery query){
        return accReimSettingLimitDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingLimitVO queryByKey(Long key) {
        AccReimSettingLimitDO entity = accReimSettingLimitRepo.findById(key).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingLimitVO vo = AccReimSettingLimitConvert.INSTANCE.toVo(entity);
        // 查询基础配置表
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.LODGE_OVERAGE.getCode());
        List<AccReimSettingVO> accReimSettingVOS = accReimSettingService.queryListDynamic(accReimSettingQuery);
        if(!CollectionUtils.isEmpty(accReimSettingVOS)){
            vo.setAccReimSettingVO(accReimSettingVOS.get(0));
        }
        AccReimSettingLimitRuleQuery accReimSettingLimitRuleQuery = new AccReimSettingLimitRuleQuery();
        accReimSettingLimitRuleQuery.setReimSettingLimitId(key);
        // 查询配置明细表
        List<AccReimSettingLimitRuleVO> accReimSettingLimitRuleVOS = accReimSettingLimitRuleService.queryListDynamic(accReimSettingLimitRuleQuery);
        vo.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingLimitVO insert(AccReimSettingLimitPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 保存当前配置表
        AccReimSettingLimitDO entityDo = AccReimSettingLimitConvert.INSTANCE.toDo(payload);
        AccReimSettingLimitVO accReimSettingLimitVO = AccReimSettingLimitConvert.INSTANCE.toVo(accReimSettingLimitRepo.save(entityDo));
        // 保存基础配置表
        Long id = accReimSettingLimitVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.LODGE_OVERAGE.getCode());
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingDO));
        accReimSettingLimitVO.setAccReimSettingVO(accReimSettingVO);
        // 保存配置明细表
        List<AccReimSettingLimitRulePayload> accReimSettingLimitRulePayloadList = payload.getAccReimSettingLimitRulePayloadList();
        accReimSettingLimitRulePayloadList.stream().forEach(e->e.setReimSettingLimitId(id));
        if(!accReimSettingLimitRulePayloadList.isEmpty()){
            List<AccReimSettingLimitRuleDO> accReimSettingLimitRuleDOS = AccReimSettingLimitRuleConvert.INSTANCE.toDoList(accReimSettingLimitRulePayloadList);
            List<AccReimSettingLimitRuleVO> accReimSettingLimitRuleVOS = AccReimSettingLimitRuleConvert.INSTANCE.toVoList(accReimSettingLimitRuleRepo.saveAll(accReimSettingLimitRuleDOS));
            accReimSettingLimitVO.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        }
        return accReimSettingLimitVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingLimitVO update(AccReimSettingLimitPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        // 删除明细
        List<Long> deleteAccReimSettingOverdueDiscuntKeys = payload.getDeleteAccReimSettingLimitRuleKeys();
        if(!CollectionUtils.isEmpty(deleteAccReimSettingOverdueDiscuntKeys)){
            accReimSettingLimitRuleDAO.deleteSoft(deleteAccReimSettingOverdueDiscuntKeys);
        }
        AccReimSettingLimitDO entity = accReimSettingLimitRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingLimitDO entityDo = AccReimSettingLimitConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingLimitVO accReimSettingLimitVO = AccReimSettingLimitConvert.INSTANCE.toVo(accReimSettingLimitRepo.save(entity));
        // 保存基础配置表
        AccReimSettingDO accReimSettingEntity = accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull(accReimSettingEntity.getId(), "不存在");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingLimitVO.setAccReimSettingVO(accReimSettingVO);

        //保存子表数据,三种情况，新增，修改，删除
        List<AccReimSettingLimitRulePayload> accReimSettingLimitRulePayloadList = payload.getAccReimSettingLimitRulePayloadList();
        if(!accReimSettingLimitRulePayloadList.isEmpty()){
            List<AccReimSettingLimitRuleDO> accReimSettingLimitRuleDOS = AccReimSettingLimitRuleConvert.INSTANCE.toDoList(accReimSettingLimitRulePayloadList);
            List<AccReimSettingLimitRuleVO> accReimSettingLimitRuleVOS= new ArrayList<>();
            for (AccReimSettingLimitRuleDO accReimSettingLimitRuleDO : accReimSettingLimitRuleDOS) {
                if(accReimSettingLimitRuleDO.getId()!=null){
                    AccReimSettingLimitRuleDO accReimSettingLimitRuleEntity = accReimSettingLimitRuleRepo.findById(accReimSettingLimitRuleDO.getId()).orElseGet(AccReimSettingLimitRuleDO::new);
                    Assert.notNull(entity.getId(), "不存在");
                    accReimSettingLimitRuleEntity.copy(accReimSettingLimitRuleDO);
                    accReimSettingLimitRuleVOS.add(AccReimSettingLimitRuleConvert.INSTANCE.toVo(accReimSettingLimitRuleRepo.save(accReimSettingLimitRuleEntity)));
                }else{
                    accReimSettingLimitRuleDO.setReimSettingLimitId(payload.getId());
                    accReimSettingLimitRuleVOS.add(AccReimSettingLimitRuleConvert.INSTANCE.toVo(accReimSettingLimitRuleRepo.save(accReimSettingLimitRuleDO)));
                }
            }
            accReimSettingLimitVO.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        }

        return accReimSettingLimitVO;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingLimitPayload payload) {
        AccReimSettingLimitDO entity = accReimSettingLimitRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimSettingLimitDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimSettingLimitDAO.deleteSoft(keys);
        }
    }

    @Override
    public AccReimSettingLimitVO ruleCheck(Long key, Long reimUserId,BigDecimal reimAmt, String expensePlaceGrade) {
        expensePlaceGrade=expensePlaceGrade==null?"3":expensePlaceGrade;
        AccReimSettingLimitVO accReimSettingLimitVO = queryByKey(key);
        AccReimSettingVO accReimSettingVO = accReimSettingLimitVO.getAccReimSettingVO();
        // 剔除白名单人员
        String whiteList = accReimSettingVO.getWhiteList();
        if(StringUtils.hasText(whiteList)){
            List<Long> idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //报销人
            if(idList.contains(reimUserId)){
                return accReimSettingLimitVO;
            }
        }
        // 获取当前人的专业级别以及管理级别
        PrdOrgEmployeeVO employeeVO = employeeService.queryByUserId(reimUserId);
        String professionalGrade = employeeVO.getExtString1();//专业级别
        String manageGrade = employeeVO.getExtString2();//管理级别

        List<AccReimSettingLimitRuleVO> accReimSettingLimitRuleVOList = accReimSettingLimitVO.getAccReimSettingLimitRuleVOList();
        for (AccReimSettingLimitRuleVO accReimSettingLimitRuleVO : accReimSettingLimitRuleVOList) {
            boolean thisSetting =false;
            //优先匹配管理级别，其次匹配专业级别
            if(StringUtils.hasText(manageGrade) && StringUtils.hasText(accReimSettingLimitRuleVO.getManageGrade())){
                List<String> collect = Arrays.stream(accReimSettingLimitRuleVO.getManageGrade().split(",")).collect(Collectors.toList());
                if(collect.contains(manageGrade)){
                    thisSetting=true;
                }
            }else if(StringUtils.hasText(professionalGrade) && StringUtils.hasText(accReimSettingLimitRuleVO.getProfessionalGrade())){
                List<String> collect = Arrays.stream(accReimSettingLimitRuleVO.getProfessionalGrade().split(",")).collect(Collectors.toList());
                if(collect.contains(professionalGrade)){
                    thisSetting=true;
                }
            }
            if (thisSetting){
                BigDecimal limit =BigDecimal.ZERO;
                //获取额度
                switch (expensePlaceGrade){
                    case "1":
                        limit = accReimSettingLimitRuleVO.getMegacitiesLimit();
                        break;
                    case "2":
                        limit = accReimSettingLimitRuleVO.getFirstTierCityLimit();
                        break;
                    case "3":
                        limit = accReimSettingLimitRuleVO.getOtherLimit();
                        break;
                }
                // 返回主表报销额度
                accReimSettingLimitVO.setReimLimit(limit);
                // 将额度于报销金额进行对比
                if(reimAmt.compareTo(limit)>0){
                    accReimSettingLimitVO.setExcessLimit(true);//表示超额了
                    if(accReimSettingVO.getRemindText()!=null){
                        accReimSettingVO.setRemindText(accReimSettingVO.getRemindText().replace("#{1}",limit.toString()));
                    }
                    if(accReimSettingVO.getErrorText()!=null){
                        accReimSettingVO.setErrorText(accReimSettingVO.getErrorText().replace("#{1}",limit.toString()));
                    }
                }
                break;
            }
        }
        return accReimSettingLimitVO;
    }

}
