package com.elitesland.tw.tw5.server.prd.copartner.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
@Api(tags = "合伙人绩效自述配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/copartner/performanceReadmeConfig")
@Slf4j
public class PerformanceReadmeConfigController {

    private final PerformanceReadmeConfigService performanceReadmeConfigService;

    /**
     * 合伙人绩效自述配置-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合伙人绩效自述配置-新增或修改")
    public TwOutputUtil<PerformanceReadmeConfigVO> insertOrUpdate(@RequestBody PerformanceReadmeConfigPayload payload) {
        return TwOutputUtil.ok(performanceReadmeConfigService.insertOrUpdate(payload));
    }


    /**
     * 合伙人绩效自述配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("合伙人绩效自述配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PerformanceReadmeConfigPayload payload) {
        return TwOutputUtil.ok(performanceReadmeConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 合伙人绩效自述配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述配置-主键查询")
    public TwOutputUtil<PerformanceReadmeConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(performanceReadmeConfigService.queryByKey(key));
    }

    /**
     * 合伙人绩效自述配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述配置-分页")
    public TwOutputUtil<PagingVO<PerformanceReadmeConfigVO>> paging(PerformanceReadmeConfigQuery query) {
        return TwOutputUtil.ok(performanceReadmeConfigService.queryPaging(query));
    }

    /**
     * 合伙人绩效自述配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述配置-查询列表")
    public TwOutputUtil<List<PerformanceReadmeConfigVO>> queryList(PerformanceReadmeConfigQuery query) {
        return TwOutputUtil.ok(performanceReadmeConfigService.queryListDynamic(query));
    }

    /**
     * 合伙人绩效自述配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合伙人绩效自述配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        performanceReadmeConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 合伙人绩效自述配置-发起考核
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/startAssessment/{key}")
    // @UdcNameClass
    @ApiOperation("合伙人绩效自述配置-发起考核")
    public TwOutputUtil<PerformanceReadmeConfigVO> startAssessment(@PathVariable Long key) {
        performanceReadmeConfigService.startAssessment(key);
        return TwOutputUtil.ok();
    }

}

