package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityReviewPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityReviewQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityReviewVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityReviewDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityReviewDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityReviewRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityReviewDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityReviewRepo repo;
    private final QCrmOpportunityReviewDO qdo = QCrmOpportunityReviewDO.crmOpportunityReviewDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityReviewVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmOpportunityReviewVO.class,
                qdo.id,
                qdo.oppoId,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 风险类型
                qdo.riskType,
                // 风险点描述
                qdo.riskDesc,
                // 应对计划
                qdo.answerPlan,
                // 开始时间
                qdo.planEndTime,
                // 负责人
                qdo.directorUserId,
                // 已完成、未完成、进行中
                qdo.finishState
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityReviewVO> getJpaQueryWhere(CrmOpportunityReviewQuery query) {
        JPAQuery<CrmOpportunityReviewVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(CrmOpportunityReviewQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
            .select(qdo.count())
            .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(CrmOpportunityReviewQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 风险类型 精确 */
        if (!ObjectUtils.isEmpty(query.getRiskType())) {
            list.add(qdo.riskType.eq(query.getRiskType()));
        }
        /** 风险点描述 精确 */
        if (!ObjectUtils.isEmpty(query.getRiskDesc())) {
            list.add(qdo.riskDesc.eq(query.getRiskDesc()));
        }
        /** 应对计划 精确 */
        if (!ObjectUtils.isEmpty(query.getAnswerPlan())) {
            list.add(qdo.answerPlan.eq(query.getAnswerPlan()));
        }
        /** 开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndTime())) {
            list.add(qdo.planEndTime.eq(query.getPlanEndTime()));
        }
        /** 负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getDirectorUserId())) {
            list.add(qdo.directorUserId.eq(query.getDirectorUserId()));
        }
        /** 已完成、未完成、进行中 精确 */
        if (!ObjectUtils.isEmpty(query.getFinishState())) {
            list.add(qdo.finishState.eq(query.getFinishState()));
        }
        /** 关联商机id */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
            list.add(qdo.oppoId.eq(query.getOppoId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmOpportunityReviewVO queryByKey(Long id) {
        JPAQuery<CrmOpportunityReviewVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmOpportunityReviewVO> queryListDynamic(CrmOpportunityReviewQuery query) {
        JPAQuery<CrmOpportunityReviewVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOpportunityReviewVO> queryPaging(CrmOpportunityReviewQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<CrmOpportunityReviewVO> jpaQuery = getJpaQueryWhere(query);
        List<CrmOpportunityReviewVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<CrmOpportunityReviewVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityReviewDO save(CrmOpportunityReviewDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmOpportunityReviewDO> saveAll(List<CrmOpportunityReviewDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmOpportunityReviewPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 风险类型
        if (payload.getRiskType() != null) {
            update.set(qdo.riskType, payload.getRiskType());
        }
        // 风险点描述
        if (payload.getRiskDesc() != null) {
            update.set(qdo.riskDesc, payload.getRiskDesc());
        }
        // 应对计划
        if (payload.getAnswerPlan() != null) {
            update.set(qdo.answerPlan, payload.getAnswerPlan());
        }
        // 开始时间
        if (payload.getPlanEndTime() != null) {
            update.set(qdo.planEndTime, payload.getPlanEndTime());
        }
        // 负责人
        if (payload.getDirectorUserId() != null) {
            update.set(qdo.directorUserId, payload.getDirectorUserId());
        }
        // 已完成、未完成、进行中
        if (payload.getFinishState() != null) {
            update.set(qdo.finishState, payload.getFinishState());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 风险类型
            if (nullFields.contains("riskType")) {
                update.setNull(qdo.riskType);
            }
            // 风险点描述
            if (nullFields.contains("riskDesc")) {
                update.setNull(qdo.riskDesc);
            }
            // 应对计划
            if (nullFields.contains("answerPlan")) {
                update.setNull(qdo.answerPlan);
            }
            // 开始时间
            if (nullFields.contains("planEndTime")) {
                update.setNull(qdo.planEndTime);
            }
            // 负责人
            if (nullFields.contains("directorUserId")) {
                update.setNull(qdo.directorUserId);
            }
            // 已完成、未完成、进行中
            if (nullFields.contains("finishState")) {
                update.setNull(qdo.finishState);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

