package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.*;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.ListCompareUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityCheckStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.*;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author carl.wang
 * @Description 商机管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityServiceImpl extends BaseServiceImpl implements CrmOpportunityService {
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmOpportunityDAO dao;
    private final CrmOpportunityRepo repo;
    private final CrmActActivityDAO activityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final CrmOppoConversionRateService crmOppoConversionRateService;
    private final CrmOpportunityAnalyzeService opportunityAnalyzeService;//案情分析
    private final CrmOpportunityCompetitorService opportunityCompetitorService;//竞争对手
    private final CrmOpportunityStakeholderService opportunityStakeholderService;//干系人
    private final CrmOpportunityMilestonePlanService opportunityMilestonePlanService;//里程碑计划
    private final BusinessPartnerService businessPartnerService;
    private final CrmFollowService followService;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    //    private final CrmCustomerDAO crmCustomerDAO;
//    private final CrmCustomerService customerService;
//    private final PrdAbDAO abDAO;
    private final YeedocService yeedocService;
    private final YeedocProperties yeedocProperties;
    private final CrmLeadsDAO leadsDAO;
    private final UdcUtil udcUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CalResourceService calResourceService;
    @Autowired
    private PrdUserService prdUserService;

    private final PrdOrgOrganizationService prdOrgOrganizationService;

    @Value("${tw4.opportunity.operation}")
    private String opportunity_operation;

    @Value("${tw4.opportunity.operation_close}")
    private String opportunity_operation_close;

    @Value("${tw4.opportunity.operation_change_status}")
    private String opportunity_operation_updateStatus;

    private static final String[] sapBuSystemRoleCodes = {"BD0020", "BD0031", "BD0035", "BD0037", "BD0036", "BD0030", "BD0021", "BD0039", "BD0041"};
    private BeanSearcher beanSearcher;

    private final CalAccountService calAccountService;
    private final TaskCommonService taskCommonService;

    private final YeedocUtils yeedocUtils;

    @Autowired
    @Lazy
    private BudgetCommonService budgetCommonService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public CrmOpportunityVO insert(CrmOpportunityPayload payload) {
        //翻译4.0相关字段
//        payload = transferV4(payload);
        if (payload.getIsNeedPartner() == null) {
            payload.setIsNeedPartner(0);
        }
        //获取编号
        String code = generateSeqNum("OPPORTUNITY");
        payload.setProjectNo(code);
//        Map<String, Object> map = new HashMap<>();
        //同步到4.0
//        if(payload.getInternalUserIdV4()!=null){
//            //如果从4.0请求过来的数据,直接转
//            map = BeanUtil.beanToMap(payload);
//        }else{
//        map = transferUtilService.beanToMap(payload);
        //翻译关联的线索id
//        Long leadsId = payload.getLeadsId();
//        if (leadsId != null) {
//            CrmLeadsDO leadsDO = leadsDAO.queryById(leadsId);
//            map.put("leadsId", leadsDO.getLeadsIdV4());
//        }

//        }
        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
//        map.put("createUserId", employeeDAO.getV4UserId(userId));

//        String result = httpUtil.sendSyncPost(opportunity_operation, map);
//        String oppoId = httpUtil.geResultData(result);
//        long oppoIdV4 = 0;
//        if (StringUtils.hasText(oppoId)) {
//            if (StringUtil.isInteger(oppoId)) {
//                oppoIdV4 = Long.valueOf(oppoId);
//            }
//        }
//
        //保存项目
        PrjProjectDO ado = CrmOpportunityConvert.INSTANCE.toProjectDo(payload);
        ado.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        ado.setProjectType(CrmFollowObjectEnum.Opportunity.getCode());
        ado.setProjectNo(code);
        ado = projectDAO.save(ado);

        CrmOpportunityDO crmOpportunityDO = CrmOpportunityConvert.INSTANCE.toDo(payload);
        crmOpportunityDO.setProjectId(ado.getId());
//        crmOpportunityDO.setOppoIdV4(oppoIdV4);
        crmOpportunityDO.setCheckStatus(CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode());
        crmOpportunityDO = dao.save(crmOpportunityDO);

        logService.saveNewLog(crmOpportunityDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        //把创建人和负责人等添加为团队成员
        List<Long> userIds = new ArrayList<>();
        userIds.add(ado.getCreateUserId());
        userIds.add(ado.getManageUserId());
        userIds.add(crmOpportunityDO.getPreSaleUserId());
        userIds.add(crmOpportunityDO.getDeliUserId());
        userIds.add(crmOpportunityDO.getCoUserId());
        userIds.add(crmOpportunityDO.getCodeliUserId());
        userIds = userIds.stream().filter(Objects::nonNull).collect(Collectors.toList());
        addProjectMember(ado.getId(), userIds);
        //创建商机项目账户
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.OPP.getCode());
        accountPayload.setAuId(ado.getId());
        accountPayload.setLedgerName(ado.getProjectName());
        accountPayload.setLedgerNo(ado.getProjectNo());
        calAccountService.insert(accountPayload);
        return CrmOpportunityConvert.INSTANCE.toVo(crmOpportunityDO);
    }

    @Deprecated
    private CrmOpportunityPayload transferV4(CrmOpportunityPayload payload) {
//        if (payload.getCustBookIdV4() != null) {
//            payload.setCustBookId(abDAO.getIdByV4(payload.getCustBookIdV4()));
//        }
        if (payload.getOrgIdV4() != null) {
            payload.setOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getOrgIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        if (payload.getCoOrgIdV4() != null) {
            payload.setCoOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCoUserIdV4() != null) {
            payload.setCoUserId(employeeDAO.getUserIdByV4(payload.getCoUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getDeliUserIdV4() != null) {
            payload.setDeliUserId(employeeDAO.getUserIdByV4(payload.getDeliUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getCodeliOrgIdV4() != null) {
            payload.setCodeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCodeliUserIdV4() != null) {
            payload.setCodeliUserId(employeeDAO.getUserIdByV4(payload.getCodeliUserIdV4()));
        }
        if (payload.getInternalUserIdV4() != null) {
            payload.setInternalUserId(employeeDAO.getUserIdByV4(payload.getInternalUserIdV4()));
        }
        if (payload.getInternalOrgIdV4() != null) {
            payload.setInternalOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getInternalOrgIdV4()));
        }
        if (payload.getPreSaleOrgIdV4() != null) {
            payload.setPreSaleOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getPreSaleOrgIdV4()));
        }
        if (payload.getPreSaleUserIdV4() != null) {
            payload.setPreSaleUserId(employeeDAO.getUserIdByV4(payload.getPreSaleUserIdV4()));
        }
        return payload;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long update(CrmOpportunityPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getId());
        checkUpdate(project);
        Map<String, List<Long>> userMangeIds = getUserMangeIds(payload, project);
        List<Long> addIds = userMangeIds.get("addIds");
        List<Long> deleteIds = userMangeIds.get("deleteIds");

        CrmOpportunityVO opportunityVO = dao.queryByKey(payload.getId());

//        String detail = GlobalUtil.getContantsLog(PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc(), opportunityVO.getContactName(), payload.getContactName(), opportunityVO.getContactPhone(), payload.getContactPhone());
        // CrmOpportunityDO oppoDO = repo.findById(payload.getId()).get();
        CrmOpportunityVO oldEntity = new CrmOpportunityVO();
        BeanUtils.copyProperties(opportunityVO, oldEntity);

        CrmOpportunityConvert.INSTANCE.copy(payload, opportunityVO);
        opportunityVO.setProjectId(project.getId());
        opportunityVO.setOppoIdV4(project.getOppoIdV4());
        payload.setProjectId(project.getId());
        payload.setOppoIdV4(project.getOppoIdV4());
        String changeLog = changeFieldLogUtil.getFieldsUpdateLog(opportunityVO, oldEntity);
        if (StringUtils.hasText(changeLog)) {
            logService.saveNewLog(opportunityVO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }

        //修改商机项目数据
        dao.updateProjectByKeyDynamic(payload, project.getId());
        //修改商机数据
        dao.updateByKeyDynamic(payload);
        deleteProjectMember(project.getId(), deleteIds, project.getOppoIdV4());
        addProjectMember(project.getId(), addIds);

        return 0L;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toggleCheckStatus(List<Long> ids) {
        List<CrmOpportunityDO> doList = repo.findAllById(ids);
        for (var oppoDO : doList) {
            CrmOpportunityDO oldEntity = new CrmOpportunityDO();
            BeanUtils.copyProperties(oppoDO, oldEntity);

            String newCheckStatus = toggleCheckStatus(oppoDO.getCheckStatus());
            oppoDO.setCheckStatus(newCheckStatus);
            repo.save(oppoDO);

            //获取变更日志
            String changeLog = changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
            if (StringUtils.hasText(changeLog)) {
                logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
            }
        }
    }

    private String toggleCheckStatus(String checkStatus) {
        if (CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.CHECKED.getCode();
        } else if (CrmOpportunityCheckStatusEnum.CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode();
        } else {
            return checkStatus;
        }
    }

    @Override
    public PagingVO<CrmOpportunityVO> paging(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = null;

//        Long userId = GlobalUtil.getLoginUserId();
        Long userId = query.getQueryUserId() == null ? GlobalUtil.getLoginUserId() : query.getQueryUserId();
        List<Long> sapPermissionOrgIdList = null;
        List<Long> orgManageIds = orgOrganizationDAO.queryByManageIdOrgIds(userId);
        // 部门下的成员包括当前登录人本人
        List<Long> oppoUserIds = new ArrayList<>();
        // 判断当前登录人是否是系统管理员or销售管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            oppoUserIds = null;
        } else {
            boolean hasSapBuPermission = cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
            if (hasSapBuPermission) {
                List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(userId);
                List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                    sapPermissionOrgIdList = orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                    //查询所有子部门
                    Set<Long> childOrgs = orgOrganizationDAO.queryAllChildOrgs(sapPermissionOrgIdList.stream().collect(Collectors.toSet()));
                    sapPermissionOrgIdList.addAll(childOrgs);
                }
            }
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                //查询部门下的成员
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                oppoUserIds = Collections.singletonList(userId);
            }
        }
        opportunityVO = dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        //  }
        List<CrmOpportunityVO> opportunitys = opportunityVO.getRecords();
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Set<Long> bookIds = new HashSet<>();
        Set<Long> formalCustomerIds = new HashSet<>();
        for (CrmOpportunityVO vo : opportunitys) {
            transferSystemSelection(vo);
            getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        }
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));
        List<Map<String, Object>> books = dao.queryBooks(bookIds);
        Map<Long, String> bookMap = new HashMap<>();
        books.forEach(book -> bookMap.put(Long.valueOf(book.get("book_id") + ""), (String) book.get("bookName")));
        Map<Long, List<BusinessPartnerVO>> customerMapTmp = new HashMap<>();
        if (!CollectionUtils.isEmpty(formalCustomerIds)) {
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryListByIds(new ArrayList<>(formalCustomerIds));
            if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
                customerMapTmp = businessPartnerVOS.stream().collect(Collectors.groupingBy(BusinessPartnerVO::getId));
            }
        }
        final Map<Long, List<BusinessPartnerVO>> customerMap = customerMapTmp;
        opportunitys.forEach(opportunity -> transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, opportunity));
        return opportunityVO;
    }


    private void allChildrenOrgId(Long parentOrgId, List<Long> childrenOrgIdList) {
        List<PrdOrgOrganizationRefDO> childrenOrgRefList = orgOrganizationDAO.queryAllByParentId(parentOrgId);
        if (CollectionUtils.isEmpty(childrenOrgRefList)) {
            return;
        }
        for (var orgRef : childrenOrgRefList) {
            childrenOrgIdList.add(orgRef.getOrgId());
            allChildrenOrgId(orgRef.getOrgId(), childrenOrgIdList);
        }
    }

    @Override
    public List<CrmOpportunityListVO> queryList() {
        return dao.queryList();
    }

    @Override
    public List<CrmOpportunityListVO> queryListDynamic(CrmOpportunityQuery query) {
        //   query.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        List<CrmOpportunityListVO> crmOpportunityListVOS = dao.queryListDynamic(query);
        //已通过自动翻译实现客户名称翻译
//        if (crmOpportunityListVOS.size() > 0) {
//            List<Long> collect = crmOpportunityListVOS.stream().filter(vo -> vo.getCustBookId() != null).map(CrmOpportunityListVO::getCustBookId).distinct().collect(Collectors.toList());
//            Map<Long, String> bookNames = businessPartnerService.findNameByBookIds(collect);
//            crmOpportunityListVOS.forEach(vo -> {
//                if (vo.getCustBookId() != null) {
//                    vo.setCustBookName(bookNames.get(vo.getCustBookId()));
//                }
//            });
//        }
        return crmOpportunityListVOS;
    }

    @Override
    public List<CrmOpportunityListVO> querySimpleList(CrmOpportunityQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public CrmOpportunityVO queryByKey(Long key) {
        CrmOpportunityVO vo = dao.queryByKey(key);
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        transferSystemSelection(vo);
        Set<Long> bookIds = new HashSet<>();
        Set<Long> formalCustomerIds = new HashSet<>();
        getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));

        List<Map<String, Object>> books = dao.queryBooks(bookIds);
        Map<Long, String> bookMap = new HashMap<>();
        books.forEach(book -> bookMap.put(Long.valueOf(book.get("book_id") + ""), (String) book.get("bookName")));
        Map<Long, List<BusinessPartnerVO>> customerMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(formalCustomerIds)) {
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryListByIds(new ArrayList<>(formalCustomerIds));
            if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
                customerMap = businessPartnerVOS.stream().collect(Collectors.groupingBy(BusinessPartnerVO::getId));
            }
        }
        transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, vo);
        //app要求返回合同的创建人和级别
        if (vo.getCreateUserId() != null) {
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getCreateUserId());
            if (employee != null) {
                vo.setGrade(employee.getExtString1());
            }
        }

        List<PrjProjectMemberVO> membersVOS = activityDAO.queryProjectMember(vo.getProjectId());
        if (membersVOS.size() > 0) {
            //获取任务包数量，为了功能解耦暂不关联查
            List<Long> resIds = membersVOS.stream().map(PrjProjectMemberVO::getUserId).distinct().collect(Collectors.toList());
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            taskPackageQuery.setReasonId(vo.getProjectId());
            taskPackageQuery.setReceiverResIds(resIds);
            List<TaskPackageVO> taskPackageVOS = taskCommonService.queryTaskPackageList(taskPackageQuery);
            Map<Long, List<TaskPackageVO>> mapList = taskPackageVOS.stream().collect(Collectors.groupingBy(TaskPackageVO::getReceiverResId));
            membersVOS.forEach(membersVO -> {
                membersVO.setTaskPackageCount(0);
                List<TaskPackageVO> taskPackageVOS1 = mapList.get(membersVO.getUserId());
                if (!ObjectUtils.isEmpty(taskPackageVOS1)) {
                    membersVO.setTaskPackageCount(taskPackageVOS1.size());
                }
            });
        }

        vo.setMemberVOS(membersVOS);
        /**
         * 商机外包费用权限控制
         * 1.管理员和平台角色可看所有
         * 2.签单bu可以看
         */
//        Long userId = GlobalUtil.getLoginUserId();
//        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
//        String isShow1 = "0";
//        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
//            isShow1 = "1";
//        }
//        if (isShow1.equals("0")) {
//            PrdOrgOrganizationDO prdOrgOrganizationDO = orgOrganizationDAO.queryById(vo.getOrgId());
//            if (prdOrgOrganizationDO.getManageId() != null && prdOrgOrganizationDO.getManageId().longValue() == userId.longValue()) {
//                isShow1 = "1";
//            }
//        }
//        vo.setIsShow1(isShow1);
        this.transferMarketChannel(vo);
        if (!ObjectUtils.isEmpty(vo.getDemandProductOrg())) {
            vo.setDemandProductOrgDesc(cacheUtil.transferSystemSelection("BU", vo.getDemandProductOrg().toString()));
        }
//        Map<String, String> probabilityMap = caculateProbability(vo);
//        vo.setProbability(probabilityMap.get("data"));
//        vo.setProbabilityHint(probabilityMap.get("probabilityHint"));
        // 查询签单BU负责人，现在商机外包费用的权限用这个来控制
        if (vo.getOrgId() != null) {
            vo.setSignBuManagerUserId(prdOrgOrganizationService.queryManageIdById(vo.getOrgId()));
        }

        Long loginUserId = GlobalUtil.getLoginUserId();
        checkPersonPlanAuth(vo, loginUserId);
        return vo;
    }

    @Override
    public CrmOpportunityVO queryByOppoProjId(Long key) {
        return dao.queryByOppoProjId(key);
    }

    @Override
    @Transactional
    public Map<String, String> caculateProbability(Long key) {
        CrmOpportunityVO vo = dao.queryByKey(key);
        Map<String, String> result = new HashMap<>();
        // 查询商机成单率配置
        CrmOppoConversionRateVO resultVO = crmOppoConversionRateService.queryConfig();
        List<CrmOpportunityMeasureVO> crmOpportunityMeasureVOS = resultVO.getCrmOpportunityMeasureVOS();
        Boolean isEffective = true;
        String probabilityHint = "";
        BigDecimal probabilityValue = BigDecimal.ZERO;
        // 循环对每一个配置字段进行处理
        for (CrmOpportunityMeasureVO crmOpportunityMeasureVO : crmOpportunityMeasureVOS) {
            Boolean isEffectiveCheck = false;
            BigDecimal score = BigDecimal.ZERO;
            // 获取该商机对象当前配置字段的值
            String oppoTableField = crmOpportunityMeasureVO.getOppoTableFields();
            Object fieldValue = BeanUtil.getAllFieldValueByFieldName(oppoTableField, vo);
            if (ObjectUtils.isEmpty(fieldValue)) {
                probabilityHint = probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "信息缺失；";
                isEffective = false;
                break;
            }
            // 商机数据源字段表ID
            Long dataSourceFieldsId = crmOpportunityMeasureVO.getDataSourceFieldsId();
            CrmOppoDataSourceFieldsVO crmOppoDataSourceFieldsVO = crmOppoConversionRateService.queryDataSourceFieldsById(dataSourceFieldsId);
            // 获取配置明细,通过
            List<CrmOpportunityMeasureDVO> crmOpportunityMeasureDVOS = crmOpportunityMeasureVO.getCrmOpportunityMeasureDVOS();
            // 判断字段类型
            if (crmOppoDataSourceFieldsVO.getType().equals("选项类型")) {
//                String fieldOptionValue = "";
                // 拉取选项列表
//                PrdSystemSelectionVO view = cacheUtil.getSystemSelection(crmOppoDataSourceFieldsVO.getSelectionKey());
//                if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
//                    throw TwException.error("", "选择项值为空");
//                }
//                List<PrdSystemSelectionVO> children = view.getChildren();
//                for (PrdSystemSelectionVO child : children) {
//                    if (child.getSelectionValue().equals(fieldValue)) {
//                        fieldOptionValue = child.getSelectionName();
//                        break;
//                    }
//                }
                for (CrmOpportunityMeasureDVO crmOpportunityMeasureDVO : crmOpportunityMeasureDVOS) {
                    if (crmOpportunityMeasureDVO.getFieldOptionValue().equals(fieldValue)) {
                        score = crmOpportunityMeasureDVO.getScore();
                        isEffectiveCheck = true;
                        break;
                    }
                }
                if (!isEffectiveCheck) {
                    probabilityHint = probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "无匹配选项；";
                }
            } else if (crmOppoDataSourceFieldsVO.getType().equals("数值类型")) {
                BigDecimal numericalValue = BigDecimal.ZERO;
                // 当前值就是数值的结果
                if (!ObjectUtils.isEmpty(fieldValue)) {
                    numericalValue = new BigDecimal(fieldValue.toString());
                }
                for (CrmOpportunityMeasureDVO crmOpportunityMeasureDVO : crmOpportunityMeasureDVOS) {
                    if (crmOpportunityMeasureDVO.getNumericalValueMin().compareTo(numericalValue.divide(BigDecimal.valueOf(10000))) < 1 &&
                            crmOpportunityMeasureDVO.getNumericalValueMax().compareTo(numericalValue.divide(BigDecimal.valueOf(10000))) > -1
                    ) {
                        score = crmOpportunityMeasureDVO.getScore();
                        isEffectiveCheck = true;
                        break;
                    }

                }
                if (!isEffectiveCheck) {
                    probabilityHint = probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "超出了有效的指标区间；";
                }
            }
            if (!isEffectiveCheck) {
                isEffective = false;
                break;
            } else {
                probabilityValue = probabilityValue.add(score.multiply(crmOpportunityMeasureVO.getWeights().divide(BigDecimal.valueOf(100))));
            }
        }

        // 根据结果插入选项值
        if (!isEffective) {
            //结果为不清楚
            result.put("data", "U");
            result.put("probabilityHint", probabilityHint);
        } else {
            List<CrmOpportunityScoreConfigVO> scoreConfigVOS = resultVO.getScoreConfigVOS();
            for (CrmOpportunityScoreConfigVO scoreConfigVO : scoreConfigVOS) {
                if (scoreConfigVO.getScoreMin().compareTo(probabilityValue) < 1 &&
                        scoreConfigVO.getScoreMax().compareTo(probabilityValue) > -1
                ) {
                    result.put("data", scoreConfigVO.getProbabilityName());
                }
            }
        }
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(key);
        opportunityPayload.setProbability(result.get("data"));
        opportunityPayload.setProbabilityHint(result.get("probabilityHint"));
        dao.updateByKeyDynamic(opportunityPayload);
        return result;
    }


    @Transactional
    @Override
    public boolean changeStatus(Long key) {

        //对于关闭的商机，只有售前负责人和商机打开关闭管理员才能重新打开，其他人无权打开
        CrmActProjectVO project = dao.queryProjectBykey(key);
        Long loginUserId = GlobalUtil.getLoginUserId();
        //签单BU
        PrdOrgOrganizationVO org = cacheUtil.getOrg(project.getOrgId());
        //售前BU
        PrdOrgOrganizationVO preSaleOrg = cacheUtil.getOrg(project.getPreSaleOrgId());
        if ((org == null || org.getManageId().longValue() != loginUserId.longValue()) && (preSaleOrg == null || preSaleOrg.getManageId().longValue() != loginUserId.longValue())) {
            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPPORTUNITY_CLOSE_OPEN.getCode()));
            if (!rolePermission) {
                throw TwException.error("", "无操作商机状态变更的权限！");
            }
        }
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            CrmOpportunityPayload payload = new CrmOpportunityPayload();
            payload.setNullFields(Arrays.asList("closeReason"));
            dao.updateProjectByKeyDynamic(payload, project.getId());
        } else {
            throw TwException.error("", "活动状态为激活/暂挂/关闭才可进行该操作");
        }
        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", project.getOppoIdV4());
//        map.put("projectStatus", status);
//        String result = httpUtil.sendSyncPost(opportunity_operation_updateStatus, map);
//        httpUtil.geResultData(result);

        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Opportunity.getDesc());

        dao.updateStatus(project.getId(), status);
        return true;
    }

    @Transactional
    @Override
    public boolean closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark, Boolean permissionFlag) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        //对于关闭的商机，只有售前负责人和商机打开关闭管理员才能重新打开，其他人无权打开
//        Long loginUserId = GlobalUtil.getLoginUserId();
//        if (project.getPreSaleUserId() == null || project.getPreSaleUserId().longValue() != loginUserId.longValue()) {
//            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPPORTUNITY_CLOSE_OPEN.getCode()));
//            if (!rolePermission) {
//                throw TwException.error("", "无操作权限");
//            }
//        }
        checkUpdate(project);

        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", project.getOppoIdV4());
//        map.put("closeReason", closeReason);
//        map.put("loseReason", loseReson);
//        map.put("clsoeRemark", clsoeRemark);
//        map.put("projectStatus", WorkFlowStatusEnum.CLOSED_WORK.getCode());
//        String result = httpUtil.sendSyncPost(opportunity_operation_close, map);
//        httpUtil.geResultData(result);


        CrmOpportunityPayload payload = new CrmOpportunityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReason);
        payload.setLoseReason(loseReson);
        payload.setClsoeRemark(clsoeRemark);
        dao.updateProjectByKeyDynamic(payload, project.getId());
        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CLOSE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
//        try {
//            //关闭商机账户
//            CalAccountVO calAccountVO = calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.OPP.getCode(), key);
//            calAccountService.closeAccount(calAccountVO.getId());
//        } catch (Exception ex) {
//            ex.printStackTrace();
//        }
        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        checkUpdate(project);
        List<Long> updateUserIds = getUserMangeIds(project);
        Long userId = GlobalUtil.getLoginUserId();
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "无添加团队成员权限");
        }
        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.ADD.getDesc() + "团队成员");
        addProjectMember(project.getId(), userIds);
        return activityDAO.queryProjectMember(project.getId());

    }

    /**
     * 执行数据库删除团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
//        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", tw4Oppid);
//        map.put("userIds", transferUtilService.queryEmployeeTw4Ids(userIds));
//        String result = httpUtil.sendSyncPost(opportunity_deleteMember, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");

        projectDAO.deleteMemberByUserId(projectId, userIds);
    }

    /**
     * 执行数据库添加团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds) {
        List<PrjProjectMemberVO> memberVOS = activityDAO.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = activityDAO.queryEmployee(collect);
        List<PrjProjectMemberDO> memberDOS = new ArrayList<>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        if (memberDOS.size() > 0) {
            //同步到4.0
//            Map<String, Object> map = new HashMap<>();
//            map.put("id", tw4Oppid);
//            map.put("userIds", transferUtilService.queryEmployeeTw4Ids(collect));
//            String result = httpUtil.sendSyncPost(opportunity_addMember, map);
//            httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");

            projectDAO.saveMemberAll(memberDOS);


            //判断是否创建初始化任务包
            PrdSystemSettingVO settingVO = cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode());
            if (settingVO != null && StringUtils.hasText(settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue())) {
                taskCommonService.batchCreatTaskPackage(PmsReasonTypeEnum.PROJ_OPPO.getCode(), projectId, userIds, null);
            }
        }
    }

    /**
     * 获取负责人ids
     *
     * @param project
     * @return
     */
    List<Long> getUserMangeIds(CrmActProjectVO project) {
        List<Long> updateUserIds = new ArrayList<>();
        //系统管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        updateUserIds.addAll(userIdsByRole);
        if (project.getManageUserId() != null) {//签单
            updateUserIds.add(project.getManageUserId());
        }
        if (project.getCodeliUserId() != null) {//副交付
            updateUserIds.add(project.getCodeliUserId());
        }
        if (project.getCoUserId() != null) {//副签单
            updateUserIds.add(project.getCoUserId());
        }
        if (project.getDeliUserId() != null) {//交付
            updateUserIds.add(project.getDeliUserId());
        }
        if (project.getPreSaleUserId() != null) {//售前
            updateUserIds.add(project.getPreSaleUserId());
        }
        if (project.getCreateUserId() != null) {//报备人
            updateUserIds.add(project.getCreateUserId());
        }
        return updateUserIds;
    }

    @Transactional
    @Override
    public boolean deleteMember(Long oppoId, List<Long> keys) {
        CrmActProjectVO project = dao.queryProjectBykey(oppoId);
        checkUpdate(project);
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> updateUserIds = getUserMangeIds(project);
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "无删除团队成员权限");
        }
        List<Long> userMemberIds = projectDAO.getUserIds(keys);

        if (updateUserIds.size() > 0 && updateUserIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "创建人或负责人不可删除");
        }
        //activityDAO.queryProjectMember(project.getId());
//        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", project.getOppoIdV4());
//        map.put("userIds", transferUtilService.queryEmployeeTw4Ids(projectDAO.getUserIds(keys)));
//        String result = httpUtil.sendSyncPost(opportunity_deleteMember, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");
        projectDAO.deleteMemberSoft(keys, updateUserIds);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.DELETE.getDesc() + "团队成员");

        return true;
    }

    @Override
    public void addFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getObjectId());
        checkUpdate(project);
        this.oppoFollowFileHandle(payload, project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
//        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", project.getOppoIdV4());
//        String result = httpUtil.sendSyncPost(opportunity_addFollow, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");


        followService.addFollow(payload);
        logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    @Override
    public void updateFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getObjectId());
        checkUpdate(project);
        this.oppoFollowFileHandle(payload, project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        followService.updateFollow(payload);
        logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }


    @Override
    public List<CrmFollowVO> queryListFollow(Long objectId) {
        return followService.queryFollowList(objectId, CrmFollowObjectEnum.Opportunity.name());
    }

    @Override
    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Opportunity.getCode());
        return logService.pageLog(query);
    }


    /**
     * 判断是否可操作
     *
     * @param project
     */
    void checkUpdate(CrmActProjectVO project) {
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "该活动已暂挂");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "活动已关闭");
        }
    }

    /**
     * 获取删除和添加的团队成员id
     *
     * @param payload
     * @param project
     */
    private Map<String, List<Long>> getUserMangeIds(CrmOpportunityPayload payload, CrmActProjectVO project) {
        Long manageUserId = project.getManageUserId();
        Long preSaleUserId = project.getPreSaleUserId();
        Long deliUserId = project.getDeliUserId();
        Long coUserId = project.getCoUserId();
        Long codeliUserId = project.getCodeliUserId();
        List<Long> existGroupIds = Arrays.asList(manageUserId, preSaleUserId, deliUserId, coUserId, codeliUserId).stream().filter(e -> e != null).collect(Collectors.toList());
        Long manageUserIdNew = payload.getManageUserId();
        Long preSaleUserIdNew = payload.getPreSaleUserId();
        Long deliUserIdNew = payload.getDeliUserId();
        Long coUserIdNew = payload.getCoUserId();
        Long codeliUserIdNew = payload.getCodeliUserId();
        List<Long> newGroupIds = Arrays.asList(manageUserIdNew, preSaleUserIdNew, deliUserIdNew, coUserIdNew, codeliUserIdNew).stream().filter(e -> e != null).collect(Collectors.toList());
        List<Long> deleteIds = ListCompareUtil.getDeleteList(newGroupIds, existGroupIds);
        List<Long> addIds = ListCompareUtil.getInsertList(newGroupIds, existGroupIds);
        Map<String, List<Long>> result = new HashMap<>();
        result.put("addIds", addIds);
        result.put("deleteIds", deleteIds);
        return result;
//        List<Long> updateUserIds = new ArrayList<>();
//        if (ObjectUtils.isEmpty(payload.getManageUserId())) {
//            if (!ObjectUtils.isEmpty(project.getManageUserId())) {
//                deleteIds.add(project.getManageUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getManageUserId())) {
//                if (payload.getManageUserId().longValue() != project.getManageUserId().longValue()) {
//                    addIds.add(payload.getManageUserId());
//                    deleteIds.add(project.getManageUserId());
//                    updateUserIds.add(payload.getManageUserId());
//                }
//            } else {
//                addIds.add(payload.getManageUserId());
//                updateUserIds.add(payload.getManageUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getPreSaleUserId())) {
//            if (!ObjectUtils.isEmpty(project.getPreSaleUserId())) {
//                deleteIds.add(project.getPreSaleUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getPreSaleUserId())) {
//                if (payload.getPreSaleUserId().longValue() != project.getPreSaleUserId().longValue()) {
//                    addIds.add(payload.getPreSaleUserId());
//                    deleteIds.add(project.getPreSaleUserId());
//                    updateUserIds.add(payload.getPreSaleUserId());
//                }
//            } else {
//                addIds.add(payload.getPreSaleUserId());
//                updateUserIds.add(payload.getPreSaleUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getDeliUserId())) {
//            if (!ObjectUtils.isEmpty(project.getDeliUserId())) {
//                deleteIds.add(project.getDeliUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getDeliUserId())) {
//                if (payload.getDeliUserId().longValue() != project.getDeliUserId().longValue()) {
//                    addIds.add(payload.getDeliUserId());
//                    deleteIds.add(project.getDeliUserId());
//                    updateUserIds.add(payload.getDeliUserId());
//                }
//            } else {
//                addIds.add(payload.getDeliUserId());
//                updateUserIds.add(payload.getDeliUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getCoUserId())) {
//            if (!ObjectUtils.isEmpty(project.getCoUserId())) {
//                deleteIds.add(project.getCoUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getCoUserId())) {
//                if (payload.getCoUserId().longValue() != project.getCoUserId().longValue()) {
//                    addIds.add(payload.getCoUserId());
//                    deleteIds.add(project.getCoUserId());
//                    updateUserIds.add(payload.getCoUserId());
//                }
//            } else {
//                addIds.add(payload.getCoUserId());
//                updateUserIds.add(payload.getCoUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getCodeliUserId())) {
//            if (!ObjectUtils.isEmpty(project.getCodeliUserId())) {
//                deleteIds.add(project.getCodeliUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getCodeliUserId())) {
//                if (payload.getCodeliUserId().longValue() != project.getCodeliUserId().longValue()) {
//                    addIds.add(payload.getCodeliUserId());
//                    deleteIds.add(project.getCodeliUserId());
//                    updateUserIds.add(payload.getCodeliUserId());
//                }
//            } else {
//                addIds.add(payload.getCodeliUserId());
//                updateUserIds.add(payload.getCodeliUserId());
//            }
//        }

//        return updateUserIds;
    }

    /**
     * 为数值赋值
     *
     * @param employeeMap
     * @param orgMap
     * @param vo
     */
    void transferOpportunityDatas(Map<Long, String> employeeMap, Map<Long, String> orgMap, Map<Long, String> bookMap, Map<Long, List<BusinessPartnerVO>> customerMap, CrmOpportunityVO vo) {
        vo.setManageUserName(employeeMap.get(vo.getManageUserId()));
        vo.setPreSaleUserName(employeeMap.get(vo.getPreSaleUserId()));
        vo.setDeliUserName(employeeMap.get(vo.getDeliUserId()));
        vo.setCoUserName(employeeMap.get(vo.getCoUserId()));
        vo.setCodeliUserName(employeeMap.get(vo.getCodeliUserId()));
        vo.setInternalUserName(employeeMap.get(vo.getInternalUserId()));
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));

        vo.setOrgName(orgMap.get(vo.getOrgId()));
        vo.setPreSaleOrgName(orgMap.get(vo.getPreSaleOrgId()));
        vo.setDeliOrgName(orgMap.get(vo.getDeliOrgId()));
        vo.setCoOrgName(orgMap.get(vo.getCoOrgId()));
        vo.setCodeliOrgName(orgMap.get(vo.getCodeliOrgId()));
        vo.setInternalOrgName(orgMap.get(vo.getInternalOrgId()));
        if (vo.getIsOldCust() != null && vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty(vo.getCustBookId())) {
            vo.setCustBookName(bookMap.get(vo.getCustBookId()));
        }
        if (vo.getIsNeedPartner() != null && vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty(vo.getCoopBookId())) {
            vo.setCoopBookName(bookMap.get(vo.getCoopBookId()));
        }
        this.transferMarketChannel(vo);
        if (!ObjectUtils.isEmpty(vo.getDemandProductOrg())) {
            vo.setDemandProductOrgDesc(cacheUtil.transferSystemSelection("BU", vo.getDemandProductOrg().toString()));
        }
        if (vo.getFormalCustomerId() != null && customerMap.containsKey(vo.getFormalCustomerId())) {
            vo.setCustomerStatus(customerMap.get(vo.getFormalCustomerId()).get(0).getCustomerStatus());
        }

    }

    /**
     * 获取所有相关用户id和组织id
     *
     * @param userIds
     * @param orgIds
     * @param vo
     */
    void getIdDatas(Set<Long> userIds, Set<Long> orgIds, Set<Long> bookIds, Set<Long> formalCustomerIds, CrmOpportunityVO vo) {
        Set<Long> users = new HashSet<>();
        users.add(vo.getManageUserId());
        users.add(vo.getPreSaleUserId());
        users.add(vo.getDeliUserId());
        users.add(vo.getCoUserId());
        users.add(vo.getCodeliUserId());
        users.add(vo.getInternalUserId());
        users.add(vo.getCreateUserId());
        userIds.addAll(users);

        Set<Long> orgs = new HashSet<>();
        orgs.add(vo.getOrgId());
        orgs.add(vo.getPreSaleOrgId());
        orgs.add(vo.getDeliOrgId());
        orgs.add(vo.getCoOrgId());
        orgs.add(vo.getCodeliOrgId());
        orgs.add(vo.getInternalOrgId());
        orgIds.addAll(orgs);

        Set<Long> books = new HashSet<>();
        if (vo.getIsOldCust() != null && vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty(vo.getCustBookId())) {
            books.add(vo.getCustBookId());
        }
        if (vo.getIsNeedPartner() != null && vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty(vo.getCoopBookId())) {
            books.add(vo.getCoopBookId());
        }
        if (!ObjectUtils.isEmpty(vo.getFormalCustomerId())) {
            formalCustomerIds.add(vo.getFormalCustomerId());
        }
        bookIds.addAll(books);
    }


    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(CrmOpportunityVO vo) {
        vo.setProjectStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setCustRegionName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustRegion.getCode(), vo.getCustRegion()));
        vo.setCustPropName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCustProp()));
        vo.setCustIdstName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustIdst()));
        // vo.setProbabilityName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmProbability.getCode(), vo.getProbability()));
        vo.setCurrCodeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrCode()));
        vo.setSalePhaseName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), vo.getSalePhase()));
        vo.setOppoLevelName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), vo.getOppoLevel()));
        vo.setProjectDifficultName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getProjectDifficult()));
        vo.setProjectImportanceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getProjectImportance()));
        vo.setSolutionDifficultyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getSolutionDifficulty()));
        vo.setSolutionImportanceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getSolutionImportance()));
        vo.setLoseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLoseReson.getCode(), vo.getLoseReason()));
        vo.setCloseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getCloseReason()));
//        vo.setCloseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getSourceType()));
    }

    /**
     * 市场渠道转换
     *
     * @param vo
     */
    private void transferMarketChannel(CrmOpportunityVO vo) {
        if (vo.getMarketChannel() != null) {
            String marketChannel = vo.getMarketChannel();
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
            } else {
                String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                String s2 = "";
                switch (split[0]) {
                    case "baidu":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                        break;
                    case "sem_360":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                        break;
                    case "offline_activity":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                        break;
                    case "thrid_party_data":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                        break;
                }
                vo.setMarketChannelDesc(s2.equals("") ? s1 : s1 + "/" + s2);
            }
        }
    }


    @Override
    public void downloadBatch(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }

        //定义文件名称
        String sheetName = "商机数据";
        PagingVO<CrmOpportunityVO> paging = paging(query);
        List<CrmOpportunityVO> records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            Integer isNeedPartner = record.getIsNeedPartner();
            String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
            record.setIsNeedPartnerStr(isNeedPartnerStr);
            record.setSourceType(record.getSourceType() == null ? null : record.getSourceType().equals("inside") ? "内部" : "外部");
            Integer isOldCust = record.getIsOldCust();
            String isOldCustStr = isOldCust == null ? "否" : isOldCust == 0 ? "是" : "否";
            record.setIsOldCustStr(isOldCustStr);

            List<PrjProjectMemberVO> memberVOS = record.getMemberVOS();
            if (memberVOS != null && !memberVOS.isEmpty()) {
                List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
                String members = String.join(",", collect);
                record.setMembers(members);
            }
            order++;
        }
        List<CrmOpportunityExcelExport> resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
        resultList = udcUtil.translateList(resultList);
        //  resultList.forEach(e -> e.setIsOldCust(e.getIsOldCustStr()));
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmOpportunityExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);

//        ClassPathResource classPathResource = new ClassPathResource("template/crmOpportunityBatch.xlsx");
//        PagingVO<CrmOpportunityVO> paging = paging(query);
//        List<CrmOpportunityVO> records = paging.getRecords();
//        InputStream inputStream = null;
//        try {
//            inputStream = new BufferedInputStream(classPathResource.getInputStream());
//            Workbook workbook = XSSFWorkbookFactory.create(inputStream);
//            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("商机数据");
//            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
//                int nextRow = 1;
//                for (CrmOpportunityVO dataPayload : records) {
//                    Row row = batchProjectSheet.createRow(nextRow);
//                    excelUtil.setCellValue(row, 0, nextRow); // 序号
//                    excelUtil.setCellValue(row, 1, dataPayload.getProjectName());// 项目名称
//                    excelUtil.setCellValue(row, 2, dataPayload.getProjectNo());// 项目编号
//                    excelUtil.setCellValue(row, 3, dataPayload.getManageUserName());// 签单负责人
//                    excelUtil.setCellValue(row, 4, dataPayload.getOrgName());// 签单bu
//                    excelUtil.setCellValue(row, 5, dataPayload.getProjectStatusName());// 项目状态
//
//                    excelUtil.setCellValue(row, 6, dataPayload.getCloseReasonName());// 关闭原因
//                    excelUtil.setCellValue(row, 7, dataPayload.getClsoeRemark());// 关闭备注
//                    excelUtil.setCellValue(row, 8, dataPayload.getLoseReasonName());// 丢单原因
//                    excelUtil.setCellValue(row, 9, dataPayload.getLeadsName());// 线索名称
//                    excelUtil.setCellValue(row, 10, dataPayload.getSaleProduct());// 销售产品
//                    excelUtil.setCellValue(row, 11, dataPayload.getCustRegionName());// 客户区域
//                    Integer isOldCust = dataPayload.getIsOldCust();
//                    String isOldCUstStr = isOldCust == null ? "否" : isOldCust == 0 ? "是" : "否";
//                    excelUtil.setCellValue(row, 12, isOldCUstStr);// 是否老客户
//                    excelUtil.setCellValue(row, 13, dataPayload.getCustBookName());// 客户名称
//                    excelUtil.setCellValue(row, 14, dataPayload.getCustProject());// 客户项目
//
//                    excelUtil.setCellValue(row, 15, dataPayload.getContactName());// 客户联系人
//                    excelUtil.setCellValue(row, 16, dataPayload.getContactDept());// 客户联系人部门
//                    excelUtil.setCellValue(row, 17, dataPayload.getContactPosition());// 客户联系人岗位
//                    excelUtil.setCellValue(row, 18, dataPayload.getContactWebsite());// 企业主页
//                    excelUtil.setCellValue(row, 19, dataPayload.getCustPropName());//客户性质
//                    excelUtil.setCellValue(row, 20, dataPayload.getCustIdstName());//客户行业
//                    excelUtil.setCellValue(row, 21, dataPayload.getForecastWinDate());// 预计成单日期
//                    excelUtil.setCellValue(row, 22, dataPayload.getForecastAmount());// 预计签单金额
//                    excelUtil.setCellValue(row, 23, dataPayload.getProbabilityName());// 成单概率
//                    excelUtil.setCellValue(row, 24, dataPayload.getCurrCodeName());//币种
//                    excelUtil.setCellValue(row, 25, dataPayload.getSalePhaseName());//销售阶段
//                    excelUtil.setCellValue(row, 26, dataPayload.getDeliveryAddress());// 交付地点
//                    excelUtil.setCellValue(row, 27, dataPayload.getOppoLevelName());// 商机级别
//                    Integer isNeedPartner = dataPayload.getIsNeedPartner();
//                    String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
//                    excelUtil.setCellValue(row, 28, isNeedPartnerStr);// 是否需要合作伙伴
//                    excelUtil.setCellValue(row, 29, dataPayload.getCoopBookName());// 关联合作伙伴名称
//                    excelUtil.setCellValue(row, 30, dataPayload.getPartnerDesc());// 合作伙伴描述
//                    excelUtil.setCellValue(row, 31, dataPayload.getPreSaleOrgName());//售前bu
//                    excelUtil.setCellValue(row, 32, dataPayload.getPreSaleUserName());// 售前负责人
//                    excelUtil.setCellValue(row, 33, dataPayload.getProjectDifficultName());// 项目难度
//                    excelUtil.setCellValue(row, 34, dataPayload.getProjectImportanceName());// 项目重要度
//                    excelUtil.setCellValue(row, 35, dataPayload.getDeliOrgName());// 交付bu
//                    excelUtil.setCellValue(row, 36, dataPayload.getDeliUserName());// 交付负责人
//                    excelUtil.setCellValue(row, 37, dataPayload.getSolutionDifficultyName());// 方案难度
//                    excelUtil.setCellValue(row, 38, dataPayload.getSolutionImportanceName());// 方案重要度
//                    excelUtil.setCellValue(row, 39, dataPayload.getCoOrgName());// 合作(副)签单BU
//                    excelUtil.setCellValue(row, 40, dataPayload.getCoUserName());// 合作(副)签单负责人
//                    excelUtil.setCellValue(row, 41, dataPayload.getCodeliOrgName());// 合作(副)交付BU
//                    excelUtil.setCellValue(row, 42, dataPayload.getCodeliUserName());// 合作(副)交付负责人
//                    excelUtil.setCellValue(row, 43, dataPayload.getSourceType() == null ? null : dataPayload.getSourceType().equals("inside") ? "内部" : "外部");// 来源类型
//                    excelUtil.setCellValue(row, 44, dataPayload.getInternalOrgName());// 内部来源BU
//                    excelUtil.setCellValue(row, 45, dataPayload.getInternalUserName());// 内部来源人
//                    excelUtil.setCellValue(row, 46, dataPayload.getExternalIden());// 外部线索来源
//                    excelUtil.setCellValue(row, 47, dataPayload.getExternalName());// 外部来源人
//                    excelUtil.setCellValue(row, 48, dataPayload.getExternalPhone());// 外部来源电话
//                    excelUtil.setCellValue(row, 49, dataPayload.getProfitDesc());// 利益承诺
//                    List<PrjProjectMemberVO> memberVOS = dataPayload.getMemberVOS();
//                    if (memberVOS != null && !memberVOS.isEmpty()) {
//                        List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
//                        String members = String.join(",", collect);
//                        excelUtil.setCellValue(row, 50, members);// 团队成员
//                    }
//                    excelUtil.setCellValue(row, 51, dataPayload.getExtString1());// 扩展字段1
//                    excelUtil.setCellValue(row, 52, dataPayload.getExtString2());// 扩展字段2
//                    excelUtil.setCellValue(row, 53, dataPayload.getExtString3());// 扩展字段3
//                    excelUtil.setCellValue(row, 54, dataPayload.getExtString4());// 扩展字段4
//                    excelUtil.setCellValue(row, 55, dataPayload.getExtString5());// 扩展字段5
//                    excelUtil.setCellValue(row, 56, dataPayload.getFileCodes());// 附件地址
//                    nextRow++;
//                }
//            }
//            String fileName = "商机数据-" + LocalDate.now();
//            ExcelUtil.writeResponse(response, fileName, workbook);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }finally {
//            if(inputStream !=null){
//                try {
//                    inputStream.close();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
    }

    @Override
    public void permissionBatchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }

        //定义文件名称
        String sheetName = "商机数据";
        PagingVO<CrmOpportunityVO> paging = permissionPaging(query);
        List<CrmOpportunityVO> records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            if (record.getCreateTime() != null) {
                record.setCreateDateStr(record.getCreateTime().toLocalDate().toString());
            }
//            Integer isNeedPartner = record.getIsNeedPartner();
//            String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
//            record.setIsNeedPartnerStr(isNeedPartnerStr);
//            record.setSourceType(record.getSourceType() == null ? null : record.getSourceType().equals("inside") ? "内部" : "外部");
//            Integer isOldCust = record.getIsOldCust();
//            String isOldCustStr = isOldCust == null ? "否" : isOldCust == 0 ? "是" : "否";
//            record.setIsOldCustStr(isOldCustStr);

//            List<PrjProjectMemberVO> memberVOS = record.getMemberVOS();
//            if (memberVOS != null && !memberVOS.isEmpty()) {
//                List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
//                String members = String.join(",", collect);
//                record.setMembers(members);
//            }
            order++;
        }
        records = udcUtil.translateList(records);
        List<CrmOpportunityExcelExport> resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);

        //  resultList.forEach(e -> e.setIsOldCust(e.getIsOldCustStr()));
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmOpportunityExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Map<String, Object> bindCustomer(Long id) {
        Boolean isNewCust = false;
        CrmOpportunityVO crmOpportunityVO = dao.queryByKey(id);
        String customerName = crmOpportunityVO.getCustBookName();
        Long custBookId = crmOpportunityVO.getCustBookId();
        Integer isOldCust = crmOpportunityVO.getIsOldCust();
        //用客户名称匹配当前客户是否存在
        //      int num = crmCustomerDAO.countByName(customerName);
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(id);
//        if (num > 0 || isOldCust == 0) {
//            List<CrmCustomerDO> customerDOS = crmCustomerDAO.findByName(customerName);
//            if (num > 0) {
//                opportunityPayload.setFormalCustomerId(customerDOS.get(0).getId());
//            } else {
//                //通过bookId查询客户地址簿信息
////                PrdAbVO prdAbVO = abDAO.queryCompanyByBookId(custBookId);
//                Long customerId = crmCustomerDAO.queryIdByBookId(custBookId);
//                opportunityPayload.setFormalCustomerId(customerId);
//            }
//        } else {
//            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
//            customerPayload.setCustomerName(customerName);
//            customerPayload.setCompanyIndustry(crmOpportunityVO.getCustIdst());
//            customerPayload.setCompanyPhone(crmOpportunityVO.getContactPhone());
//            customerPayload.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//            //根据当前的线索信息创建客户
//            try {
//                boolean flag = false;
//                CrmCustomerVO insert = customerService.insert(customerPayload,flag);
//                opportunityPayload.setFormalCustomerId(insert.getId());
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        if (num > 0 || isOldCust == 0) {
//            List<CrmCustomerDO> customerDOS = crmCustomerDAO.findByName(customerName);
//            if (num > 0) {
//                opportunityPayload.setFormalCustomerId(customerDOS.get(0).getId());
//            } else {
//                //通过bookId查询客户地址簿信息
////                PrdAbVO prdAbVO = abDAO.queryCompanyByBookId(custBookId);
//                Long customerId = crmCustomerDAO.queryIdByBookId(custBookId);
//                opportunityPayload.setFormalCustomerId(customerId);
//            }
//        } else {
//            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
//            customerPayload.setCustomerName(customerName);
//            customerPayload.setCompanyIndustry(crmOpportunityVO.getCustIdst());
//            customerPayload.setCompanyPhone(crmOpportunityVO.getContactPhone());
//            customerPayload.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//            //根据当前的线索信息创建客户
//            try {
//                boolean flag = true;
//                CrmCustomerVO insert = customerService.insert(customerPayload,flag);
//                opportunityPayload.setFormalCustomerId(insert.getId());
//            } catch (Exception e) {
//                log.error(e.getMessage(),e);
//                e.printStackTrace();
//            }
//            isNewCust = true;
//        }
        /*----------------------业务伙伴重构之后逻辑-----------------------**/
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        BusinessPartnerSimpleVO businessPartnerSimpleVO = businessPartnerService.queryByPartnerName(customerName);
        if (businessPartnerSimpleVO != null || isOldCust == 0) {
            BusinessCustomerInfoService businessCustomerInfoService = SpringUtil.getBean(BusinessCustomerInfoService.class);
            if (businessPartnerSimpleVO != null) {
                //有客户身份
                if (businessPartnerSimpleVO.getCustomerFlag()) {
                    opportunityPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerSimpleVO.getPartnerName());
                } else {
                    // 没有客户身份 先修改业务伙伴的身份 然后新增客户数据
                    BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                    businessPartnerPayload.setPartnerIdentity(businessPartnerSimpleVO.getPartnerIdentity() + "," + BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                    businessPartnerPayload.setId(businessPartnerSimpleVO.getId());
                    businessPartnerPayload.setCustomerFlag(true);
                    businessPartnerService.update(businessPartnerPayload);
                    //新增客户
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setPartnerId(businessPartnerSimpleVO.getId());
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoPayload.setConfirmFlag(false);
                    businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                    businessCustomerInfoService.insert(businessCustomerInfoPayload);
                    opportunityPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerSimpleVO.getPartnerName());
                    isNewCust = true;
                }
            } else {
                List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(custBookId);
                if (CollectionUtils.isNotEmpty(businessPartnerVOS)) {
                    BusinessPartnerVO businessPartnerVO = businessPartnerVOS.get(0);
                    if (businessPartnerVO.getCustomerFlag()) {
                        opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                        opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());

                    } else {
                        // 没有客户身份 先修改业务伙伴的身份 然后新增客户数据
                        BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                        businessPartnerPayload.setPartnerIdentity(businessPartnerVO.getPartnerIdentity() + "," + BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                        businessPartnerPayload.setId(businessPartnerVO.getId());
                        businessPartnerPayload.setCustomerFlag(true);
                        businessPartnerService.update(businessPartnerPayload);
                        //新增客户
                        BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                        businessCustomerInfoPayload.setPartnerId(businessPartnerVO.getId());
                        businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                        businessCustomerInfoPayload.setConfirmFlag(false);
                        businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                        businessCustomerInfoService.insert(businessCustomerInfoPayload);
                        opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                        opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());

                        isNewCust = true;
                    }
                } else {
                    BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                    businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                    businessPartnerPayload.setCustomerFlag(true);
                    businessPartnerPayload.setPartnerName(customerName);
                    businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
                    businessPartnerPayload.setPartnerIndustry(crmOpportunityVO.getCustIdst());
                    businessPartnerPayload.setContactsPhone(crmOpportunityVO.getContactPhone());
                    businessPartnerPayload.setContactsName(crmOpportunityVO.getContactName());
                    businessPartnerPayload.setContactsPosition(crmOpportunityVO.getContactPosition());
                    businessPartnerPayload.setContactsDepartment(crmOpportunityVO.getContactDept());
                    businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
                    BusinessPartnerVO businessPartnerVO = businessPartnerService.insert(businessPartnerPayload);
                    opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
                    isNewCust = true;
                }
            }

        } else {
            //业务伙伴不存在要新增
            BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
            businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
            businessPartnerPayload.setCustomerFlag(true);
            businessPartnerPayload.setPartnerName(customerName);
            businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
            businessPartnerPayload.setPartnerIndustry(crmOpportunityVO.getCustIdst());
            businessPartnerPayload.setContactsPhone(crmOpportunityVO.getContactPhone());
            businessPartnerPayload.setContactsName(crmOpportunityVO.getContactName());
            businessPartnerPayload.setContactsPosition(crmOpportunityVO.getContactPosition());
            businessPartnerPayload.setContactsDepartment(crmOpportunityVO.getContactDept());
            businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
            BusinessPartnerVO businessPartnerVO = businessPartnerService.insert(businessPartnerPayload);
            opportunityPayload.setCustBookId(businessPartnerVO.getBookId());
            opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
            opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
            isNewCust = true;
        }
        /*----------------------业务伙伴重构之后逻辑-----------------------**/

        if (opportunityPayload.getFormalCustomerId() != null) {
            dao.updateByKeyDynamic(opportunityPayload);
        }
        Map<String, Object> result = new HashMap<>();
        result.put("isNewCust", isNewCust);
        return result;
    }


    @Override
    public Map<String, Object> bindCustomers() {
        //查询所有未绑定客户的商机
        List<Long> notBindOppos = dao.findNotBindOppos();
        int i = 0;
        for (Long notBindOppo : notBindOppos) {
            i++;
            if (i > 1000) {
                break;
            }
            bindCustomer(notBindOppo);
        }
        List<Long> notBindOppos1 = dao.findNotBindOppos();
        Map<String, Object> map = new HashMap<>();
        map.put("restNum", notBindOppos1 == null ? 0 : notBindOppos1.size());
        return new HashMap<>();
    }

    @Override
    public Long getIdByV4(Long oppoIdV4) {
        return dao.getIdByV4(oppoIdV4);
    }

    // @Override
    // @Transactional(rollbackFor = Exception.class)
    // public String yeedocGetUri(Long id) {
    //     CrmOpportunityVO opportunityVO = dao.queryByKey(id);
    //     Assert.notNull(opportunityVO.getId(), "商机不存在！");
    //     // 已经在易稻壳创建过文件夹的情况下，只需获取易稻壳链接
    //     final String itemIdDb = opportunityVO.getItemId();
    //     if (StringUtils.hasText(itemIdDb)) {
    //         final String preViewItemStr = yeedocService.preViewItem(itemIdDb);
    //         if (org.apache.commons.lang3.StringUtils.isEmpty(preViewItemStr)) {
    //             log.error("易道壳返回链接为空,docItemId:{}", itemIdDb);
    //             throw TwException.error("", "易道壳返回链接为空！");
    //         }
    //         JSONObject resultJson = JSONObject.parseObject(preViewItemStr);
    //         Object data = resultJson.get("value");
    //         if (ObjectUtils.isEmpty(data)) {
    //             throw TwException.error("", "易道壳返回链接为空！");
    //         }
    //         String prewUri = (String) data;
    //         return prewUri;
    //     }
    //     // 文件夹名称 = 商机名称 + 商机编号
    //     String folderName = opportunityVO.getProjectName() + "+" + opportunityVO.getProjectNo();
    //     // 没有创建过的情况下  1、创建文件夹；2、赋权；3、c取链接；4、存储itemId到商机主数据
    //     //1、创建文件夹
    //     List<String> pathArr = new ArrayList<>();
    //     pathArr.add("/" + folderName);
    //     CreateFolderDTO createFolderDTO = CreateFolderDTO.builder()
    //             .libraryId(yeedocProperties.getOppoFolder().getLibraryId())
    //             .itemId(yeedocProperties.getOppoFolder().getItemId())
    //             .permissionLevel(yeedocProperties.getOppoFolder().getPermissionLevel())
    //             .pathArry(pathArr)
    //             .isInheritance(false)
    //             .build();
    //     String resultStr = yeedocService.createFolder(createFolderDTO);
    //     if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
    //         throw TwException.error("", "易道壳返回为空！");
    //     }
    //     // 解析itemId
    //     String itemId = getItemId(resultStr);
    //     if (!StringUtils.hasText(itemId)) {
    //         throw TwException.error("", "易道壳创建文件夹失败！");
    //     }
    //
    //     // 易道壳赋权
    //     String permissionsStr = yeedocService.setPermission(itemId, yeedocProperties.getOppoFolder().getPermissionLevel());
    //     if (org.apache.commons.lang3.StringUtils.isEmpty(permissionsStr)) {
    //         log.error("易道壳赋权失败! permissionsStr:{} ;docItemId:{}", permissionsStr, itemId);
    //         throw TwException.error("", "易道壳赋权失败！");
    //     }
    //     if ((int) JSONObject.parseObject(permissionsStr).get("statusCode") != 200) {
    //         log.error("易道壳赋权失败! permissionsStr:{} ;docItemId:{}", permissionsStr, itemId);
    //         throw TwException.error("", "易道壳赋权失败！");
    //     }
    //
    //     // 易道壳返回链接
    //     String preViewItemStr = yeedocService.preViewItem(itemId);
    //     if (org.apache.commons.lang3.StringUtils.isEmpty(preViewItemStr)) {
    //         log.error("易道壳返回链接为空,docItemId:{}", itemId);
    //         throw TwException.error("", "易道壳返回链接为空！");
    //     }
    //     JSONObject resultJson = JSONObject.parseObject(preViewItemStr);
    //     Object data = resultJson.get("value");
    //     if (ObjectUtils.isEmpty(data)) {
    //         throw TwException.error("", "易道壳返回链接为空！");
    //     }
    //     String prewUri = (String) data;
    //
    //     // 存储itemId到商机
    //     CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
    //     opportunityPayload.setId(opportunityVO.getId());
    //     opportunityPayload.setItemId(itemId);
    //     dao.updateByKeyDynamic(opportunityPayload);
    //     return prewUri;
    // }

    private String getItemId(String resultStr) {
        Object data = null;
        try {
            JSONObject resultJson = JSONObject.parseObject(resultStr);
            data = resultJson.get("data");
        } catch (Exception e) {
            log.error("易道壳创建文件夹失败!resultStr = {" + resultStr + "}", e);
        }
        if (ObjectUtils.isEmpty(data)) {
            throw TwException.error("", "易道壳创建文件夹失败！");
        }
        JSONArray arrayDate = JSONArray.parseArray(data.toString());
        String itemId = "";
        for (int i = 0; i < arrayDate.size(); i++) {
            JSONObject jsonObject = JSONObject.parseObject(arrayDate.get(i).toString());
            // 取最后一级目录
            itemId = (String) jsonObject.get("itemId");
        }
        return itemId;
    }


    @Transactional
    @Override
    public void deleteSoft(Long id) {
        dao.deleteSoft(id);
    }

    @Override
    public Map<Long, Long> getV4AndV5OppoIds() {
        Map<Long, Long> oppoMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5OppoIds = dao.getV4AndV5OppoIds();
        for (Map<String, Object> v4AndV5OppoId : v4AndV5OppoIds) {
            Long oppoId = (Long) v4AndV5OppoId.get("oppoId");
            Long oppoIdV4 = (Long) v4AndV5OppoId.get("oppoIdV4");
            oppoMap.put(oppoIdV4, oppoId);
        }
        return oppoMap;
    }


    /**
     * 校验商机的案情分析、竞争对手、商机干系人和关键里程碑计划
     *
     * @return
     */
    @Override
    @Transactional
    public Boolean checkIntegrity(Long oppoId) {
        Boolean flag = true;
        // 案情分析
        List<CrmOpportunityAnalyzeVO> crmOpportunityAnalyzeVOS = opportunityAnalyzeService.queryList(oppoId);
        if (CollectionUtils.isEmpty(crmOpportunityAnalyzeVOS)) {
            flag = false;
        } else {
            // 竞争对手
            List<CrmOpportunityCompetitorVO> crmOpportunityCompetitorVOS = opportunityCompetitorService.queryList(oppoId);
            if (CollectionUtils.isEmpty(crmOpportunityCompetitorVOS)) {
                flag = false;
            } else {
                // 商机干系人
                List<CrmOpportunityStakeholderVO> crmOpportunityStakeholderVOS = opportunityStakeholderService.queryList(oppoId);
                if (CollectionUtils.isEmpty(crmOpportunityStakeholderVOS)) {
                    flag = false;
                } else {
                    CrmOpportunityMilestonePlanQuery query = new CrmOpportunityMilestonePlanQuery();
                    query.setOppoId(oppoId);
                    // 关键里程碑计划
                    List<CrmOpportunityMilestonePlanVO> crmOpportunityMilestonePlanVOS = opportunityMilestonePlanService.queryListDynamic(query);
                    if (CollectionUtils.isEmpty(crmOpportunityMilestonePlanVOS)) {
                        flag = false;
                    }
                }
            }
        }
        //updateFlag
        dao.updateCheckStatus(oppoId, flag);
        return flag;
    }

    @Override
    public long count(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = pagingCommon(query);
        return opportunityVO.getTotal();
    }

    @Override
    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        return dao.queryListByCustomId(customId);
    }

    private PagingVO<CrmOpportunityVO> pagingCommon(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = null;
        //进来查询的不管是哪里的 都走权限
//        if (query.getFormalCustomerId() != null) {
//            //默认需要权限
//            if (query.getIsPermission()) {
////                List<Long> marketUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
////                List<Long> saleUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_RES.getCode()));
////                List<Long> marketAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
////                List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
//
//                Boolean marketAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
//                Boolean marketUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
//                Boolean saleAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
//                Boolean saleUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
//                // 获取当前登录用户
////                GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
////                Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
//
//                //过滤不符合要求的客户
////                if ((saleUserIdsByRole != null && !saleUserIdsByRole.isEmpty() && saleUserIdsByRole.contains(userId)) ||
////                        (saleAdminUserIdsByRole != null && !saleAdminUserIdsByRole.isEmpty() && saleAdminUserIdsByRole.contains(userId))
////                ) {
////                    query.setSourceType("INTERNAL");
////                } else if ((marketUserIdsByRole != null && !marketUserIdsByRole.isEmpty() && marketUserIdsByRole.contains(userId)) ||
////                        (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId))
////                ) {
////                    query.setSourceType("EXTERNAL");
////                }
//                if (saleUserIdsByRole || saleAdminUserIdsByRole) {
//                    query.setSourceType("INTERNAL");
//                } else if (marketAdminUserIdsByRole || marketUserIdsByRole) {
//                    query.setSourceType("EXTERNAL");
//                } else {
//                    query.setCreateUserId(GlobalUtil.getLoginUserId());
//                }
//
//            }
//            opportunityVO = dao.queryPaging(query, null, null, null);
//        } else {
        Long userId = GlobalUtil.getLoginUserId();

        List<Long> sapPermissionOrgIdList = null;
        List<Long> orgManageIds = orgOrganizationDAO.queryByManageIdOrgIds(userId);
        // 部门下的成员包括当前登录人本人
        List<Long> oppoUserIds = new ArrayList<>();
        // 判断当前登录人是否是系统管理员or销售管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            oppoUserIds = null;
        } else {
            boolean hasSapBuPermission = cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
            if (hasSapBuPermission) {
                List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(userId);
                List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                    sapPermissionOrgIdList = orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                }
            }
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                //查询部门下的成员
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                oppoUserIds = Collections.singletonList(userId);
            }
        }
        opportunityVO = dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
//        }
        return opportunityVO;
    }

    @Override
    public PagingVO<CrmOpportunityVO> permissionPaging(CrmOpportunityQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query).selectExclude(CrmOpportunityVO::getActName, CrmOpportunityVO::getCheckStatus);
        List<CrmOpportunityVO> opportunitys = beanSearcher.searchList(CrmOpportunityVO.class, mapBuilder.build());
        Number totalNum = beanSearcher.searchCount(CrmOpportunityVO.class, mapBuilder.build());
        if (totalNum.longValue() == 0L) {
            return PagingVO.<CrmOpportunityVO>builder().records(opportunitys).total((Long) totalNum).build();
        }

//        List<CrmOpportunityVO> opportunitys = opportunityVO.getRecords();
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Set<Long> bookIds = new HashSet<>();
        Set<Long> formalCustomerIds = new HashSet<>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        for (CrmOpportunityVO vo : opportunitys) {
            transferSystemSelection(vo);
            // 设置资源规划的权限
            checkPersonPlanAuth(vo, loginUserId);
            getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        }
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));
        List<Map<String, Object>> books = dao.queryBooks(bookIds);
        Map<Long, String> bookMap = new HashMap<>();
        books.forEach(book -> bookMap.put(Long.valueOf(book.get("book_id") + ""), (String) book.get("bookName")));
        Map<Long, List<BusinessPartnerVO>> customerMapTmp = new HashMap<>();
        if (!CollectionUtils.isEmpty(formalCustomerIds)) {
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryListByIds(new ArrayList<>(formalCustomerIds));
            if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
                customerMapTmp = businessPartnerVOS.stream().collect(Collectors.groupingBy(BusinessPartnerVO::getId));
            }
        }
        final Map<Long, List<BusinessPartnerVO>> customerMap = customerMapTmp;
        opportunitys.forEach(opportunity -> transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, opportunity));

        // PmsReasonTypeEnum
        List<String> reasonTypes = new ArrayList<>();
        List<Long> projectIds = opportunitys.stream().map(x -> x.getProjectId()).collect(Collectors.toList());
        for (Long projectId : projectIds) {
            reasonTypes.add(PmsReasonTypeEnum.PROJ_OPPO.getCode());
        }

        List<BudgetCommonVO> budgetCommonVOS = budgetCommonService.queryBudgetEqvaAndAmts(reasonTypes, projectIds);
        Map<Long, BudgetCommonVO> reasonMap = budgetCommonVOS.stream().collect(Collectors.toMap(BudgetCommonVO::getReasonId, Function.identity(), (v1, v2) -> v1));

        for (CrmOpportunityVO opportunity : opportunitys) {
            // 1-累计投入当量
            BudgetCommonVO budgetCommonVO = reasonMap.get(opportunity.getProjectId());
            if (null != budgetCommonVO) {
                BigDecimal usedEqva = budgetCommonVO.getUsedEqva().add(budgetCommonVO.getOccupyEqva());
                opportunity.setUsedEqva(usedEqva);
                // 2-累计投入费用
                BigDecimal usedAmt = budgetCommonVO.getUsedAmt().add(budgetCommonVO.getOccupyAmt());
                opportunity.setUsedAmt(usedAmt);
            }

        }
        return PagingVO.<CrmOpportunityVO>builder().records(opportunitys).total((Long) totalNum).build();
    }

    private MapBuilder pageWhereBuilder(CrmOpportunityQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty(query.getCreateTimeBetween())) {
            builder.field(CrmOpportunityVO::getCreateTime, query.getCreateTimeBetween().get(0), query.getCreateTimeBetween().get(1)).op(FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            builder.field(CrmOpportunityVO::getOrgId, query.getOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getManageUserId())) {
            builder.field(CrmOpportunityVO::getManageUserId, query.getManageUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            builder.field(CrmOpportunityVO::getCreateUserId, query.getCreateUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getProjectNameOrNo())) {
            String likeStr = "%" + query.getProjectNameOrNo() + "%";
            builder.field(CrmOpportunityVO::getProjectName, CrmOpportunityVO::getProjectNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        if (!ObjectUtils.isEmpty(query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6);
            }
            if (startDate != null) {
                builder.field(CrmOpportunityVO::getForecastWinDate, startDate).op(FieldOps.GreaterEqual);
            }
            if (endDate != null) {
                builder.field(CrmOpportunityVO::getForecastWinDate, endDate).op(FieldOps.LessEqual);
            }
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleOrgId())) {
            builder.field(CrmOpportunityVO::getPreSaleOrgId, query.getPreSaleOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleUserId())) {
            builder.field(CrmOpportunityVO::getPreSaleUserId, query.getPreSaleUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getDeliOrgId())) {
            builder.field(CrmOpportunityVO::getDeliOrgId, query.getDeliOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getForecastAmountStart()) && !ObjectUtils.isEmpty(query.getForecastAmountEnd())) {
            builder.field(CrmOpportunityVO::getForecastAmount, query.getForecastAmountStart(), query.getForecastAmountEnd()).op(FieldOps.Between);
        } else {
            if (!ObjectUtils.isEmpty(query.getForecastAmountStart())) {
                builder.field(CrmOpportunityVO::getForecastAmount, query.getForecastAmountStart()).op(FieldOps.GreaterEqual);
            }
            if (!ObjectUtils.isEmpty(query.getForecastAmountEnd())) {
                builder.field(CrmOpportunityVO::getForecastAmount, query.getForecastAmountEnd()).op(FieldOps.LessEqual);
            }
        }
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            builder.field(CrmOpportunityVO::getDeliUserId, query.getDeliUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCustRegion())) {
            builder.field(CrmOpportunityVO::getCustRegion, query.getCustRegion()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                builder.field(CrmOpportunityVO::getProjectStatus, query.getProjectStatus()).op(FieldOps.Equal);
            } else {
                builder.field(CrmOpportunityVO::getProjectStatus, query.getProjectStatus()).op(FieldOps.NotEqual);
            }
        }
        if (!ObjectUtils.isEmpty(query.getCustBookName())) {
            builder.field(CrmOpportunityVO::getCustBookName, query.getCustBookName()).op(FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty(query.getOppoLevel())) {
            builder.field(CrmOpportunityVO::getOppoLevel, query.getOppoLevel()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getOppoLevels())) {
            builder.field(CrmOpportunityVO::getOppoLevel, query.getOppoLevels()).op(FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty(query.getLeadsId())) {
            builder.field(CrmOpportunityVO::getLeadsId, query.getLeadsId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCoopBookId())) {
            builder.field(CrmOpportunityVO::getCoopBookId, query.getCoopBookId()).op(FieldOps.Equal);
        }

        if (!ObjectUtils.isEmpty(query.getCoopBookName())) {
            builder.field(CrmOpportunityVO::getCoopBookName, query.getCoopBookName()).op(FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty(query.getCoOrgId())) {
            builder.field(CrmOpportunityVO::getCoOrgId, query.getCoOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCodeliOrgId())) {
            builder.field(CrmOpportunityVO::getCodeliOrgId, query.getCodeliOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getInternalOrgId())) {
            builder.field(CrmOpportunityVO::getInternalOrgId, query.getInternalOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getInternalUserId())) {
            builder.field(CrmOpportunityVO::getInternalUserId, query.getInternalUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCustIdst())) {
            builder.field(CrmOpportunityVO::getCustIdst, query.getCustIdst()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getFormalCustomerId())) {
            builder.field(CrmOpportunityVO::getFormalCustomerId, query.getFormalCustomerId()).op(FieldOps.Equal);
        }
//        if (oppoUserIds != null && !oppoUserIds.isEmpty()) {
//            Predicate temp = qdoMember.userId.in(oppoUserIds).or(qdoProject.manageUserId.in(oppoUserIds)).or(qdoProject.orgId.in(orgManageIds)).or(qdo.preSaleOrgId.in(orgManageIds))
//                    .or(qdo.deliOrgId.in(orgManageIds)).or(qdo.coOrgId.in(orgManageIds)).or(qdo.codeliOrgId.in(orgManageIds)).or(qdo.internalOrgId.in(orgManageIds));
//            if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)) {
//                temp = ExpressionUtils.or(temp, qdo.preSaleOrgId.in(sapPermissionOrgIdList).or(qdo.deliOrgId.in(sapPermissionOrgIdList)));
//            }
//            jpaQuery.where(temp);
//            jpaQuery.where(qdoMember.deleteFlag.eq(0));
//        }

        if (!ObjectUtils.isEmpty(query.getOppoIds())) {
            builder.field(CrmOpportunityVO::getId, List.of(query.getOppoIds())).op(FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty(query.getOppoIdsV4())) {
            builder.field(CrmOpportunityVO::getOppoIdV4, query.getOppoIdsV4()).op(FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            builder.field(CrmOpportunityVO::getSourceType, query.getSourceType()).op(FieldOps.Equal);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(query.getCheckStatus())) {
            builder.field(CrmOpportunityVO::getCheckStatus, query.getCheckStatus()).op(FieldOps.Equal);
        }
        // 销售阶段
        if (StringUtils.hasText(query.getSalePhase())) {
            builder.field(CrmOpportunityVO::getSalePhase, query.getSalePhase()).op(FieldOps.Equal);
        }
        // 销售阶段
        if (!ObjectUtils.isEmpty(query.getSalePhases())) {
            builder.field(CrmOpportunityVO::getSalePhase, query.getSalePhases()).op(FieldOps.InList);
        }
        // 资源规划类型
        if (StringUtils.hasText(query.getPlanType())) {
            builder.field(CrmOpportunityVO::getPlanType, query.getPlanType()).op(FieldOps.Equal);
        }
        // 资源规划id
        if (!ObjectUtils.isEmpty(query.getPersonPlanFlag())) {
            if (query.getPersonPlanFlag()) {
                builder.field(CrmOpportunityVO::getPersonPlanFlag).sql("$1 is not null");
            } else {
                builder.field(CrmOpportunityVO::getPersonPlanFlag).sql("$1 is null");
            }
        }

        // 分组使用占位符，需要在实体类注解中指定参数
        builder.put("groupBy", "pp.id");
        builder.field(CrmOpportunityVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);

        return builder;
    }

    @Override
    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO paymentDefaultVO = new PurchasePaymentDefaultVO();
        // 根据编号查询商机
        CrmOpportunityVO crmOpportunityVO = dao.queryByProjectNo(docNo);
        // 币种
        paymentDefaultVO.setCurrCode(crmOpportunityVO.getCurrCode());
        // 商机ID
        paymentDefaultVO.setDocId(crmOpportunityVO.getId());
        // 商机编号
        paymentDefaultVO.setDocNo(crmOpportunityVO.getProjectNo());
        // 商机名称
        paymentDefaultVO.setDocName(crmOpportunityVO.getProjectName());
        // 编号
        paymentDefaultVO.setDocNo(docNo);
        return paymentDefaultVO;
    }

    @Override
    public List<CrmOpportunityVO> selectOpportunityListByUserBu() {
        List<Long> orgIds = prdUserService.queryOrgList().stream().map(PrdOrgDataRefVO::getOrgId).toList();
        return dao.findByOrgIdIn(orgIds);
    }

    @Override
    public List<CrmOpportunityVO> findByMemberIdIdEq(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        return dao.findByMemberIdIdEq(userId);
    }

    @Override
    public Long findOrgIdByDocNo(String docNo) {
        return dao.findOrgIdByDocNo(docNo);
    }

    // 商机资源规划权限
    private void checkPersonPlanAuth(CrmOpportunityVO crmOpportunityVO, Long loginUserId) {
        // 成本估算（商机资源规划的权限） 权限：商机交付BU负责人、资源经理、平台总体负责人、平台业务负责人拥有创建、编辑、删除权限
        Boolean personPlanAuth = false;
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode(), RoleEnum.SYS.getCode()));
        if (rolePermission) {
            personPlanAuth = true;
        }
        if (crmOpportunityVO.getDeliOrgId() != null) {
            //交付BU负责人
            PrdOrgOrganizationVO org = cacheUtil.getOrg(crmOpportunityVO.getDeliOrgId());
            if (org != null && loginUserId.equals(org.getManageId())) {
                personPlanAuth = true;
            }
        }
        crmOpportunityVO.setPersonPlanAuth(personPlanAuth);
    }

    // 处理附件
    private void oppoFollowFileHandle(CrmFollowPayload payload, CrmActProjectVO project) {
        Map<String, Object> context = BeanUtil.beanToMap(project);
        // 附件
        String fileCodesStr = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getFileCodes());
        payload.setFileCodes(fileCodesStr);
    }
}
