package com.elitesland.tw.tw5.server.prd.crm.visit.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_visit_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_visit_plan", comment = "销售拜访计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class VisitPlanDO extends BaseModel implements Serializable  {
    /** 计划类型 */
    @Comment("计划类型")
    @Column()
    private String visitPlanType;
    @Comment("计划状态")
    @Column()
    private String visitPlanStatus;
    /** 计划名称 */
    @Comment("计划名称")
    @Column()
    private String visitPlanName;
    /** 拜访客户id see partnerId */
    @Comment("拜访客户id see partnerId")
    @Column()
    @Deprecated
    private Long customId;
    /** 业务伙伴主键（客户主表） business_partner.id */
    @Comment("业务伙伴主键（客户主表） business_partner.id")
    @Column()
    private Long partnerId;
    /** 客户地址 */
    @Comment("客户地址")
    @Column()
    private String customAdress;
    /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 */
    @Comment("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    @Column()
    private String longitudeLatitude;
    /** 业务合作伙伴-地址信息ID */
    @Comment("业务合作伙伴-地址信息ID")
    @Column()
    private Long bookAddressId;
    /** 拜访时间 */
    @Comment("拜访时间")
    @Column()
    private LocalDate visitDateFrom;
    /** 拜访时间 */
    @Comment("拜访时间")
    @Column()
    private LocalDate visitDateTo;
    /** 拜访次数 */
    @Comment("拜访次数")
    @Column()
    private String visitTimes;
    /** 添加提醒 */
    @Comment("添加提醒")
    @Column()
    private LocalDateTime remindTime;
    /** extString1 */
    @Comment("extString1")
    @Column()
    private String extString1;
    /** extString2 */
    @Comment("extString2")
    @Column()
    private String extString2;
    /** extString3 */
    @Comment("extString3")
    @Column()
    private String extString3;
    /** extString4 */
    @Comment("extString4")
    @Column()
    private String extString4;
    /** extString5 */
    @Comment("extString5")
    @Column()
    private String extString5;
    /** 关联信息类型（线索、商机OPPO、经营计划、销售目标） */
    @Comment("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    @Column()
    private String objType;
    /** 关联信息主键（关联主键) */
    @Comment("关联信息主键（关联主键)")
    @Column()
    private Long objId;
    /** 关联信息名称（冗余） */
    @Comment("关联信息名称（冗余）")
    @Column()
    private String objName;

    public void copy(VisitPlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
