package com.elitesland.tw.tw5.server.prd.file.service;

import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileRefPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileRefQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileRefService;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileRefVO;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.file.convert.PrdFileRefConvert;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileRefDO;
import com.elitesland.tw.tw5.server.prd.file.repo.PrdFileRefRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 附件-文件单据关联表
 *
 * @author duwh
 * @date 2022/09/22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdFileRefServiceImpl implements PrdFileRefService {

    private final PrdFileRefRepo prdFileRefRepo;
    private final PrdFileService prdFileService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileRefVO insert(PrdFileRefPayload payload) {
        PrdFileRefDO entityDo = PrdFileRefConvert.INSTANCE.toDo(payload);
        prdFileRefRepo.save(entityDo);
        return PrdFileRefConvert.INSTANCE.toVo(entityDo);
    }

    /**
     * 新增
     *
     * @param fileId       文件标识
     * @param docId        文档id
     * @param businessType 业务类型
     * @param docType      文档类型
     * @return {@link PrdFileRefVO}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileRefVO insert(Long fileId, Long docId, String businessType, String docType) {
        PrdFileRefDO entity = new PrdFileRefDO();
        entity.setFileId(fileId);
        entity.setBusinessType(businessType);
        entity.setDocType(docType);
        entity.setDocId(docId);
        prdFileRefRepo.save(entity);
        return PrdFileRefConvert.INSTANCE.toVo(entity);
    }

    /**
     * 列表文件
     *
     * @param docId        文档id
     * @param businessType 业务类型
     * @param docType      文档类型
     * @return {@link List}<{@link PrdFileVO}>
     */
    @Override
    public List<PrdFileVO> listFile(Long docId, String businessType, String docType) {
        Assert.notNull(docId, "docId is not null");
        Assert.hasLength(businessType, "businessType is not empty");
        Assert.hasLength(docType, "docType is not empty");

        PrdFileRefQuery query = new PrdFileRefQuery();
        query.setDocId(docId);
        query.setBusinessType(businessType);
        query.setDocType(docType);
        final List<PrdFileRefVO> prdFileRefVOS = queryList(query);
        List<PrdFileVO> listFile = new ArrayList<>();
        prdFileRefVOS.forEach(prdFileRefVO -> {
            final PrdFileVO prdFileVO = prdFileService.queryByKey(prdFileRefVO.getFileId());
            listFile.add(prdFileVO);
        });
        return listFile;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileRefVO update(PrdFileRefPayload payload) {
        PrdFileRefDO entity = prdFileRefRepo.findById(payload.getId()).orElseGet(PrdFileRefDO::new);
        Assert.notNull(entity.getId(), "附件不存在");
        PrdFileRefDO entityDo = PrdFileRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdFileRefConvert.INSTANCE.toVo(prdFileRefRepo.save(entity));
    }

    @Override
    public PrdFileRefVO queryByKey(Long key) {
        PrdFileRefDO entity = prdFileRefRepo.findById(key).orElseGet(PrdFileRefDO::new);
        Assert.notNull(entity.getId(), "附件不存在");
        return PrdFileRefConvert.INSTANCE.toVo(entity);
    }

    @Override
    public List<PrdFileRefVO> queryList(PrdFileRefQuery query) {
        return PrdFileRefConvert.INSTANCE.toVoList(prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<PrdFileRefVO> paging(PrdFileRefQuery query) {
        Page<PrdFileRefDO> page = prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdFileRefConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdFileRefRepo.deleteSoft(keys);
        }
    }


}
