package com.elitesland.tw.tw5.server.prd.humanresources.eval.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigPointDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateConfigPointDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表RepoProc
 */

@Component
public class PrdEvaluateConfigPointDao extends BaseRepoProc<PrdEvaluateConfigPointDO> {

    private static final QPrdEvaluateConfigPointDO qPrdEvaluateConfigPointDO = QPrdEvaluateConfigPointDO.prdEvaluateConfigPointDO;


    protected PrdEvaluateConfigPointDao() {

        super(qPrdEvaluateConfigPointDO);

    }


    public PagingVO<PrdEvaluateConfigPointVO> page(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        JPAQuery<PrdEvaluateConfigPointVO> query =
                select(PrdEvaluateConfigPointVO.class)
                        .where(bulidPredicate(prdEvaluateConfigPointQuery));
        prdEvaluateConfigPointQuery.setPaging(query);
        prdEvaluateConfigPointQuery.fillOrders(query, qPrdEvaluateConfigPointDO);
        return PagingVO.<PrdEvaluateConfigPointVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEvaluateConfigPointDO)
                .set(qPrdEvaluateConfigPointDO.deleteFlag, 1)
                .where(qPrdEvaluateConfigPointDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEvaluateConfigPointVO get(Long id) {

        PrdEvaluateConfigPointVO prdEvaluateConfigPointVO = select(PrdEvaluateConfigPointVO.class)
                .where(qPrdEvaluateConfigPointDO.id.eq(id))
                .fetchOne();

        return prdEvaluateConfigPointVO;

    }


    public List<PrdEvaluateConfigPointVO> getList(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        List<PrdEvaluateConfigPointVO> res =
                select(PrdEvaluateConfigPointVO.class)
                        .where(bulidPredicate(prdEvaluateConfigPointQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdEvaluateConfigPointDO.name,
                        qPrdEvaluateConfigPointDO.state,
                        qPrdEvaluateConfigPointDO.scoreMin,
                        qPrdEvaluateConfigPointDO.scoreMax,
                        qPrdEvaluateConfigPointDO.defScore,
                        qPrdEvaluateConfigPointDO.standardDesc,
                        qPrdEvaluateConfigPointDO.id,
                        qPrdEvaluateConfigPointDO.createTime,
                        qPrdEvaluateConfigPointDO.remark

                )).from(qPrdEvaluateConfigPointDO);

    }


    private Predicate bulidPredicate(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(prdEvaluateConfigPointQuery.getName()), qPrdEvaluateConfigPointDO.name, prdEvaluateConfigPointQuery.getName())
                .andEq(null != prdEvaluateConfigPointQuery.getState(), qPrdEvaluateConfigPointDO.state, prdEvaluateConfigPointQuery.getState())
                .andEq(null != prdEvaluateConfigPointQuery.getScoreMin(), qPrdEvaluateConfigPointDO.scoreMin, prdEvaluateConfigPointQuery.getScoreMin())
                .andEq(null != prdEvaluateConfigPointQuery.getScoreMax(), qPrdEvaluateConfigPointDO.scoreMax, prdEvaluateConfigPointQuery.getScoreMax())
                .andEq(null != prdEvaluateConfigPointQuery.getDefScore(), qPrdEvaluateConfigPointDO.defScore, prdEvaluateConfigPointQuery.getDefScore())
                .andEq(StringUtils.isNotBlank(prdEvaluateConfigPointQuery.getStandardDesc()), qPrdEvaluateConfigPointDO.standardDesc, prdEvaluateConfigPointQuery.getStandardDesc())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 名称
        if (StringUtils.isNotEmpty(prdEvaluateConfigPointQuery.getName())) {
            predicates.add(qPrdEvaluateConfigPointDO.name.eq(prdEvaluateConfigPointQuery.getName()));
        }
        // 状态
        if (null != prdEvaluateConfigPointQuery.getState()) {
            predicates.add(qPrdEvaluateConfigPointDO.state.eq(prdEvaluateConfigPointQuery.getState()));
        }
        // 分数下限
        if (null != prdEvaluateConfigPointQuery.getScoreMin()) {
            predicates.add(qPrdEvaluateConfigPointDO.scoreMin.eq(prdEvaluateConfigPointQuery.getScoreMin()));
        }
        // 分数上限
        if (null != prdEvaluateConfigPointQuery.getScoreMax()) {
            predicates.add(qPrdEvaluateConfigPointDO.scoreMax.eq(prdEvaluateConfigPointQuery.getScoreMax()));
        }
        // 默认分数s
        if (null != prdEvaluateConfigPointQuery.getDefScore()) {
            predicates.add(qPrdEvaluateConfigPointDO.defScore.eq(prdEvaluateConfigPointQuery.getDefScore()));
        }
        // 标准说明
        if (StringUtils.isNotEmpty(prdEvaluateConfigPointQuery.getStandardDesc())) {
            predicates.add(qPrdEvaluateConfigPointDO.standardDesc.eq(prdEvaluateConfigPointQuery.getStandardDesc()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        long res = select(PrdEvaluateConfigPointVO.class)
                .where(bulidPredicate(prdEvaluateConfigPointQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateConfigPointDO);

        // 名称
        if (StringUtils.isNotEmpty(prdEvaluateConfigPointPayload.getName())) {
            update.set(qPrdEvaluateConfigPointDO.name, prdEvaluateConfigPointPayload.getName());
        }
        // 状态
        if (null != prdEvaluateConfigPointPayload.getState()) {
            update.set(qPrdEvaluateConfigPointDO.state, prdEvaluateConfigPointPayload.getState());
        }
        // 分数下限
        if (null != prdEvaluateConfigPointPayload.getScoreMin()) {
            update.set(qPrdEvaluateConfigPointDO.scoreMin, prdEvaluateConfigPointPayload.getScoreMin());
        }
        // 分数上限
        if (null != prdEvaluateConfigPointPayload.getScoreMax()) {
            update.set(qPrdEvaluateConfigPointDO.scoreMax, prdEvaluateConfigPointPayload.getScoreMax());
        }
        // 默认分数
        if (null != prdEvaluateConfigPointPayload.getDefScore()) {
            update.set(qPrdEvaluateConfigPointDO.defScore, prdEvaluateConfigPointPayload.getDefScore());
        }
        // 标准说明
        if (StringUtils.isNotEmpty(prdEvaluateConfigPointPayload.getStandardDesc())) {
            update.set(qPrdEvaluateConfigPointDO.standardDesc, prdEvaluateConfigPointPayload.getStandardDesc());
        }
        long res = update.where(qPrdEvaluateConfigPointDO.id.eq(prdEvaluateConfigPointPayload.getId()))
                .execute();
        return res;

    }

}

