package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PersonProjectExperienceQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonProjectExperienceVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonProjectExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonProjectExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonProjectExperienceRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonProjectExperienceDAO {

    private final PersonProjectExperienceRepo personProjectExperienceRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonProjectExperienceDO personProjectExperienceDO = QPersonProjectExperienceDO.personProjectExperienceDO;


    public List<PersonProjectExperienceDO> findAllByPersonId(Long personId) {
        return personProjectExperienceRepo.findAllByPersonId(personId);
    }

    public void deleteByPersonId(Long personId) {
        jpaQueryFactory.update(personProjectExperienceDO)
                .set(personProjectExperienceDO.deleteFlag, 1)
                .where(personProjectExperienceDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonProjectExperienceDO> projectExperienceDOList) {
        personProjectExperienceRepo.saveAll(projectExperienceDOList);
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PersonProjectExperienceVO> getJpaQueryWhere(PersonProjectExperienceQuery query) {
        JPAQuery<PersonProjectExperienceVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getPersonId())) {
            jpaQuery.where(personProjectExperienceDO.personId.eq(query.getPersonId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, personProjectExperienceDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(personProjectExperienceDO, query.getOrders()));
        return jpaQuery;
    }

    public JPAQuery<PersonProjectExperienceVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PersonProjectExperienceVO.class,
                personProjectExperienceDO.product,
                personProjectExperienceDO.company,
                personProjectExperienceDO.projName,
                personProjectExperienceDO.dateFrom,
                personProjectExperienceDO.dateTo,
                personProjectExperienceDO.dutyAchv,
                personProjectExperienceDO.industry,
                personProjectExperienceDO.projRole,
                personProjectExperienceDO.projIntro,
                personProjectExperienceDO.platProjFlag,
                personProjectExperienceDO.responsibility
        )).from(personProjectExperienceDO);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PersonProjectExperienceVO> queryPaging(PersonProjectExperienceQuery query) {
        JPAQuery<PersonProjectExperienceVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PersonProjectExperienceVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PersonProjectExperienceVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

}
