package com.elitesland.tw.tw5.server.prd.inv.controller;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoicePayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票主表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Api(tags = "发票主表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/invInvoice")
@Slf4j
public class InvInvoiceController {

private final InvInvoiceService invInvoiceService;

    /**
     * 发票主表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票主表-新增")
    public TwOutputUtil<InvInvoiceVO> insert(@RequestBody InvInvoicePayload payload){
         return TwOutputUtil.ok(invInvoiceService.insert(payload));
    }

    /**
     * 发票主表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票主表-更新")
    public TwOutputUtil<InvInvoiceVO> update(@RequestBody InvInvoicePayload payload){
        return TwOutputUtil.ok(invInvoiceService.update(payload));
    }

    /**
     * 发票主表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票主表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvInvoicePayload payload){
        return TwOutputUtil.ok(invInvoiceService.updateByKeyDynamic(payload));
    }

    /**
     * 发票主表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("发票主表-主键查询")
    public TwOutputUtil<InvInvoiceVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invInvoiceService.queryByKey(key));
    }

    /**
     * 发票主表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("发票主表-分页")
    public TwOutputUtil<PagingVO<InvInvoiceVO>> paging(InvInvoiceQuery query) {
        return TwOutputUtil.ok(invInvoiceService.queryPaging(query));
    }

    /**
     * 发票主表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票主表-查询列表")
    public TwOutputUtil<List<InvInvoiceVO>> queryList(InvInvoiceQuery query) {
        return TwOutputUtil.ok(invInvoiceService.queryListDynamic(query));
    }

    /**
     * 发票主表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票主表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invInvoiceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    @ApiOperation("根据当前登陆人，获取百望票据列表")
    @GetMapping("/getInvoicesFromBaiwang/{userId}")
    public TwOutputUtil getInvoiceList(@PathVariable Long userId) {
        invInvoiceService.getInvoicesFromBaiwang(userId);
        return TwOutputUtil.ok();
    }

}

