package com.elitesland.tw.tw5.server.prd.inv.service;


import com.baiwang.bop.client.IBopClient;
import com.baiwang.bop.client.ILoginClient;
import com.baiwang.bop.client.impl.BopRestClient;
import com.baiwang.bop.client.impl.PostLogin;
import com.baiwang.bop.request.impl.LoginRequest;
import com.baiwang.bop.respose.entity.LoginResponse;
import com.baiwang.open.client.BWRestClient;
import com.baiwang.open.client.IBWClient;
import com.elitesland.tw.tw5.server.prd.inv.config.TwInvoiceProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @ Author: ssy
 * @ Date: 2020/5/8
 * @ Description:
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TwInvoiceBaseService {

    final TwInvoiceProperties invoiceProperties;
    public IBopClient BAIWANG_CLIENT;
    public IBWClient BAIWANG_CLIENT_NEW;

    @PostConstruct
    public void init() {
        BAIWANG_CLIENT_NEW = new BWRestClient(invoiceProperties.getUrl(), invoiceProperties.getAppKey(), invoiceProperties.getAppSecret()); // 初始化一个客户端
        BAIWANG_CLIENT = new BopRestClient(invoiceProperties.getUrl(), invoiceProperties.getAppKey(), invoiceProperties.getAppSecret());
    }

    /**
     * 获取token
     * （因不确定 token 是否长期有效，为避免因token失效造成失败，固每请求一次，就需要获取一次token）
     * TODO: 后续，对百望的接口深入了解后，可将token放置Redis 中，并设置过期时间
     *
     * @return
     */
    public String getToken() {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAppkey(invoiceProperties.getAppKey());
        loginRequest.setAppSecret(invoiceProperties.getAppSecret());
        loginRequest.setUserName(invoiceProperties.getUserName());
        loginRequest.setPasswordMd5(invoiceProperties.getPassword());
        loginRequest.setUserSalt(invoiceProperties.getUserSalt());

        ILoginClient loginClient = new PostLogin(invoiceProperties.getUrl());
        LoginResponse loginResponse = loginClient.login(loginRequest);
        String token = loginResponse.getAccess_token();//获取token
        log.info("[百望-INVOICE-SERVICE] getToken:{}", token);
        return token;
    }

}
