package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiSignetApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTBusiSignetApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiSignetApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiSignetApplyRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Repository
@RequiredArgsConstructor
public class TBusiSignetApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TBusiSignetApplyRepo repo;
    private final QTBusiSignetApplyDO qdo = QTBusiSignetApplyDO.tBusiSignetApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TBusiSignetApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TBusiSignetApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // BaseBU
                qdo.basebuId,
                // 所属公司
                qdo.ouId,
                // 联系电话
                qdo.phone,
                // 邮箱
                qdo.email,
                // 印章用途
                qdo.signetPurpose,
                // 申请印章
                qdo.signetApply,
                // 是否外借
                qdo.lendFlag,
                // 附件
                qdo.fileCode,
                // 印章归还说明
                qdo.signetReturnRemark,
                // 申请人
                qdo.applyResId,
                // 申请日期
                qdo.applyDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 预计归还时间
                qdo.predictReturnTime,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5,
                // 排序号
                qdo.sortNo,
                //印章场景
                qdo.signetScene,
                //是否需要打印
                qdo.printFlag,
                //印章类型
                qdo.signetType,
                //相关印章
                qdo.relatedSignet,
                //印章所属公司
                qdo.signetBelongCompany
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TBusiSignetApplyVO> getJpaQueryWhere(TBusiSignetApplyQuery query) {
        JPAQuery<TBusiSignetApplyVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TBusiSignetApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TBusiSignetApplyQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** BaseBU 精确 */
        if (!ObjectUtils.isEmpty(query.getBasebuId())) {
            list.add(qdo.basebuId.eq(query.getBasebuId()));
        }
        /** 所属公司 精确 */
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            list.add(qdo.ouId.eq(query.getOuId()));
        }
        /** 联系电话 精确 */
        if (!ObjectUtils.isEmpty(query.getPhone())) {
            list.add(qdo.phone.eq(query.getPhone()));
        }
        /** 邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getEmail())) {
            list.add(qdo.email.eq(query.getEmail()));
        }
        /** 印章用途 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetPurpose())) {
            list.add(qdo.signetPurpose.eq(query.getSignetPurpose()));
        }
        /** 申请印章 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetApply())) {
            list.add(qdo.signetApply.eq(query.getSignetApply()));
        }
        /** 是否外借 精确 */
        if (!ObjectUtils.isEmpty(query.getLendFlag())) {
            list.add(qdo.lendFlag.eq(query.getLendFlag()));
        }
        /** 附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCode())) {
            list.add(qdo.fileCode.eq(query.getFileCode()));
        }
        /** 印章归还说明 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetReturnRemark())) {
            list.add(qdo.signetReturnRemark.eq(query.getSignetReturnRemark()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 预计归还时间 精确 */
        if (!ObjectUtils.isEmpty(query.getPredictReturnTime())) {
            list.add(qdo.predictReturnTime.eq(query.getPredictReturnTime()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 印章场景 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetScene())) {
            list.add(qdo.signetScene.eq(query.getSignetScene()));
        }
        /** 是否需要打印 精确 */
        if (!ObjectUtils.isEmpty(query.getPrintFlag())) {
            list.add(qdo.printFlag.eq(query.getPrintFlag()));
        }
        /** 印章类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetType())) {
            list.add(qdo.signetType.eq(query.getSignetType()));
        }
        /** 相关印章 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedSignet())) {
            list.add(qdo.relatedSignet.eq(query.getRelatedSignet()));
        }
        /** 印章所属公司 精确 */
        if (!ObjectUtils.isEmpty(query.getSignetBelongCompany())) {
            list.add(qdo.signetBelongCompany.eq(query.getSignetBelongCompany()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TBusiSignetApplyVO queryByKey(Long id) {
        JPAQuery<TBusiSignetApplyVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TBusiSignetApplyVO> queryListDynamic(TBusiSignetApplyQuery query) {
        JPAQuery<TBusiSignetApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TBusiSignetApplyVO> queryPaging(TBusiSignetApplyQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TBusiSignetApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<TBusiSignetApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TBusiSignetApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TBusiSignetApplyDO save(TBusiSignetApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TBusiSignetApplyDO> saveAll(List<TBusiSignetApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TBusiSignetApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // BaseBU
        if (payload.getBasebuId() != null) {
            update.set(qdo.basebuId, payload.getBasebuId());
        }
        // 所属公司
        if (payload.getOuId() != null) {
            update.set(qdo.ouId, payload.getOuId());
        }
        // 联系电话
        if (payload.getPhone() != null) {
            update.set(qdo.phone, payload.getPhone());
        }
        // 邮箱
        if (payload.getEmail() != null) {
            update.set(qdo.email, payload.getEmail());
        }
        // 印章用途
        if (payload.getSignetPurpose() != null) {
            update.set(qdo.signetPurpose, payload.getSignetPurpose());
        }
        // 申请印章
        if (payload.getSignetApply() != null) {
            update.set(qdo.signetApply, payload.getSignetApply());
        }
        // 是否外借
        if (payload.getLendFlag() != null) {
            update.set(qdo.lendFlag, payload.getLendFlag());
        }
        // 附件
        if (payload.getFileCode() != null) {
            update.set(qdo.fileCode, payload.getFileCode());
        }
        // 印章归还说明
        if (payload.getSignetReturnRemark() != null) {
            update.set(qdo.signetReturnRemark, payload.getSignetReturnRemark());
        }
        // 申请人
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 预计归还时间
        if (payload.getPredictReturnTime() != null) {
            update.set(qdo.predictReturnTime, payload.getPredictReturnTime());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }

        // 印章场景
        if (payload.getSignetScene() != null) {
            update.set(qdo.signetScene, payload.getSignetScene());
        }
        // 是否需要打印
        if (payload.getPrintFlag() != null) {
            update.set(qdo.printFlag, payload.getPrintFlag());
        }
        // 印章类型
        if (payload.getSignetType() != null) {
            update.set(qdo.signetType, payload.getSignetType());
        }
        // 相关印章
        if (payload.getRelatedSignet() != null) {
            update.set(qdo.relatedSignet, payload.getRelatedSignet());
        }
        // 印章所属公司
        if (payload.getSignetBelongCompany() != null) {
            update.set(qdo.signetBelongCompany, payload.getSignetBelongCompany());
        }

        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // BaseBU
            if (nullFields.contains("basebuId")) {
                update.setNull(qdo.basebuId);
            }
            // 所属公司
            if (nullFields.contains("ouId")) {
                update.setNull(qdo.ouId);
            }
            // 联系电话
            if (nullFields.contains("phone")) {
                update.setNull(qdo.phone);
            }
            // 邮箱
            if (nullFields.contains("email")) {
                update.setNull(qdo.email);
            }
            // 印章用途
            if (nullFields.contains("signetPurpose")) {
                update.setNull(qdo.signetPurpose);
            }
            // 申请印章
            if (nullFields.contains("signetApply")) {
                update.setNull(qdo.signetApply);
            }
            // 是否外借
            if (nullFields.contains("lendFlag")) {
                update.setNull(qdo.lendFlag);
            }
            // 附件
            if (nullFields.contains("fileCode")) {
                update.setNull(qdo.fileCode);
            }
            // 印章归还说明
            if (nullFields.contains("signetReturnRemark")) {
                update.setNull(qdo.signetReturnRemark);
            }
            // 申请人
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 预计归还时间
            if (nullFields.contains("predictReturnTime")) {
                update.setNull(qdo.predictReturnTime);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }

            // 印章场景
            if (nullFields.contains("signetScene")) {
                update.setNull(qdo.signetScene);
            }
            // 是否需要打印
            if (nullFields.contains("printFlag")) {
                update.setNull(qdo.printFlag);
            }
            // 印章类型
            if (nullFields.contains("signetType")) {
                update.setNull(qdo.signetType);
            }
            // 相关印章
            if (nullFields.contains("relatedSignet")) {
                update.setNull(qdo.relatedSignet);
            }
            // 印章所属公司
            if (nullFields.contains("signetBelongCompany")) {
                update.setNull(qdo.signetBelongCompany);
            }

        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

