package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveApplyDetailService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveApplyDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class RewardLeaveApplyDetailServiceImpl extends BaseServiceImpl implements RewardLeaveApplyDetailService {

    private final RewardLeaveApplyDetailRepo rewardLeaveApplyDetailRepo;
    private final RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO;

    @Override
    public PagingVO<RewardLeaveApplyDetailVO> queryPaging(RewardLeaveApplyDetailQuery query) {
        return rewardLeaveApplyDetailDAO.queryPaging(query);
    }

    @Override
    public List<RewardLeaveApplyDetailVO> queryListDynamic(RewardLeaveApplyDetailQuery query) {
        return rewardLeaveApplyDetailDAO.queryListDynamic(query);
    }

    @Override
    public RewardLeaveApplyDetailVO queryByKey(Long key) {
        RewardLeaveApplyDetailDO entity = rewardLeaveApplyDetailRepo.findById(key).orElseGet(RewardLeaveApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveApplyDetailVO vo = RewardLeaveApplyDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveApplyDetailVO insert(RewardLeaveApplyDetailPayload payload) {
        RewardLeaveApplyDetailDO entityDo = RewardLeaveApplyDetailConvert.INSTANCE.toDo(payload);
        return RewardLeaveApplyDetailConvert.INSTANCE.toVo(rewardLeaveApplyDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveApplyDetailVO update(RewardLeaveApplyDetailPayload payload) {
        RewardLeaveApplyDetailDO entity = rewardLeaveApplyDetailRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveApplyDetailDO entityDo = RewardLeaveApplyDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return RewardLeaveApplyDetailConvert.INSTANCE.toVo(rewardLeaveApplyDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(RewardLeaveApplyDetailPayload payload) {
        RewardLeaveApplyDetailDO entity = rewardLeaveApplyDetailRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = rewardLeaveApplyDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            rewardLeaveApplyDetailDAO.deleteSoft(keys);
        }
    }

}

