package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.org.payload.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.*;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgRoleConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 维度管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgOrganizationServiceImpl implements PrdOrgOrganizationService {

    final String default_role_Code = "ORG-LEADER";
    private final PrdOrgOrganizationDAO dao;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final CacheUtil cacheUtil;
    private final CalAccountService calAccountService;

    @Value("${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Transactional
    @Override
    public PrdOrgOrganizationVO insert(PrdOrgOrganizationPayload payload) {

        int count = dao.queryAll(payload.getOrgCode(), null, null).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        PrdOrgOrganizationDO ado = PrdOrgOrganizationConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setOrgId(ado.getId());
        refDao.setDimensionId(ado.getDimensionId());
        refDao.setOrgType(1);
        refDao.setParentId(payload.getParentId());
        refDao.setSortIndex(payload.getSortIndex());
        dao.saveRef(refDao);
        //创建组织默认角色
        PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
        roleDO.setOrgId(ado.getId());
        roleDO.setRoleCode(default_role_Code);
        roleDO.setRoleName("组织负责人");
        if (payload.getManageId() != null && payload.getManageId().longValue() != 0) {
            roleDO.setRoleEmployees(payload.getManageId() + "");
        }
        dao.saveRole(roleDO);

        //创建组织账户
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.BU.getCode());
        accountPayload.setAuId(ado.getId());
        accountPayload.setLedgerName(ado.getOrgName());
        accountPayload.setLedgerNo(ado.getOrgCode());
        calAccountService.insert(accountPayload);

        return PrdOrgOrganizationConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdOrgOrganizationPayload payload) {
        if (payload.getParentId() != null && payload.getParentId().longValue() == payload.getId().longValue()) {
            throw TwException.error("", "上级组织不可选择自身组织");
        }
        List<PrdOrgOrganizationRefVO> refVOS = dao.queryAll(payload.getOrgCode(), null, null);
        if (refVOS.size() == 0 || (refVOS.size() == 1 && refVOS.get(0).getOrgId().longValue() == payload.getId().longValue())) {
            PrdOrgOrganizationRefVO ovo = dao.queryByRefId(payload.getId());
            if (ovo != null && ovo.getDimensionId().longValue() == payload.getDimensionId().longValue()) {
                if (payload.getParentId() != null && payload.getParentId().longValue() > 0) {
                    PrdOrgOrganizationRefPayload refPayload = new PrdOrgOrganizationRefPayload();
                    refPayload.setOrgId(payload.getId());
                    refPayload.setDimensionId(payload.getDimensionId());
                    refPayload.setParentId(payload.getParentId());
                    refPayload.setSortIndex(payload.getSortIndex());
                    dao.updateRef(refPayload);
                }
                if (payload.getManageId() != null && payload.getManageId().longValue() != 0) {
                    dao.updateRoleEmployees(payload.getId(), default_role_Code, payload.getManageId() + "");
                }
                //更新主表
                return dao.updateByKeyDynamic(payload);
            } else {
                throw TwException.error("", "编号不可重复");
            }
        } else {
            throw TwException.error("", "引用组织不可编辑");
        }

    }

    @Transactional
    @Override
    public Long updateRef(PrdOrgOrganizationRefPayload payload) {
        return dao.updateRef(payload);
    }

    @Transactional
    @Override
    public Long reference(PrdOrgOrganizationRefPayload payload) {
        if (payload.getParentId().longValue() == payload.getOrgId().longValue()) {
            throw TwException.error("", "引用组织关系错误");
        }
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(payload.getDimensionId(), payload.getOrgId());
        if (ordo != null) {
            if (ordo.getOrgType().intValue() == 2) {
                throw TwException.error("", "当前维度下已存在该组织引用关系");
            }
        }
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setParentId(payload.getParentId());
        refDao.setOrgId(payload.getOrgId());
        refDao.setOrgType(2);
        refDao.setDimensionId(payload.getDimensionId());
        refDao.setSortIndex(payload.getSortIndex());
        dao.saveRef(refDao);
        return 0L;
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            if (ordo.getOrgType().intValue() == 2) {
                //表示删除引用关系，只要删除关系表即可
                dao.deleteRefSoft(ordo.getId());
                return true;
            } else {
                PrdOrgOrganizationDO organizationDO = dao.queryById(orgId);
                //首先判断该组织是否是激活状态，如果是激活状态的话不能删除
                if (!organizationDO.getOrgStatus().equalsIgnoreCase("active")) {
                    PrdOrgOrganizationRefDO organizationRefDO = dao.queryFirstByParentId(orgId);
                    //判断该组织是否有下属组织
                    if (organizationRefDO == null) {
                        List<PrdOrgEmployeeRefVO> empList = dao.queryEmployeeList(orgId);
                        //判断该组织是否有下属员工
                        if (empList == null || empList.size() == 0) {
                            //表示删除归属，删除所有该组织关系并删除组织
                            dao.deleteAllRefSoft(orgId);
                            dao.deleteSoft(orgId);
                            return true;
                        }

                    }
                }
            }
        }
        throw TwException.error("", "删除失败，该组织已激活或存在下属关系");
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryList(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = default_dimension_id;
        }
        List<PrdOrgOrganizationRefVO> organizationRefVOS = dao.queryOrgList(dimensionId, null);
        for (PrdOrgOrganizationRefVO rvo : organizationRefVOS) {
            List<PrdOrgEmployeeRefVO> refVOS = dao.queryEmployeeList(rvo.getOrgId());
            if (rvo.getManageId() != null) {
                Optional<PrdOrgEmployeeRefVO> first = refVOS.stream().filter(a -> (rvo.getManageId().longValue() == a.getUserId().longValue())).findFirst();
                if (!first.isEmpty()) {
                    first.get().setIsManage(0);
                }
            }
            rvo.setOrgEmployees(refVOS);
        }
        return organizationRefVOS;
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryList() {
        List<PrdOrgOrganizationRefVO> organizationRefVOS = dao.queryOrgList(-1L, null);
        return organizationRefVOS;
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryAll(Long dimensionId, Boolean defaultFlag) {

        return dao.queryAll(null, dimensionId, defaultFlag);
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryByOrgStatus(String orgStatus) {
        return dao.queryByOrgStatus(orgStatus);
    }

    @Override
    public List<PrdOrgOrganizationVO> queryAllByQuery(PrdOrgOrganizationQuery query) {
        return dao.queryAll(query);
    }


    @Override
    public PagingVO<PrdOrgOrganizationVO> paging(PrdOrgOrganizationQuery query) {

        return dao.queryPaging(query);
    }

    @Override
    public List<PrdOrgEmployeeRefVO> queryEmployeeRefList(Long orgId) {
        return dao.queryEmployeeList(orgId);
    }

//    @Override
//    public PrdOrgOrganizationVO queryOrgById(Long id) {
//        PrdOrgOrganizationVO ovo = dao.queryOrgById(id);
//        if (ovo != null) {
//            List<PrdOrgRoleVO> roleVos = dao.queryRoleList(id);
//            if (roleVos != null && roleVos.size() > 0) {
//                for (PrdOrgRoleVO role : roleVos) {
//                    if (!ObjectUtils.isEmpty(role.getRoleEmployees())) {
//                        String[] employeeStrs = role.getRoleEmployees().split(",");
//                        List<Long> employeeIds = new ArrayList<>();
//                        for (int i = 0; i < employeeStrs.length; i++) {
//                            employeeIds.add(Long.valueOf(employeeStrs[i]));
//                        }
//                        role.setOrgEmployees(dao.queryRoleEmployeeList(employeeIds));
//                    }
//                }
//            }
//            ovo.setOrgRoles(roleVos);
//            String selcetKey = "org:manage:status";
//            PrdSystemSelectionVO view = cacheUtil.getSystemSelection(selcetKey);
//            if (view != null && view.getChildren() != null && !view.getChildren().isEmpty()) {
//                List<PrdSystemSelectionVO> childrens = view.getChildren();
//                for (PrdSystemSelectionVO selectionVO : childrens) {
//                    if (selectionVO.getSelectionValue().equalsIgnoreCase(ovo.getOrgStatus())) {
//                        ovo.setOrgStatusName(selectionVO.getSelectionName());
//                        break;
//                    }
//                }
//            }
//            return ovo;
//        }
//        return null;
//    }

    @Override
    public PrdOrgOrganizationVO queryDetail(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            PrdOrgOrganizationVO ovo = dao.queryOrgById(orgId);
            ovo.setOrgType(ordo.getOrgType());
            ovo.setParentId(ordo.getParentId());
            if (ovo != null) {
                List<PrdOrgRoleVO> roleVos = dao.queryRoleList(orgId);
                for (PrdOrgRoleVO role : roleVos) {
                    if (!ObjectUtils.isEmpty(role.getRoleEmployees())) {
                        String[] employeeStrs = role.getRoleEmployees().split(",");
                        List<Long> employeeIds = new ArrayList<>();
                        for (int i = 0; i < employeeStrs.length; i++) {
                            employeeIds.add(Long.valueOf(employeeStrs[i]));
                        }
                        role.setOrgEmployees(dao.queryRoleEmployeeList(employeeIds));
                    }
                }
                ovo.setOrgRoles(roleVos);
                String selcetKey = "org:manage:status";
                PrdSystemSelectionVO view = cacheUtil.getSystemSelection(selcetKey);
                if (view != null && view.getChildren() != null && !view.getChildren().isEmpty()) {
                    List<PrdSystemSelectionVO> childrens = view.getChildren();
                    for (PrdSystemSelectionVO selectionVO : childrens) {
                        if (selectionVO.getSelectionValue().equalsIgnoreCase(ovo.getOrgStatus())) {
                            ovo.setOrgStatusName(selectionVO.getSelectionName());
                            break;
                        }
                    }
                }
                return ovo;
            }
        }

        return null;
    }

    @Override
    public PrdOrgRoleVO queryRoleByOrgIdAndRoleCode(Long orgId, String code) {
        return dao.queryRoleByOrgIdAndRoleCode(orgId, code);
    }


    @Override
    public PrdOrgOrganizationVO queryDetailSimpleByOrgId(Long orgId) {
        final PrdOrgOrganizationDO prdOrgOrganizationDO = dao.queryById(orgId);
        final PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
        return prdOrgOrganizationVO;
    }

    @Transactional
    @Override
    public Long insertEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {

        List<Long> employeeIds = new ArrayList<>();
        List<Long> employeeRemoveIds = new ArrayList<>();

        List<PrdOrgEmployeeRefDO> employeeRefDOs = new ArrayList<>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            if (payload.getParentId().longValue() == payload.getUserId().longValue()) {
                throw TwException.error("", "提交上级数据异常");
            }
            PrdOrgEmployeeRefDO ado = dao.queryByOrgIdAndEmpId(payload.getOrgId(), payload.getUserId());
            if (ado == null) {
                if (payload.getIsDefault() == 0) {
                    employeeIds.add(payload.getUserId());
                }
                if (payload.getIsRemove() == 0) {
                    employeeRemoveIds.add(payload.getUserId());
                }
                ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
                ado.setJoinDate(LocalDate.now());
                employeeRefDOs.add(ado);
            }
        }
        if (employeeRemoveIds.size() > 0) {
            dao.updateEmployeeRefFlag(employeeRemoveIds);
        }
        if (employeeIds.size() > 0) {
            dao.updateEmployeeRefStatus(employeeIds);
        }
        if (employeeRefDOs.size() > 0) {
            dao.saveEmployeeRef(employeeRefDOs);
        }
        return 0L;
    }

    @Transactional
    @Override
    public boolean deleteEmployeeRefSoft(Long orgId, List<Long> userIds) {
        long num = dao.deleteEmployeeRefSoft(orgId, userIds);
        if (num < userIds.size()) {
            throw TwException.error("", "员工默认组织不可被移除");
        }
        return true;
    }

    @Transactional
    @Override
    public PrdOrgRoleVO insertRole(PrdOrgRolePayload payload) {
        PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
        dao.saveRole(ado);
        return PrdOrgRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long updateRole(PrdOrgRolePayload payload) {
        if (payload.getRoleCode() != null && !payload.getRoleCode().equals(default_role_Code)) {
            if (payload.getId() == null || payload.getId().longValue() == 0 || dao.queryRoleByKey(payload.getId()) == null) {
                PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
                dao.saveRole(ado);
            } else {
                dao.updateRole(payload);
            }
        }
        return 0L;
    }

    @Transactional
    @Override
    public Boolean deleteRoleSoft(Long key) {
        return dao.deleteRoleSoft(key) >= 0;
    }

    @Transactional
    @Override
    public Long updateStatus(Long id, String orgStatus) {
        if (id != null && StringUtils.hasText(orgStatus)) {
            if (orgStatus.equalsIgnoreCase("active")) {
                PrdOrgOrganizationVO pvo = dao.queryParentOrgById(id);
                if (pvo != null && !pvo.getOrgStatus().equalsIgnoreCase("active")) {
                    throw TwException.error("", "上级组织是非激活状态");
                }
            }
            dao.updateStatus(id, orgStatus);
        } else {
            throw TwException.error("", "参数错误 id：" + id + " orgStatus：" + orgStatus);
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long updateOrgOrEmpRef(List<PrdOrgOrganizationDataPayload> payloads) {
        List<Long> orgRefIds = new ArrayList<>();
        List<Long> empRefIds = new ArrayList<>();
        Map<Long, PrdOrgOrganizationDataPayload> mapDatas = new HashMap<>();
        for (PrdOrgOrganizationDataPayload payload : payloads) {
            if (payload.getDataType().equals("org")) {
                orgRefIds.add(payload.getId());
            } else {
                empRefIds.add(payload.getId());
            }
            mapDatas.put(payload.getId(), payload);
        }

        List<PrdOrgOrganizationRefDO> orgRefDOs = new ArrayList<>();
        if (orgRefIds.size() > 0) {
            orgRefDOs = dao.queryByOrgRefIds(orgRefIds);
        }
        for (PrdOrgOrganizationRefDO orgRefDO : orgRefDOs) {
            PrdOrgOrganizationDataPayload payload = mapDatas.get(orgRefDO.getId());
            Long parentId = orgRefDO.getParentId() == null ? 0L : orgRefDO.getParentId();
            if (payload.getChangeId().longValue() != parentId.longValue() || payload.getSortIndex().intValue() != orgRefDO.getSortIndex().intValue()) {
                orgRefDO.setParentId(payload.getChangeId());
                orgRefDO.setSortIndex(payload.getSortIndex());
                dao.updateOrgRef(orgRefDO);
            }
        }
        List<PrdOrgEmployeeRefDO> employeeRefDOs = new ArrayList<>();
        if (empRefIds.size() > 0) {
            employeeRefDOs = dao.queryByEmployeeRefIds(empRefIds);
        }
        for (PrdOrgEmployeeRefDO empRefDO : employeeRefDOs) {
            PrdOrgOrganizationDataPayload payload = mapDatas.get(empRefDO.getId());
            if (payload.getChangeId().longValue() != empRefDO.getOrgId().longValue() || payload.getSortIndex().intValue() != empRefDO.getSortIndex().intValue()) {
                empRefDO.setOrgId(payload.getChangeId());
                empRefDO.setSortIndex(payload.getSortIndex());
                dao.updateEmployeeRef(empRefDO);
            }
        }

        return 0L;
    }

    @Override
    public Map<Long, String> queryOrgs(List<Long> orgIds) {
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));
        return orgMap;
    }

    @Override
    public Map<Long, Long> getV4AndV5OrgIds() {
        Map<Long, Long> orgMap = new HashMap<>();
        //查询公司列表
        List<Map<String, Object>> v4AndV5OrgIds = dao.getV4AndV5OrgIds();
        for (Map<String, Object> v4AndV5OrgId : v4AndV5OrgIds) {
            Long orgId = (Long) v4AndV5OrgId.get("orgId");
            Long orgIdV4 = (Long) v4AndV5OrgId.get("orgIdV4");
            if (orgId != null && orgIdV4 != null) {
                orgMap.put(orgIdV4, orgId);
            }
        }
        return orgMap;
    }

    @Override
    public List<PrdOrgDataRefVO> queryOrgRefList() {
        return employeeDAO.queryOrgList();

    }

    @Override
    public List<PrdOrgRoleVO> queryRoleList() {
        return dao.queryRoleList(null);
    }

    @Override
    public List<Long> queryByManageIdOrgIds(Long userId) {
        return dao.queryByManageIdOrgIds(userId);
    }

    @Override
    public List<PrdOrgOrganizationVO> queryByManageIdOrgs(Long userId) {
        return dao.queryByManageIdOrgs(userId);
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryOrgRoleList(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = default_dimension_id;
        }
        List<PrdOrgOrganizationRefVO> organizationRefVOS = dao.queryOrgList(dimensionId, null);
        List<Long> orgIds = organizationRefVOS.stream().map(PrdOrgOrganizationRefVO::getOrgId).collect(Collectors.toList());
        List<PrdOrgRoleVO> prdOrgRoleVOS = dao.queryRolesByOrgIds(orgIds);
        if (!ObjectUtils.isEmpty(prdOrgRoleVOS)) {
            Map<Long, List<PrdOrgRoleVO>> roleMap = prdOrgRoleVOS.stream().collect(Collectors.groupingBy(PrdOrgRoleVO::getOrgId));
            organizationRefVOS.forEach(vo -> {
                vo.setOrgRoles(roleMap.get(vo.getOrgId()));
            });
        }
        return organizationRefVOS;
    }

    @Override
    public List<PrdOrgRoleVO> queryRolesByDimensionId(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = default_dimension_id;
        }
        return dao.queryRolesByDimensionId(dimensionId);
    }

    @Override
    public List<PrdOrgRoleVO> queryUserOrgRoles(Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        return dao.queryRolesByUserId(userId);
    }


    @Override
    public Long queryManageIdById(Long id) {
        return dao.queryManageIdById(id);
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryAllChildOrgByUserId(Long userId) {
        //先查询所有的组织
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = queryList();
        List<PrdOrgOrganizationRefVO> childList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getManageId().equals(userId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getParentId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getParentId));
            getChildOrgList(orgList, childList, orgMap);
            return childList;
        }
        return null;
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryAllChildOrgByOrgId(Long orgId) {
        //先查询所有的组织
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = queryList();
        List<PrdOrgOrganizationRefVO> childList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId().equals(orgId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getParentId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getParentId));
            getChildOrgList(orgList, childList, orgMap);
            return childList;
        }
        return null;
    }

    @Override
    public List<Long> queryAllOrgIdsByUserId(Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = employeeDAO.queryAllOrgRefByUserId(userId);
        if (prdOrgEmployeeRefVOS.size() > 0) {
            List<Long> collect = prdOrgEmployeeRefVOS.stream().map(PrdOrgEmployeeRefVO::getOrgId).collect(Collectors.toList());
            Set<Long> orgIds = dao.queryAllChildOrgs((Set<Long>) collect);
            orgIds.addAll(collect);
            return new ArrayList<>(orgIds);
        }
        return new ArrayList<>();
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryAllFatherOrgByOrgId(Long orgId) {
        //先查询所有的组织
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = queryList();
        List<PrdOrgOrganizationRefVO> fatherList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId().equals(orgId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getOrgId));
            getFatherOrgList(orgList, fatherList, orgMap);
            return fatherList;
        }
        return null;
    }

    public void getChildOrgList(List<PrdOrgOrganizationRefVO> orgList, List<PrdOrgOrganizationRefVO> childList, Map<Long, List<PrdOrgOrganizationRefVO>> orgMap) {
        if (!CollectionUtils.isEmpty(orgList)) {
            childList.addAll(orgList);
            List<PrdOrgOrganizationRefVO> list = new ArrayList();
            orgList.stream().forEach(p -> {
                if (orgMap.containsKey(p.getOrgId())) {
                    list.addAll(orgMap.get(p.getOrgId()));
                }
            });
            if (!CollectionUtils.isEmpty(list)) {
                getChildOrgList(list, childList, orgMap);
            }
        }

    }

    public void getFatherOrgList(List<PrdOrgOrganizationRefVO> orgList, List<PrdOrgOrganizationRefVO> fatherList, Map<Long, List<PrdOrgOrganizationRefVO>> orgMap) {
        if (!CollectionUtils.isEmpty(orgList)) {
            fatherList.addAll(orgList);
            List<PrdOrgOrganizationRefVO> list = new ArrayList();
            orgList.stream().forEach(p -> {
                if (orgMap.containsKey(p.getParentId()) && p.getParentId() != null && p.getParentId().longValue() != 0 && !p.getParentId().equals(p.getId())) {
                    list.addAll(orgMap.get(p.getParentId()));
                }
            });
            if (!CollectionUtils.isEmpty(list)) {
                getFatherOrgList(list, fatherList, orgMap);
            }
        }

    }


    /**
     * 判断当前人员是否在当前部门，及子部门
     *
     * @param userId
     * @param orgIds
     * @return
     */
    @Override
    public Boolean containCheck(Long userId, String orgIds) {
        List<PrdOrgOrganizationRefVO> orgIdAll = new ArrayList<>();
        List<Long> orgIdList = Arrays.stream(orgIds.split(",")).map(e -> Long.parseLong(e)).collect(Collectors.toList());
        for (Long orgId : orgIdList) {
            // 查询部门及子部门
            List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = queryAllChildOrgByOrgId(orgId);
            orgIdAll.addAll(prdOrgOrganizationRefVOS);
        }
        List<Long> orgIdAllList = orgIdAll.stream().map(e -> e.getOrgId()).collect(Collectors.toList());


        //查询用户部门关系列表表
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = employeeDAO.queryUserOrgDataList();


        // 查询当前用户所属部门
        for (PrdOrgEmployeeRefVO prdOrgEmployeeRefVO : prdOrgEmployeeRefVOS) {
            if (orgIdAllList.contains(prdOrgEmployeeRefVO.getOrgId()) && prdOrgEmployeeRefVO.getUserId().equals(userId)) {
                return true;
            }
        }
        return false;
    }
}
