package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.*;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.*;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BusinessTranslateJdeStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.*;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessCustomerInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCustomerInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessCustomerInfoServiceImpl extends BaseServiceImpl implements BusinessCustomerInfoService {

    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessCustomerInfoDAO businessCustomerInfoDAO;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final CrmLeadsDAO leadsDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    //private final BusinessTeamMemberService businessTeamMemberService;
    private final CacheUtil cacheUtil;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    @Value("${tw4.prd_ab.updateCustomerOperation:api/openReport/v1/sync/asyncUpdateCustomerTask}")
    private String prd_ab_operation;
    @Value("${tw5.jde.syncJdeUrl}")
    private String syncJdeUrl;
    @Value("${tw5.jde.username}")
    private String username;

    @Value("${tw5.jde.password}")
    private String password;
    @Value("${tw5.jde.count:3}")
    private Integer count;

    private final HttpUtil httpUtil;
    // private final PrdOrgCompanyService prdOrgCompanyService;
    private final ApiRequestLogService apiRequestLogService;


    private final BookInvoiceService bookInvoiceService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final BookContactsService bookContactsService;

    @Override
    public PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query) {
        PagingVO<BusinessCustomerInfoVO> businessCustomerInfoVOPagingVO = businessCustomerInfoDAO.queryPaging(query);
        return businessCustomerInfoVOPagingVO;
    }

    @Override
    public List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query) {
        List<BusinessCustomerInfoVO> businessCustomerInfoVOS = businessCustomerInfoDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
            businessCustomerInfoVOS.stream().forEach(p -> translate(p));
        }
        return businessCustomerInfoVOS;
    }

    @Override
    public BusinessCustomerInfoVO queryByKey(Long key) {
        BusinessCustomerInfoDO entity = businessCustomerInfoRepo.findById(key).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessCustomerInfoVO vo = BusinessCustomerInfoConvert.INSTANCE.toVo(entity);
        translate(vo);
        return vo;
    }


    @Override
    public BusinessCustomerInfoVO queryByPartnerId(Long partnerId) {
        BusinessCustomerInfoDO entity = businessCustomerInfoRepo.findByPartnerId(partnerId);
        Assert.notNull(entity.getId(), "不存在");
        BusinessCustomerInfoVO vo = BusinessCustomerInfoConvert.INSTANCE.toVo(entity);
        translate(vo);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessCustomerInfoVO insert(BusinessCustomerInfoPayload payload) {
        payload.setSyncJdeFlag(false);
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        BusinessCustomerInfoDO save = businessCustomerInfoRepo.save(entityDo);
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessCustomerInfoVO update(BusinessCustomerInfoPayload payload) {
        BusinessCustomerInfoDO entity = businessCustomerInfoRepo.findById(payload.getId()).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        BusinessCustomerInfoDO entityLog = new BusinessCustomerInfoDO();
        BeanUtils.copyProperties(entity, entityLog);
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);

        //操作记录
        if (null != payload.getPartnerId()) {
            // 修改NULL值特殊处理
            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
            //获取变更日志
            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText(fieldsUpdateLog)) {
                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
            //  logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "更改账户信息");
        }
        //保存数据
        BusinessCustomerInfoDO save = businessCustomerInfoRepo.save(entity);
        if (payload.getServiceUserId() != null || payload.getBusinessUserId() != null || payload.getCareUserId() != null || payload.getOperationUserId() != null) {
            //如果团队成员更新了 这里也要更新
            BusinessCutomerManagePayload businessCutomerManagePayload = new BusinessCutomerManagePayload();
            businessCutomerManagePayload.setBusinessUserId(payload.getBusinessUserId());
            businessCutomerManagePayload.setServiceUserId(payload.getServiceUserId());
            businessCutomerManagePayload.setCareUserId(payload.getCareUserId());
            businessCutomerManagePayload.setOperationUserId(payload.getOperationUserId());
            businessCutomerManagePayload.setId(save.getPartnerId());
            updateCustomerManageTeamMember(businessCutomerManagePayload);
        }
        final Long partnerId = save.getPartnerId();
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessCustomerInfoDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<BusinessCustomerSimpleVO> listSimple(String identity, String customerStatus) {
        if (BusinessPartnerIdentityEnum.INNER.getCode().equals(identity)) {
            return businessCustomerInfoDAO.queryInnerCompany();
        } else {

            List<BusinessCustomerSimpleVO> businessCustomerSimpleVOS = businessCustomerInfoDAO.listSimple(identity, customerStatus);
            // 新增供应商状态
            if (!org.apache.commons.lang3.StringUtils.isEmpty(identity) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(identity)) {

                List<Long> ids = businessCustomerSimpleVOS.stream().map(x -> x.getId()).collect(Collectors.toList());
                BusinessSupplierInfoQuery businessSupplierInfoQuery = new BusinessSupplierInfoQuery();
                businessSupplierInfoQuery.setPartnerIds(ids);
                List<BusinessSupplierInfoVO> businessSupplierInfoVOS = businessSupplierInfoService.queryListDynamic(businessSupplierInfoQuery);
                Map<Long, String> maps = businessSupplierInfoVOS.stream().collect(Collectors.toMap(BusinessSupplierInfoVO::getPartnerId, BusinessSupplierInfoVO::getSupplierStatus));

                for (BusinessCustomerSimpleVO businessCustomerSimpleVO : businessCustomerSimpleVOS) {
                    String status = maps.get(businessCustomerSimpleVO.getId());
                    businessCustomerSimpleVO.setSupplierStatus(status);
                }
            }
            // 增加联系人信息
            List<Long> bookIdList = businessCustomerSimpleVOS.stream().map(x -> x.getBookId()).collect(Collectors.toList());
            BookContactsQuery bookContactsQuery = new BookContactsQuery();
            bookContactsQuery.setBookIdList(bookIdList);
            bookContactsQuery.setIsDefault(true);
            List<BookContactsVO> bookContactsVOS = bookContactsService.queryListDynamic(bookContactsQuery);
            if(!CollectionUtils.isEmpty(bookContactsVOS)){
                final Map<Long, List<BookContactsVO>> bookContactMap = bookContactsVOS.stream().collect(Collectors.groupingBy(BookContactsVO::getBookId));
                for (BusinessCustomerSimpleVO businessCustomerSimpleVO : businessCustomerSimpleVOS) {
                    if(bookContactMap.containsKey(businessCustomerSimpleVO.getBookId())){
                        businessCustomerSimpleVO.setBookContactsVO(bookContactMap.get(businessCustomerSimpleVO.getBookId()).get(0));
                    }
                }
            }
            return businessCustomerSimpleVOS;
        }
    }

    @Override
    public PagingVO<BusinessCustomerSimpleVO> listSimplePaging(BusinessPartnerListSimpleQuery query) {

        PagingVO<BusinessCustomerSimpleVO> businessCustomerSimpleVOPagingVO = businessCustomerInfoDAO.listSimplePaging(query);


        return businessCustomerSimpleVOPagingVO;
    }


    @Override
    public CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId) {
        return businessCustomerInfoDAO.listSimpleByPartnerId(partnerId);
    }

    @Override
    public List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query) {
        return businessCustomerInfoDAO.queryCustomerList(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCustomerGrade() {
        businessCustomerInfoDAO.updateCustomerGrade();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeCustomerGrade(Long partnerId, String customerGrade) {
        //更新线索跟进级别
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        //leadsQuery.setFormalCustomerId(customerId);
        //更改为业务伙伴id
        leadsQuery.setFormalCustomerId(partnerId);
        Specification<CrmLeadsDO> spec = leadsDAO.getSpec(leadsQuery);
        List<CrmLeadsDO> leadsDOS = leadsDAO.findAll(spec);
        List<Long> leadsIds = leadsDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        leadsDAO.updateCustomerGrade(leadsIds, customerGrade);
        //更新潜在客户跟进级别(筛选出关联了潜在客户的线索)
        List<CrmLeadsDO> collect = leadsDOS.stream().filter(e -> e.getPotentialCustomerId() != null).collect(Collectors.toList());
        List<Long> potentialCustomerIds = collect.stream().map(e -> e.getPotentialCustomerId()).collect(Collectors.toList());
        potentialCustomerDAO.updateCustomerGrade(potentialCustomerIds, customerGrade);
    }

    @Override
    public PagingVO<BusinessCutomerManageVO> queryCustomerManage(BusinessCustomerInfoQuery query) {
        //数据权限处理
        dataPermission(query);
        PagingVO<BusinessCutomerManageVO> businessCutomerManageVOPagingVO = businessCustomerInfoDAO.queryCustomerManage(query);
        if (!CollectionUtils.isEmpty(businessCutomerManageVOPagingVO.getRecords())) {
            List<Long> idList = businessCutomerManageVOPagingVO.stream().map(p -> p.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                //分页页面 团队成员负责人翻译
                Map<Long, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
                ///先查询团队成员
                BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
                teamMemberQuery.setObjectIdList(idList);
                BusinessTeamMemberService businessTeamMemberService = SpringUtil.getBean(BusinessTeamMemberService.class);
                List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
                if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                    teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));
                }
                for (BusinessCutomerManageVO businessCutomerManageVO : businessCutomerManageVOPagingVO.getRecords()) {
                    customerManageTranslate(businessCutomerManageVO, teamMemberMap);
                }


            }
        }
        return businessCutomerManageVOPagingVO;
    }

    @Override
    public List<BusinessCutomerManageVO> queryCustomerManageList(BusinessCustomerInfoQuery query) {
        //数据权限
        dataPermission(query);
        List<BusinessCutomerManageVO> businessCutomerManageVOVOS = businessCustomerInfoDAO.queryCustomerManageList(query);
        if (!CollectionUtils.isEmpty(businessCutomerManageVOVOS)) {
            List<Long> idList = businessCutomerManageVOVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                Map<Long, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
                ///先查询团队成员
                BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
                teamMemberQuery.setObjectIdList(idList);
                BusinessTeamMemberService businessTeamMemberService = SpringUtil.getBean(BusinessTeamMemberService.class);
                List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
                if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                    teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));
                }
                for (BusinessCutomerManageVO businessCutomerManageVO : businessCutomerManageVOVOS) {
                    customerManageTranslate(businessCutomerManageVO, teamMemberMap);
                }
            }
        }
        return businessCutomerManageVOVOS;
    }


    @Override
    public BusinessCutomerManageVO queryCustomerManageByPartnerId(Long id) {
        return businessCustomerInfoDAO.queryCustomerManageByPartnerId(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCustomerManageTeamMember(BusinessCutomerManagePayload payload) {
        BusinessTeamMemberService businessTeamMemberService = SpringUtil.getBean(BusinessTeamMemberService.class);
        List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryByObjectId(payload.getId());
        Map<String, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
        List<BusinessTeamMemberPayload> payloadList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
            teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
        }
        //服务负责人
        if (payload.getServiceUserId() != null) {
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getServiceUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                List<BusinessTeamMemberVO> businessTeamMemberVOS1 = teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                BusinessTeamMemberVO businessTeamMemberVO = businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getServiceUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getServiceUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SERVICE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SERVICE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }

        //商务负责人
        if (payload.getBusinessUserId() != null) {
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getBusinessUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                List<BusinessTeamMemberVO> businessTeamMemberVOS1 = teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                BusinessTeamMemberVO businessTeamMemberVO = businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getBusinessUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getBusinessUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SALE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SALE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }

        //关怀负责人
        if (payload.getCareUserId() != null) {
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getCareUserId());

            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                List<BusinessTeamMemberVO> businessTeamMemberVOS1 = teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode());
                BusinessTeamMemberVO businessTeamMemberVO = businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getCareUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);

            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getCareUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CARE.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CARE.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CARE.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }

        //运维售后负责人
        if (payload.getOperationUserId() != null) {
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getOperationUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                List<BusinessTeamMemberVO> businessTeamMemberVOS1 = teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode());
                BusinessTeamMemberVO businessTeamMemberVO = businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getOperationUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getOperationUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.OPERATION.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.OPERATION.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.OPERATION.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (!CollectionUtils.isEmpty(payloadList)) {
            businessTeamMemberService.saveAll(payloadList);
        }
    }

    //客户激活
    @Override
    @Transactional
    public void activeCustomerWithWorkFlow(Long partnerId, String partnerName, Long bookId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();

        // 校验开票信息
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = bookInvoiceService.count(bookInvoiceQuery);
            if (count1 == 0) {
                throw new BusinessException("激活前请先维护开票信息");
            }
        }

        String customerStatus = BusinessPartnerStatusEnum.ACTIVE.getCode();
        if (workflow_enabled) {
            //获取申请人
            HashMap variables = dealActiveWorkFlowVariables(businessCustomerInfoVO);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.CUSTOMER_ACTIVE.name(),
                    partnerName + "-客户激活流程",
                    businessCustomerInfoVO.getId() + "",
                    variables)
            );
            customerStatus = BusinessPartnerStatusEnum.APPROVING.getCode();
        }
        //流程启动成功后，回写业务表数据
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCustomerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setCustomerStatus(customerStatus);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            businessCustomerInfoDAO.updateByKeyDynamic(payload);
        });

    }

    //客户激活
    @Override
    @Transactional
    public void activeCustomer(Long partnerId, String partnerName, Long bookId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = queryByPartnerId(partnerId);
        // 校验开票信息
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = bookInvoiceService.count(bookInvoiceQuery);
            if (count1 == 0) {
                throw new BusinessException("激活前请先维护开票信息");
            }
        }
        String customerStatus = BusinessPartnerStatusEnum.ACTIVE.getCode();
        //流程启动成功后，回写业务表数据
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setId(businessCustomerInfoVO.getId());
        payload.setCustomerStatus(customerStatus);
        businessCustomerInfoDAO.updateByKeyDynamic(payload);
    }

    //客户暂挂
    @Override
    @Transactional
    public void pendingCustomer(Long partnerId, String partnerName) {
        BusinessCustomerInfoVO businessCustomerInfoVO = queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();
        if (workflow_enabled) {
            //获取申请人
            HashMap variables = dealActiveWorkFlowVariables(businessCustomerInfoVO);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.CUSTOMER_PENDING.name(),
                    partnerName + "-客户暂挂流程",
                    businessCustomerInfoVO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCustomerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            businessCustomerInfoDAO.updateByKeyDynamic(payload);
        });

    }

//    @Override
//    @Transactional
//    public void businessCustomerSyncTw4(String businessPartnerNo) {
//        List<BusinessCustomerSyncPayload> businessCustomerSyncPayloads = businessCustomerInfoDAO.queryBusinessCustomerSyncTw4(businessPartnerNo);
//        if(!CollectionUtils.isEmpty(businessCustomerSyncPayloads)){
//            log.info("客户更新同步4.0: "+ JSONUtil.toJsonStr(businessCustomerSyncPayloads));
//            //开始调用4.0业务伙伴主档同步接口
//            log.info("-----------业务伙伴客户更新同步4.0 start-------------");
//            String result = httpUtil.sendSyncPost(prd_ab_operation, JSONUtil.toJsonStr(businessCustomerSyncPayloads));
//            httpUtil.geResultData(result);
//            //查看返回数据是否有误
//            log.info("-----------业务伙伴客户更新同步4.0 end-------------");
//            List<Long> idList = businessCustomerSyncPayloads.stream().map(p -> p.getId()).collect(Collectors.toList());
//            businessCustomerInfoDAO.updateSyncUpdateCustomer(idList);
//        }
//
//    }

    @Override
    public void updateBusinessParnerCustomerModifyTime(Long partnerId) {
        businessCustomerInfoDAO.updateBusinessParnerCustomerModifyTime(partnerId);
    }


    @Override
    public Boolean activeCustomerCheck(Long bookId) {
        Assert.notNull(bookId, "bookid不能为空");
        // 校验开票信息
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = bookInvoiceService.count(bookInvoiceQuery);
            if (count1 > 0) {
                return true;
            }
        }

        return false;
    }

    //校验返回参数
    public Integer checkoutJdeResult(String result, String partnerName) {
        JSONObject jsonObject = JSONUtil.parseObj(result);
        String jdeStatus = jsonObject.getStr("jde__status");
        if (!"SUCCESS".equals(jdeStatus)) {
            throw TwException.error("", partnerName + "同步jde失败");
        }
        //返回客户/供应商编号
        Integer customerNo = -1;
        if (jsonObject.containsKey("Address Number")) {
            customerNo = jsonObject.getInt("Address Number");
        } else if (jsonObject.containsKey("Previously Assigned Number")) {
            customerNo = jsonObject.getInt("Previously Assigned Number");
        }
        if (customerNo == -1) {
            throw TwException.error("", partnerName + "同步jde失败");
        }
        return customerNo;

    }

    //翻译某些字段
    public void translate(BusinessCustomerInfoVO vo) {
        //处理客户经营
        CrmCustomerOperationService crmCustomerOperationService = SpringUtil.getBean(CrmCustomerOperationService.class);
        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
        crmCustomerOperationQuery.setCustomerId(vo.getPartnerId());
        List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);
        if (!CollectionUtils.isEmpty(crmCustomerOperationVOS)) {
            String custOperStatus = crmCustomerOperationVOS.get(0).getCustOperStatus();
            if (org.springframework.util.StringUtils.hasText(custOperStatus)) {
                String custOperStatusDesc = cacheUtil.transferSystemSelection("CRM:BUSINESS_PARTNER:OPER_STATUS", custOperStatus);
                vo.setCustOperStatusName(custOperStatusDesc);
            }
        }
    }

    //客户管理翻译
    public void customerManageTranslate(BusinessCutomerManageVO vo, Map<Long, List<BusinessTeamMemberVO>> teamMemberMap) {
        if (teamMemberMap.containsKey(vo.getId())) {
            List<BusinessTeamMemberVO> businessTeamMemberVOS = teamMemberMap.get(vo.getId());
            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                Map<String, List<BusinessTeamMemberVO>> memberRoleMap = businessTeamMemberVOS.stream().filter(p -> p.getMemberRole() != null).collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
                if (!CollectionUtils.isEmpty(memberRoleMap)) {
                    //商务负责人
                    if (memberRoleMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                        vo.setBusinessUserId(memberRoleMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId());
                        vo.setBusinessUserName(memberRoleMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getMemberName());

                    }
                    //服务负责人
                    if (memberRoleMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                        vo.setServiceUserId(memberRoleMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId());
                        vo.setServiceUserName(memberRoleMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getMemberName());

                    }
                    //关怀负责人
                    if (memberRoleMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                        vo.setCareUserId(memberRoleMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId());
                        vo.setCareUserName(memberRoleMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getMemberName());

                    }
                    //运维售后负责人
                    if (memberRoleMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                        vo.setOperationUserId(memberRoleMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId());
                        vo.setOperationUserName(memberRoleMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getMemberName());

                    }
                }

            }
        }

        //处理省市区
        StringBuilder str = new StringBuilder();
        if (vo.getProvinceName() != null) {
            str.append(vo.getProvinceName() + "/");
        }
        if (vo.getCityName() != null) {
            str.append(vo.getCityName() + "/");
        }
        if (vo.getDistrictName() != null) {
            str.append(vo.getDistrictName());
        }
        vo.setAddress(str.toString());
        //创建人
        if (vo.getCreateUserId() != null) {
            vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        }
    }

    //处理客户激活流程参数
    public HashMap dealActiveWorkFlowVariables(BusinessCustomerInfoVO businessCustomerInfoVO) {
        HashMap<String, Object> variables = new HashMap<>();


        //市场部负责人
        PrdOrgRoleVO marketManage = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_CUSTOMER.getCode());
        if (ObjectUtils.isEmpty(marketManage)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_CUSTOMER.getDesc() + "不存在！");
        }
        String[] splitMarketManage = marketManage.getRoleEmployees().split(",");
        variables.put("Activity_1pdc1dy", Arrays.asList(splitMarketManage));

        //应收会计(何申夏)
        PrdOrgRoleVO arAccount = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty(arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "不存在！");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        variables.put("Activity_00bffll", Arrays.asList(splitByArAccount));

        return variables;
    }

    //处理客户暂挂流程参数
    public HashMap dealPendingWorkFlowVariables(BusinessCustomerInfoVO businessCustomerInfoVO) {
        HashMap<String, Object> variables = new HashMap<>();


        //市场部负责人(刘兴华)
        PrdOrgRoleVO marketManage = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty(marketManage)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getDesc() + "不存在！");
        }
        String[] splitMarketManage = marketManage.getRoleEmployees().split(",");
        variables.put("Activity_0agynoy", Arrays.asList(splitMarketManage));

        //销售bu负责人
        PrdOrgRoleVO arAccount = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty(arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "不存在！");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        variables.put("Activity_1onqlrv", Arrays.asList(splitByArAccount));

        return variables;
    }

    //处理客户权限
    public void dataPermission(BusinessCustomerInfoQuery query) {
//        Long userId = GlobalUtil.getLoginUserId();
        Long userId = query.getQueryUserId() == null ? GlobalUtil.getLoginUserId() : query.getQueryUserId();
        //销售管理员/市场管理员/财务成员/客户管理员/潜在客户确认负责人/平台业务总负责人/平台总体负责人
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.SALE_ADMIN.getCode(), RoleEnum.MARKET_ADMIN.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.CUST_MANAGER.getCode(), RoleEnum.POTENTIAL_CUST_CONFIRM.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            query.setLoginUserId(userId);
        }
    }
}
