package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRangeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRangeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRangeSettingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyRangeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyRangeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRangeSettingRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略范围配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyRangeSettingDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyRangeSettingRepo repo;
    private final QBusinessStrategyRangeSettingDO qdo = QBusinessStrategyRangeSettingDO.businessStrategyRangeSettingDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyRangeSettingVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyRangeSettingVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 分级策略id business_strategy.id
                qdo.strategyId,
                // 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET]
                qdo.examTarget,
                // 筛选字段key
                qdo.fieldKey,
                // 筛选字段名称
                qdo.fieldName,
                // 搜索类型
                qdo.searchType,
                // 搜索范围
                qdo.searchScope,
                // 搜索条件,多个条件以英文逗号隔开
                qdo.searchCondition,
                // 设置项KEY
                qdo.settingKey,
                // 设置项名称
                qdo.settingName,
                // 设置项值
                qdo.settingValue,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyRangeSettingVO> getJpaQueryWhere(BusinessStrategyRangeSettingQuery query) {
        JPAQuery<BusinessStrategyRangeSettingVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyRangeSettingQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyRangeSettingQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 分级策略id business_strategy.id 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyId())) {
            list.add(qdo.strategyId.eq(query.getStrategyId()));
        }
        /** 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET] 精确 */
        if (!ObjectUtils.isEmpty(query.getExamTarget())) {
            list.add(qdo.examTarget.eq(query.getExamTarget()));
        }
        /** 筛选字段key 精确 */
        if (!ObjectUtils.isEmpty(query.getFieldKey())) {
            list.add(qdo.fieldKey.eq(query.getFieldKey()));
        }
        /** 筛选字段名称 精确 */
        if (!ObjectUtils.isEmpty(query.getFieldName())) {
            list.add(qdo.fieldName.eq(query.getFieldName()));
        }
        /** 搜索类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSearchType())) {
            list.add(qdo.searchType.eq(query.getSearchType()));
        }
        /** 搜索范围 精确 */
        if (!ObjectUtils.isEmpty(query.getSearchScope())) {
            list.add(qdo.searchScope.eq(query.getSearchScope()));
        }
        /** 搜索条件,多个条件以英文逗号隔开 精确 */
        if (!ObjectUtils.isEmpty(query.getSearchCondition())) {
            list.add(qdo.searchCondition.eq(query.getSearchCondition()));
        }
        /** 设置项KEY 精确 */
        if (!ObjectUtils.isEmpty(query.getSettingKey())) {
            list.add(qdo.settingKey.eq(query.getSettingKey()));
        }
        /** 设置项名称 精确 */
        if (!ObjectUtils.isEmpty(query.getSettingName())) {
            list.add(qdo.settingName.eq(query.getSettingName()));
        }
        /** 设置项值 精确 */
        if (!ObjectUtils.isEmpty(query.getSettingValue())) {
            list.add(qdo.settingValue.eq(query.getSettingValue()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyRangeSettingVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyRangeSettingVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyRangeSettingVO> queryListDynamic(BusinessStrategyRangeSettingQuery query) {
        JPAQuery<BusinessStrategyRangeSettingVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyRangeSettingVO> queryPaging(BusinessStrategyRangeSettingQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyRangeSettingVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyRangeSettingVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyRangeSettingVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyRangeSettingDO save(BusinessStrategyRangeSettingDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyRangeSettingDO> saveAll(List<BusinessStrategyRangeSettingDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyRangeSettingPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 分级策略id business_strategy.id
        if (payload.getStrategyId() != null) {
            update.set(qdo.strategyId, payload.getStrategyId());
        }
        // 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET]
        if (payload.getExamTarget() != null) {
            update.set(qdo.examTarget, payload.getExamTarget());
        }
        // 筛选字段key
        if (payload.getFieldKey() != null) {
            update.set(qdo.fieldKey, payload.getFieldKey());
        }
        // 筛选字段名称
        if (payload.getFieldName() != null) {
            update.set(qdo.fieldName, payload.getFieldName());
        }
        // 搜索类型
        if (payload.getSearchType() != null) {
            update.set(qdo.searchType, payload.getSearchType());
        }
        // 搜索范围
        if (payload.getSearchScope() != null) {
            update.set(qdo.searchScope, payload.getSearchScope());
        }
        // 搜索条件,多个条件以英文逗号隔开
        if (payload.getSearchCondition() != null) {
            update.set(qdo.searchCondition, payload.getSearchCondition());
        }
        // 设置项KEY
        if (payload.getSettingKey() != null) {
            update.set(qdo.settingKey, payload.getSettingKey());
        }
        // 设置项名称
        if (payload.getSettingName() != null) {
            update.set(qdo.settingName, payload.getSettingName());
        }
        // 设置项值
        if (payload.getSettingValue() != null) {
            update.set(qdo.settingValue, payload.getSettingValue());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 分级策略id business_strategy.id
            if (nullFields.contains("strategyId")) {
                update.setNull(qdo.strategyId);
            }
            // 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET]
            if (nullFields.contains("examTarget")) {
                update.setNull(qdo.examTarget);
            }
            // 筛选字段key
            if (nullFields.contains("fieldKey")) {
                update.setNull(qdo.fieldKey);
            }
            // 筛选字段名称
            if (nullFields.contains("fieldName")) {
                update.setNull(qdo.fieldName);
            }
            // 搜索类型
            if (nullFields.contains("searchType")) {
                update.setNull(qdo.searchType);
            }
            // 搜索范围
            if (nullFields.contains("searchScope")) {
                update.setNull(qdo.searchScope);
            }
            // 搜索条件,多个条件以英文逗号隔开
            if (nullFields.contains("searchCondition")) {
                update.setNull(qdo.searchCondition);
            }
            // 设置项KEY
            if (nullFields.contains("settingKey")) {
                update.setNull(qdo.settingKey);
            }
            // 设置项名称
            if (nullFields.contains("settingName")) {
                update.setNull(qdo.settingName);
            }
            // 设置项值
            if (nullFields.contains("settingValue")) {
                update.setNull(qdo.settingValue);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public long deleteSoftByStrategyId(Long strategyId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.strategyId.eq(strategyId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

