package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Entity
@Table(name = "bu_project_members", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "bu_project_members", comment = "BU项目成员管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BuProjectMembersDO extends BaseModel implements Serializable {
    /**
     * 项目ID
     */
    @Comment("项目ID")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 角色
     */
    @Comment("角色")
    @Column()
    private String role;
    /**
     * 复合能力ID
     */
    @Comment("复合能力ID")
    @Column()
    private Long capasetLevelId;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private Long resId;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @Comment("工作台默认显示")
    @Column()
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @Comment("客户结算价")
    @Column()
    private BigDecimal customerPrice;
    /**
     * 工种子类1
     */
    @Comment("工种子类1")
    @Column()
    private String jobType1;
    /**
     * 工种子类2
     */
    @Comment("工种子类2")
    @Column()
    private String jobType2;
    /**
     * 复合能力级别
     */
    @Comment("复合能力级别")
    @Column()
    private Long leveldId;
    /**
     * 复合能力级别
     */
    @Comment("复合能力级别")
    @Column()
    private String leveldName;
//    /**
//     * 任务包ID
//     */
//    @Comment("任务包ID")
//    @Column()
//    private Long taskPackageId;

    public void copy(BuProjectMembersDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
