package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目经理任务书配置
 *
 * @author carl
 * @date 2023-09-19
 */
@Entity
@Table(name = "pms_ma_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_ma_config", comment = "项目经理任务书配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsMaConfigDO extends BaseModel implements Serializable {
    /**
     * 排序
     */
    @Comment("排序")
    @Column(precision = 19, scale = 8)
    private BigDecimal sortIndex;
    /**
     * 项目阶段
     */
    @Comment("项目阶段")
    @Column()
    private String projectStage;
    /**
     * 关键任务
     */
    @Comment("关键任务")
    @Column()
    private String keyTask;

    public void copy(PmsMaConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
