package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractVO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PcontractPayplanDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 旧采购合同
 *
 * @author likunpeng
 * @date 2024-01-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseContractServiceImpl extends BaseServiceImpl implements PurchaseContractService {

    private final PurchaseContractDAO purchaseContractDAO;
    private final PcontractPayplanDAO pcontractPayplanDAO;

    @Override
    public PagingVO<PurchaseContractVO> queryPaging(PurchaseContractQuery query){
        return purchaseContractDAO.queryPaging(query);
    }

    @Override
    public List<PurchaseContractVO> queryListDynamic(PurchaseContractQuery query){
        return purchaseContractDAO.queryListDynamic(query);
    }

    @Override
    public PurchaseContractVO queryByKey(Long key) {
        PurchaseContractVO purchaseContractVO = purchaseContractDAO.queryByKey(key);
        if (purchaseContractVO != null) {
            // 查询旧采购合同下的付款计划
            purchaseContractVO.setPcontractPayplanVOS(pcontractPayplanDAO.findByContractId(purchaseContractVO.getId()));
        }
        return purchaseContractVO;
    }

}
