package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.ResSetRatePayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.ResSetRateQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.ResSetRateService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.convert.ResSetRateConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.ResSetRateDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.ResSetRateDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.ResSetRateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * 人力资源结算费率
 *
 * @author lemon
 * @date 2023-11-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ResSetRateServiceImpl extends BaseServiceImpl implements ResSetRateService {

    private final ResSetRateRepo resSetRateRepo;
    private final ResSetRateDAO resSetRateDAO;

    @Override
    public PagingVO<ResSetRateVO> queryPaging(ResSetRateQuery query) {
        return resSetRateDAO.queryPaging(query);
    }

    @Override
    public List<ResSetRateVO> queryListDynamic(ResSetRateQuery query) {
        return resSetRateDAO.queryListDynamic(query);
    }

    @Override
    public ResSetRateVO queryByKey(Long key) {
        ResSetRateDO entity = resSetRateRepo.findById(key).orElseGet(ResSetRateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ResSetRateVO vo = ResSetRateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResSetRateVO insert(ResSetRatePayload payload) {
//        //人力资源结算费率的开始金额、结束金额不允许交叉检查
//        boolean checkResStartAtmAndEndAtm = checkResSetRate(Collections.singletonList(payload));
//        if (checkResStartAtmAndEndAtm) {
//            throw TwException.error("", "人力资源结算费率的金额期间不允许有交叉");
//        }
        // 校验人力资源结算费率
        this.checkResSetRateNew(payload);
        ResSetRateDO entityDo = ResSetRateConvert.INSTANCE.toDo(payload);
        return ResSetRateConvert.INSTANCE.toVo(resSetRateRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResSetRateVO update(ResSetRatePayload payload) {
        ResSetRateDO entity = resSetRateRepo.findById(payload.getId()).orElseGet(ResSetRateDO::new);
        Assert.notNull(entity.getId(), "不存在");
//        //人力资源结算费率的开始金额、结束金额不允许交叉检查
//        boolean checkResStartAtmAndEndAtm = checkResSetRate(Collections.singletonList(payload));
//        if (checkResStartAtmAndEndAtm) {
//            throw TwException.error("", "人力资源结算费率的金额期间不允许有交叉");
//        }
        // 校验人力资源结算费率
        this.checkResSetRateNew(payload);
        ResSetRateDO entityDo = ResSetRateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ResSetRateConvert.INSTANCE.toVo(resSetRateRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ResSetRatePayload payload) {
        ResSetRateDO entity = resSetRateRepo.findById(payload.getId()).orElseGet(ResSetRateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = resSetRateDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            resSetRateDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        resSetRateDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    @Override
    public List<ResSetRateVO> findByAgreementId(Long agreementId) {
        return resSetRateDAO.findByAgreementId(agreementId);
    }

    // 这个方法存在问题，后续有时间改
    private boolean checkResSetRate(List<ResSetRatePayload> payloadList) {
        boolean checkResStartAndEnd = false;
        boolean flag = true;
        for (int i = 0; i < payloadList.size() && flag; i++) {
            for (int j = i + 1; j < payloadList.size(); j++) {
                BigDecimal iStartAtm = payloadList.get(i).getStartAtm() == null ? BigDecimal.ZERO : payloadList.get(i).getStartAtm();
                BigDecimal jEndAtm = payloadList.get(j).getEndAtm() == null ? BigDecimal.ZERO : payloadList.get(j).getEndAtm();
                BigDecimal jStartAtm = payloadList.get(j).getStartAtm() == null ? BigDecimal.ZERO : payloadList.get(j).getStartAtm();
                BigDecimal iEndAtm = payloadList.get(i).getEndAtm() == null ? BigDecimal.ZERO : payloadList.get(i).getEndAtm();
                if ((iStartAtm.compareTo(jEndAtm) == -1) && (jStartAtm.compareTo(iEndAtm) == -1)) {
                    checkResStartAndEnd = true;
                    flag = false;
                    break;
                }
            }
        }
        return checkResStartAndEnd;
    }

    /**
     * 校验人力资源费率的开始、结束金额
     * @param resSetRatePayload 需要新增Or修改的人力资源费率
     */
    private void checkResSetRateNew(ResSetRatePayload resSetRatePayload) {
        BigDecimal startAtm = resSetRatePayload.getStartAtm();
        BigDecimal endAtm = resSetRatePayload.getEndAtm();
        if (startAtm.compareTo(endAtm) >= 0) {
            throw TwException.error("", "开始金额需小于结束金额");
        }
        // 查询该采购协议下所有的人力资源结算费率
        List<ResSetRateVO> resSetRateVOS = findByAgreementId(resSetRatePayload.getDocumentId());
        if (!CollectionUtils.isEmpty(resSetRateVOS)) {
            // 数值区间
            List<BigDecimal[]> amtInterval = new ArrayList<>();
            // 先将新增Or修改后的值加进去
            amtInterval.add(new BigDecimal[]{startAtm, endAtm});
            resSetRateVOS.forEach(resSetRateVO -> {
                // 修改时排除掉原始值
                if (!resSetRateVO.getId().equals(resSetRatePayload.getId())) {
                    amtInterval.add(new BigDecimal[]{resSetRateVO.getStartAtm(), resSetRateVO.getEndAtm()});
                }
            });
            // 校验是否有交叉（现在费率的配置为[],而不是[)，如后期需更改需要将下面=放开并同步维护费率获取接口)
            if (!CollectionUtils.isEmpty(amtInterval)) {
                amtInterval.sort(Comparator.comparing(a -> a[0])); // 对列表排序
                for (int i = 0; i < amtInterval.size() - 1; i++) {
                    BigDecimal[] interval1 = amtInterval.get(i);
                    BigDecimal[] interval2 = amtInterval.get(i + 1);
                    if (interval1[0].compareTo(interval2[1]) <= 0 && interval2[0].compareTo(interval1[1]) <= 0) {
                        throw TwException.error("", "人力资源结算费率的金额期间不允许有交叉");
                    }
                }
            }
        }
    }

}
