package com.elitesland.tw.tw5.server.prd.salecon.repo;


import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 合同收款明细
 *
 * @author lemon
 * @date 2023-09-05
 */
public interface ConReceivableDRepo extends JpaRepository<ConReceivableDDO, Long>, JpaSpecificationExecutor<ConReceivableDDO> {

    @Query(value = " select * from con_receivable_d e where e.modify_time >= ?1  ", nativeQuery = true)
    List<ConReceivableDDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ConReceivableDDO set conReceivableDIdV4=?1,modifyTime=current_time  where id=?2")
    @Modifying
    void updateConReceivableDIdV4(Long idV4, Long id);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_receivable_d set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);
}
