package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.*;
import com.baiwang.open.entity.request.node.*;
import com.baiwang.open.entity.response.*;
import com.baiwang.open.entity.response.node.OutputEinvoiceQuery;
import com.baiwang.open.entity.response.node.OutputInvoiceIssueInvoiceResult;
import com.baiwang.open.exception.BWOpenException;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchExcelExport;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TwInvoiceTypeEnum;
import com.elitesland.tw.tw5.server.prd.inv.config.TwInvoiceProperties;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvBatchConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchInvdtlDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.*;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.FileUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.common.functionEnum.TwInvoiceTypeEnum.SHAPE;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConInvBatchServiceImpl extends BaseServiceImpl implements ConInvBatchService {

    private final ConInvBatchRepo conInvBatchRepo;
    private final ConInvBatchDAO conInvBatchDAO;
    private final ConReceivablePlanDAO receivablePlanDAO;
    private final ConReceivablePlanRepo receivablePlanRepo;
    private final ConInvBatchInvdtlDAO conInvBatchInvdtlDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final ConReceivablePlanService receivablePlanService;
    private final InvItemDAO invItemDAO;
    // private final PrdAbInvoiceDAO abInvoiceDAO;
    private final BookInvoiceDAO bookInvoiceDAO;
    private final ConInvBatchInvdtlService conInvBatchInvdtlService;
    private final ConInvBatchInvdtlRepo conInvBatchInvdtlRepo;
    private final SaleConContractRepo saleConContractRepo;
    // private final PrdOrgCompanyRepo prdOrgCompanyRepo;
    private final TransactionTemplate transactionTemplate;
    private final UdcUtil udcUtil;
    private final ExcelUtil excelUtil;
    private final FileService fileService;
    private final ConReceivableRepo conReceivableRepo;
    private final PrdOrgSyncLogDAO daoLog;
    private final TwInvoiceProperties invoiceProperties;
    @Autowired
    private TwInvoiceSendMsgService invoiceSendMsgService;
    private final PrdOrgEmployeeRepo employeeRepo;
    private final HttpUtil httpUtil;
    private final BusinessPartnerService businessPartnerService;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigService messageConfigService;
    private final ConInvSettingDAO conInvSettingDAO;

//    @Value("${baiwang.maxInvAmt}")
//    private BigDecimal MAX_INV_AMT;

    private final FileUtilService fileUtilService;

    private final YeedocProperties yeedocProperties;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.contractInvBatch}")
    private String contractInvBatch;

    @Value("${tw4.sale.contractInvBatchInvDtl}")
    private String contractInvBatchInvDtl;

    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PrdSystemRoleDAO systemRoleDAO;

    @Override
    public PagingVO<ConInvBatchVO> queryPaging(ConInvBatchQuery query) {

        // 处理权限
        getPermissionParams(query);

        PagingVO<ConInvBatchVO> conInvBatchVOPagingVO = conInvBatchDAO.queryPaging(query);
        List<ConInvBatchVO> records = conInvBatchVOPagingVO.getRecords();
        //计算总账日期
        for (ConInvBatchVO record : records) {
            ConReceivableDO conReceivableDO = conReceivableRepo.queryDistinctFirstByRecvClassAndSourceIdAndDeleteFlagOrderByCreateTimeDesc("1", record.getId(), 0);
            if (!ObjectUtils.isEmpty(conReceivableDO) && conReceivableDO.getLedgerDate() != null) {
                record.setLedgerDate(conReceivableDO.getLedgerDate());
            }
        }
        return conInvBatchVOPagingVO;
    }


    private void getPermissionParams(ConInvBatchQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 平台级别权限（管理员，销售副总裁，平台总体负责人，合同管理员，平台资源负责人，平台财务出纳，平台财务数据权限）
        List<String> financeRoles = Arrays.asList("FINANCE_MEMBER", "PLAT_FIN_CASHIER", "PLAT_FIN_MANAGER", "PLAT_CFO");
        List<String> oldRoles = Arrays.asList(RoleEnum.OPS.getCode(), RoleEnum.SYS.getCode(), RoleEnum.SALES_VP.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALES_CONTRACT_ADMIN.getCode(), RoleEnum.PLAT_RESOURCE_PIC.getCode(), RoleEnum.PLAT_FIN_CASHIER.getCode(), RoleEnum.PLAT_FIN_DATA_POWER.getCode());
        List<String> roles = new ArrayList<>(oldRoles);
        roles.addAll(financeRoles);
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(roles);
        if (CollectionUtils.isEmpty(userIdsByRole) || !userIdsByRole.contains(loginUserId)) {
            // BU级权限（查看当前登录人是否是部门负责人）
            final List<PrdOrgOrganizationDO> organizationDOList = orgOrganizationDAO.queryByManagerId(loginUserId);
            Set<Long> orgIdList = null;
            if (!CollectionUtils.isEmpty(organizationDOList)) {
                orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                //查询所有子部门
                Set<Long> childOrgs = orgOrganizationDAO.queryAllChildOrgs(orgIdList);
                orgIdList.addAll(childOrgs);
                query.setAuthOuIds(orgIdList);
            } else {
                // 当bu级权限没有的话，再走基础权限
                query.setCreateUserId(loginUserId);
            }
        }
    }

    @Override
    public List<ConInvBatchVO> queryListDynamic(ConInvBatchQuery query) {
        return conInvBatchDAO.queryListDynamic(query);
    }

    @Override
    public ConInvBatchVO queryByKey(Long key) {
        ConInvBatchVO conInvBatchVO = conInvBatchDAO.queryByKey(key);
        if (ObjectUtils.isEmpty(conInvBatchVO)) {
            throw TwException.error("", "单据已删除或不存在！");
        }
        //翻译内部抄送人
        if (StringUtils.hasText(conInvBatchVO.getRecipientInner())) {
            String recipientInnerDesc = Arrays.stream(conInvBatchVO.getRecipientInner().split(","))
                    .filter(str -> !str.isEmpty())
                    .map(Long::parseLong) // 将字符串转换成Long
                    .map(userId -> cacheUtil.getUserName(userId)) // 将Long翻译成String
                    .collect(Collectors.joining(",")); // 连接成字符串
            conInvBatchVO.setRecipientInnerDesc(recipientInnerDesc);
        }
        //查询关联收款计划列表
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setInvBatchId(key);
        List<ConReceivablePlanVO> conReceivablePlanVOS = receivablePlanDAO.queryListDynamic(query);
        conInvBatchVO.setReceivablePlanVOS(conReceivablePlanVOS);
        //查询关联的发票列表
        ConInvBatchInvdtlQuery invBatchInvdtlQuery = new ConInvBatchInvdtlQuery();
        invBatchInvdtlQuery.setInvbatchId(key);
        List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = conInvBatchInvdtlDAO.queryListDynamic(invBatchInvdtlQuery);
        conInvBatchVO.setConInvBatchInvdtlVOS(conInvBatchInvdtlVOS);
        //商品信息
        Long invItemId = conInvBatchVO.getInvItemId();
        if (invItemId != null) {
            conInvBatchVO.setInvItemVO(invItemDAO.queryByKey(invItemId));
        }
        //开票信息
//        if (conInvBatchVO.getInvoiceId() != null){
//            PrdAbInvoiceVO prdAbInvoiceVO = abInvoiceDAO.queryByKey(conInvBatchVO.getInvoiceId());
//            udcUtil.translate(prdAbInvoiceVO);
//            conInvBatchVO.setPrdAbInvoiceVO(prdAbInvoiceVO);
//        }
        // 对方开票信息
        if (conInvBatchVO.getInvoiceId() != null) {
            BookInvoiceVO bookInvoiceVO = bookInvoiceDAO.queryByKey(conInvBatchVO.getInvoiceId());
            if (bookInvoiceVO != null) {
                udcUtil.translate(bookInvoiceVO);
            }
            conInvBatchVO.setPrdAbInvoiceVO(bookInvoiceVO);
        }
        // 我方开票信息
        if (conInvBatchVO.getInvOuId() != null) {
            BookInvoiceVO bookInvoiceVO = bookInvoiceDAO.queryDefaultByBookId(conInvBatchVO.getInvOuId());
            if (bookInvoiceVO != null) {
                conInvBatchVO.setOuInvoiceVO(bookInvoiceVO);
            }
        }
        return conInvBatchVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvBatchVO insert(ConInvBatchPayload payload) {
        // 校验税率异常
        if (payload.getTaxRate().compareTo(BigDecimal.valueOf(1)) == 1) {
            throw TwException.error("", "开票税率异常，大于了100%");
        }
        ConInvBatchDO entityDo = ConInvBatchConvert.INSTANCE.toDo(payload);
        // 发号器
        entityDo.setBatchNo(generateSeqNum("CON_INV_BATCH"));
        // 新增开票
        ConInvBatchDO save = conInvBatchRepo.save(entityDo);
        // 将开票批次id写回收款计划表
        receivablePlanDAO.setInvBatchId(save.getId(), payload.getConReceivablePlanIds());
        ConInvBatchVO conInvBatchVO = ConInvBatchConvert.INSTANCE.toVo(save);
        fileSaveOrUpdate(entityDo, payload);
        return conInvBatchVO;
    }


    /**
     * 附件保存
     *
     * @param entityDo
     */
    private void fileSaveOrUpdate(ConInvBatchDO entityDo, ConInvBatchPayload payload) {
        // ----处理附件开始
        if (!StringUtils.hasText(entityDo.getFolderId())) {
            // 1.创建文件夹
            List<String> pathArry = new ArrayList<String>();
            // 查询客户名称
            ConReceivablePlanVO conReceivablePlanVO = receivablePlanDAO.queryByInvBatchId(entityDo.getId());
            String saleConName = conReceivablePlanVO.getSaleConName();
            String projName = conReceivablePlanVO.getProjName();
            String projNo = conReceivablePlanVO.getProjNo();
            //项目编号+项目名称+"("+合同名称“)"
            pathArry.add("/" + projNo + "-" + projName + "(" + saleConName + ")");
            String ydkFolderId = fileUtilService.createYdkFolder(yeedocProperties.getInvBatchLibraryId(), yeedocProperties.getInvBatchFolderId(), pathArry, payload.getAuthTokenByYdk());
            entityDo.setFolderId(ydkFolderId);
            payload.setFolderId(ydkFolderId);
        } else {
            // 修改文件名称
        }
        // 2.把附件最终保存
        List<String> cacheKeys = new ArrayList<>();
        if (StringUtils.hasText(payload.getCacheKey())) {
            cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
            Map<String, String> cacheMap = fileUtilService.saveYdkFile(yeedocProperties.getInvBatchLibraryId(), entityDo.getFolderId(), new HashSet<String>(cacheKeys), payload.getAuthTokenByYdk());
            String str = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            if (StringUtils.hasText(payload.getFileCode())) {
                String newFileCodes = payload.getFileCode().concat(",").concat(str);
                payload.setFileCode(newFileCodes);
                entityDo.setFileCode(newFileCodes);
            } else {
                entityDo.setFileCode(str);
                payload.setFileCode(str);
            }
        }

        // ----处理附件结束

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvFlag(ConInvBatchPayload payload) {
        conInvBatchRepo.updateInvFlag(payload.getId(), payload.getInvFlag());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvBatchVO update(ConInvBatchPayload payload) {
        ConInvBatchDO entity = conInvBatchRepo.findById(payload.getId()).orElseGet(ConInvBatchDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvBatchDO entityDo = ConInvBatchConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (StringUtils.hasText(payload.getCacheKey())) {
            // 处理附件
            fileSaveOrUpdate(entity, payload);
        }
        //处理开票的发票信息
        List<ConInvBatchInvdtlPayload> conInvBatchInvdtlPayloads = payload.getConInvBatchInvdtlPayloads();
        // 退票
        if (payload.getBatchStatus() != null && payload.getBatchStatus().equals(BatchStatusEnum.APPROVINGINVBACK.getCode())) {
            // 退票解绑  在工作流回调
            // todo: 校验退票流程提交后开票批次表的开票金额为0，开票明细表的金额之和为0；
            long invAmtNullNum = conInvBatchInvdtlPayloads.stream().filter(e -> e.getInvAmt() == null).count();
            long netAmtNullNum = conInvBatchInvdtlPayloads.stream().filter(e -> e.getNetAmt() == null).count();
            if (invAmtNullNum > 0 || netAmtNullNum > 0) {
                throw TwException.error("", "发票金额异常，请检查！");
            }
            List<BigDecimal> invAmtCollect = conInvBatchInvdtlPayloads.stream().map(e -> e.getInvAmt()).collect(Collectors.toList());
            List<BigDecimal> netAmtCollect = conInvBatchInvdtlPayloads.stream().map(e -> e.getNetAmt()).collect(Collectors.toList());
            BigDecimal invAmtSum = invAmtCollect.stream()
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal netAmtSum = netAmtCollect.stream()
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(invAmtSum) != 0) {
                throw TwException.error("", "退票时开票金额之和必须要等于0！");
            }
            if (BigDecimal.ZERO.compareTo(netAmtSum) != 0) {
                throw TwException.error("", "退票时净额之和必须要等于0！");
            }
            entity.setInvAmt(BigDecimal.ZERO);
        } else {
            // 申请开票流程的过程
            if (payload.getBatchDate() != null) {
                if (!CollectionUtils.isEmpty(payload.getConReceivablePlanIds())) {
                    // 更新收款计划表已开票金额
                    receivablePlanDAO.updateInvAmt(payload.getConReceivablePlanIds(), payload.getBatchDate());
                } else {
                    log.warn("更新收款计划表已开票金额失败，conReceivablePlanIds值为空");
                }
                //根据预计到账日期回写收款计划预计收款日期
                receivablePlanRepo.updateExpectRecvDate(payload.getId());
            }
        }
        ConInvBatchVO conInvBatchVO = ConInvBatchConvert.INSTANCE.toVo(conInvBatchRepo.save(entity));
        if (!CollectionUtils.isEmpty(conInvBatchInvdtlPayloads)) {
            //保存更新开票信息
            for (ConInvBatchInvdtlPayload conInvBatchInvdtlPayload : conInvBatchInvdtlPayloads) {
                conInvBatchInvdtlPayload.setInvbatchId(conInvBatchVO.getId());
                if (conInvBatchInvdtlPayload.getDeleteFlag() == 1) {
                    if (conInvBatchInvdtlPayload.getId() != null) {
                        conInvBatchInvdtlService.deleteSoft(Arrays.asList(conInvBatchInvdtlPayload.getId()));
                    }
                } else if (conInvBatchInvdtlPayload.getId() == null || conInvBatchInvdtlPayload.getId() < 0) {
                    conInvBatchInvdtlService.insert(conInvBatchInvdtlPayload);
                } else {
                    conInvBatchInvdtlService.update(conInvBatchInvdtlPayload);
                }
            }
        }
//        if (payload.getSubmit() != null && payload.getSubmit()) {
//            //通过收款计划查询合同名称
//            Long planId = payload.getConReceivablePlanIds().get(0);
//            String contractName = conInvBatchRepo.queryContractName(planId);
//            conInvBatchVO.setContractName(contractName);
//            //走开票审批流程
//            submitProc(conInvBatchVO);
//        }
        return conInvBatchVO;
    }


    /**
     * 发起流程
     *
     * @param key 单据数据
     */
    @Override
    public void submitProc(Long key) {
        ConInvBatchVO conInvBatchVO = conInvBatchDAO.queryByKey(key);
        ProcessInfo processInfo = new ProcessInfo();
        String status = "";
        if (workflow_enabled) {
            status = BatchStatusEnum.APPLYING.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            Long createUserId = conInvBatchVO.getCreateUserId();
            if (createUserId != null) {
                //设置发起人作为审批人
                variables.put("Activity_16uktyp", CollUtil.newArrayList(createUserId));
            }
            try {
                //发起流程审批
                processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                        ProcDefKey.SALE_CON_INVOICING.name(),
                        conInvBatchVO.getSubContractName() + "-合同开票审批流程",
                        conInvBatchVO.getId() + "",
                        variables)
                );
            } catch (TwException e) {
                // 删除当前的开票信息
                deleteSoft(Arrays.asList(key));
                // 解除收款计划的绑定
                ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
                planQuery.setInvBatchIds(Arrays.asList(key));
                List<ConReceivablePlanVO> planList = receivablePlanDAO.queryListDynamic(planQuery);
                if (!CollectionUtils.isEmpty(planList)) {
                    List<Long> planIds = planList.stream().map(e1 -> e1.getId()).collect(Collectors.toList());
                    ConReceivablePlanPayload receivablePlan = new ConReceivablePlanPayload();
                    receivablePlan.setIds(planIds);
                    receivablePlan.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
                    // 将收款字段置空
                    receivablePlan.setNullFields(Arrays.asList("invBatchId"));
                    receivablePlanDAO.updateByKeyDynamic(receivablePlan);
                }
                throw new BusinessException("流程发起失败！" + e.getErrors().get(0).getMsg());
            }
        }

        //流程启动成功后，回写业务表数据
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setProcInstId(processInfo.getProcInstId());
        conInvBatchPayload.setId(conInvBatchVO.getId());
        conInvBatchPayload.setProcInstStatus(processInfo.getProcInstStatus());
        conInvBatchPayload.setSubmitTime(LocalDateTime.now());
        conInvBatchPayload.setBatchStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            conInvBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        });
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConInvBatchPayload payload) {
        ConInvBatchDO entity = conInvBatchRepo.findById(payload.getId()).orElseGet(ConInvBatchDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 处理附件
        fileSaveOrUpdate(entity, payload);
        long result = conInvBatchDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conInvBatchDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<ConReceivablePlanVO> queryRecvplanList(Long key) {
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setInvBatchId(key);
        return receivablePlanService.queryListDynamic(query);
    }

    @Override
    public void returnTicket(Long invBatchId, String disDisc) {
        ConInvBatchVO conInvBatchVO = conInvBatchDAO.queryByKey(invBatchId);
        Assert.notNull(conInvBatchVO.getId(), "不存在");
        conInvBatchVO.setDisDisc(disDisc);
        conRefundProc(conInvBatchVO);
    }

    @Override
    public List<ConInvBatchVO> getHistoryInv(Long custId, Long contractId) {
        List<ConInvBatchVO> historyInvList = conInvBatchDAO.getHistoryInv(custId);
        for (ConInvBatchVO conInvBatchVO : historyInvList) {
            LocalDate actualInvDate = conInvBatchVO.getActualInvDate();
            if (actualInvDate != null) {
                conInvBatchVO.setBatchDate(actualInvDate);
            }
        }
        historyInvList = historyInvList.stream().filter(e -> e.getBatchDate() != null).collect(Collectors.toList());
        // 子合同一致的放最上面，并按照实际开票日期排序，没有实际开票日期按照预计开票日期排序
        List<ConInvBatchVO> sortedList = new ArrayList<>();
        //分组
        List<ConInvBatchVO> commonContractList = new ArrayList<>();
        List<ConInvBatchVO> otherContractList = new ArrayList<>();

        for (ConInvBatchVO item : historyInvList) {
            if (item.getSubContractId().equals(contractId)) {
                commonContractList.add(item);
            } else {
                otherContractList.add(item);
            }
        }
        // 对第一组排序
        sortList(commonContractList);
        sortedList.addAll(commonContractList);

        // otherContractList 按照contractId分组
        Map<Long, List<ConInvBatchVO>> groupedContracts = otherContractList.stream()
                .collect(Collectors.groupingBy(ConInvBatchVO::getSubContractId));

        // 每组的第一条
        List<ConInvBatchVO> firstList = new ArrayList<>();


        for (Long key : groupedContracts.keySet()) {
            List<ConInvBatchVO> conInvBatchVOS = groupedContracts.get(key);
            sortList(conInvBatchVOS);

            // 当前组的最新一条数据
            ConInvBatchVO conInvBatchVO = conInvBatchVOS.get(0);
            firstList.add(conInvBatchVO);
        }

        // 对每组的第一条排序
        sortList(firstList);
        // 按照排序后的合同id,依次将排序后的其它分组后的数据放入
        for (ConInvBatchVO conInvBatchVO : firstList) {
            Long currentContractId = conInvBatchVO.getSubContractId();
            sortedList.addAll(groupedContracts.get(currentContractId));
        }
        return sortedList;

//        List<ConInvBatchVO> result = historyInvList.stream()
//                .collect(Collectors.toMap(
//                        historyInv -> historyInv.getContractId() + "-" + historyInv.getContactPerson() + "-" + historyInv.getTaxRate(),
//                        historyInv -> historyInv,
//                        (existing, replacement) -> existing
//                ))
//                .values()
//                .stream()
//                .sorted(Comparator.comparing(ConInvBatchVO::getSubContractId, (id1, id2) -> {
//                    if (id1.equals(contractId)) {
//                        return -1;
//                    } else if (id2.equals(contractId)) {
//                        return 1;
//                    } else {
//                        return 0;
//                    }
//                }).thenComparing((historyInv1, historyInv2) -> {
//                    if (historyInv1.getActualInvDate() != null && historyInv2.getActualInvDate() != null) {
//                        return historyInv2.getActualInvDate().compareTo(historyInv1.getActualInvDate());
//                    } else if (historyInv1.getActualInvDate() != null) {
//                        return -1;
//                    } else if (historyInv2.getActualInvDate() != null) {
//                        return 1;
//                    } else {
//                        if (historyInv1.getBatchDate() != null && historyInv2.getBatchDate() != null) {
//                            return historyInv2.getBatchDate().compareTo(historyInv1.getBatchDate());
//                        } else if (historyInv1.getBatchDate() != null) {
//                            return -1;
//                        } else {
//                            return 1;
//                        }
//                    }
//                }))
//                .collect(Collectors.toList());
//        return result;
    }


    private void sortList(List<ConInvBatchVO> conInvBatchVOS) {
// 使用Comparator进行排序
        Collections.sort(conInvBatchVOS, new Comparator<ConInvBatchVO>() {
            @Override
            public int compare(ConInvBatchVO batch1, ConInvBatchVO batch2) {
                if (batch1.getBatchDate() == null && batch2.getBatchDate() == null) {
                    return 0; // 如果两个对象的 batchDate 都为 null，则认为它们相等
                } else if (batch1.getBatchDate() == null) {
                    return 1; // 如果 batch1 的 batchDate 为 null，而 batch2 的不为 null，则认为 batch1 大于 batch2
                } else if (batch2.getBatchDate() == null) {
                    return -1; // 如果 batch2 的 batchDate 为 null，而 batch1 的不为 null，则认为 batch1 小于 batch2
                } else {
                    return batch2.getBatchDate().compareTo(batch1.getBatchDate()); // 两个对象的 batchDate 都不为 null，则按照倒序排序
                }
            }
        });
    }


    @Override
    @Transactional
    public int completeInvBatch(ConInvBatchPayload payload) {
        // 更新开票信息
        update(payload);
        // 更新收款计划表已开票金额
        receivablePlanDAO.updateInvAmt(payload.getConReceivablePlanIds(), payload.getBatchDate());
        // 更新已开票状态
        conInvBatchDAO.updateBatchStatusById(payload.getId(), "4");
        // todo 更新客户请款表状态 申请为已开票状态   Sole  2019-07-12
//        List<Long> ids = contractRecvplanMapper.relApplyNo(invBatchEntity.getId());
//        for (Long id : ids) {
//            reimMapper.updateExpapplyStatusStatus(id, "4");
//        }
        //根据预计到账日期回写收款计划预计收款日期
        receivablePlanRepo.updateExpectRecvDate(payload.getId());
        return 1;
    }

    /**
     * @param conInvBatchVO
     */
    private void conRefundProc(ConInvBatchVO conInvBatchVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = "9";
        if (workflow_enabled) {
            HashMap<String, Object> variables = new HashMap<>();
            // 查询财务稽核专员（因公）组织角色
            List<PrdOrgRoleVO> prdOrgRoleVOS = orgOrganizationDAO.queryRoleList(579786628726263285L);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_FIN_CHECK_PIC".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("财务稽核专员（因公）角色不存在！");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_1t2n7l4", Arrays.asList(split));

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.CON_REFUND.name(),
                    conInvBatchVO.getSubContractName() + "-合同开票退票流程",
                    conInvBatchVO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据

        ConInvBatchPayload payload = new ConInvBatchPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conInvBatchVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setBatchStatus(status);
        payload.setDisDisc(conInvBatchVO.getDisDisc());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            conInvBatchDAO.updateByKeyDynamic(payload);
        });
    }

    /**
     * 百望直连开票
     *
     * @param invId
     */
    @Override
    public void outputInvoiceInBaiwang(Long invId, Integer invOrRefund) {
        ConInvBatchVO conInvBatchVO = queryByKey(invId);
        Long conOuId = conInvBatchVO.getInvOuId();
        // 判断开票主体是否存在
        if (conOuId == null) {
            throw new BusinessException("无法查询到开票主体");
        }
        //业务伙伴
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(conOuId);

        String taxRegNo = "";
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {

            taxRegNo = businessPartnerVOS.get(0).getIdenNo();
        }
        //增值税专用发票\增值税普通发票\电子发票(增值税专用发票)\电子发票(普通发票)要发送申请
        if (SHAPE.equals(TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
            // 只有形式发票不向百望发申请
            return;
        }
//        if (conInvBatchVO.getInvAmt() != null && conInvBatchVO.getInvAmt().compareTo(BigDecimal.ZERO) < 0) {
//            // 如果票面金额是负数，则不向百望发送数据
//            return ;
//        }
//        if (CollectionUtils.isEmpty(businessPartnerVOS) || !StringUtils.hasText(businessPartnerVOS.get(0).getPartnerName()) || !businessPartnerVOS.get(0).getPartnerName().contains("埃林哲")) {
//            return;
//        }
        // 发票商品信息
        InvItemVO invoiceItem = conInvBatchVO.getInvItemVO();
        if (invoiceItem == null) {
            throw new BusinessException("发票【" + invId + "】商品信息获取失败" + conInvBatchVO.getInvItemId());
        }
        BookInvoiceVO bookInvoiceVO = conInvBatchVO.getPrdAbInvoiceVO();
        // 单独查询地址簿开票信息表获取税号等信息
        if (bookInvoiceVO == null) {
            throw new BusinessException("发票【" + invId + "】开票信息获取失败");
        }

        // 处理开票信息
        OutputInvoiceIssuePreInvoice data = new OutputInvoiceIssuePreInvoice();
        // 整单折扣率（数电发票暂不支持）,取值[1-100]正整数[不用]
        // data.setDiscountRate(0);
        // 红字信息表UUID，开具全电负数发票必传[不用]
        // data.setRedConfirmUuid("");
        // 购方开户行及账号， 增值税专用发票开具时必填，发票类 型代码为01、02时该字段拆分为银行名称、账号两个字段[不用]
        // data.setBuyerBankAccount("中国工商银行海淀分行 62266693991223881");
        // 客户邮箱（不通过百望发邮件，所以不传）
        // data.setBuyerEmail(conInvBatchVO.getInvEmail());
        // 抄送人邮箱,多个用英文逗号隔开,最多5个抄送人信息 全电字符长度为200（不通过百望发邮件，所以不传）
        // data.setEmailCarbonCopy("");
        // 整单折扣金额（数电发票暂不支持）,大于0小于发票总金额，如果是含税发票，大于0小于含税总金[不用]
        // data.setDiscountAmount(BigDecimal.valueOf(0.0));
        // 销方地址，发票类型代码为01、02时该字段可
        // data.setSellerAddress("");
        // 复核人， 16个字符；税控开具时： 为空时，如果终端有值取终端，如果没有去机构获取，若都没有则为空！全电类开具时：此字段非必填，即发票类型代码为01，02时该字段非必填
        // data.setChecker("");
        // 征税方式， 0：普通征税；2：差额征税（默认是0普通征税）
        // data.setTaxationMethod("0");
        // 红字信息表/确认单编号，仅invoiceType=1时需要传入数据税控类红票开具时，invoiceTypeCode=004、028时必须传值，传入红字信息表编号；全电类红票开具时，invoiceTypeCode=01、02时必须传值，传入红字确认单编号；
        // data.setRedInfoNo("");
        // 收款人， 16个字符；税控类开具时：若为空，如果终端有值取终端，如果没有去机构获取，若都没有则为空；全电类开具时：此字段非必填，即发票类型代码为01，02时该字段非必填
        // data.setPayee("");
        //data.setBuyerAddress(bookInvoiceVO.getInvoiceAddress());
        // 第三方系统名称
        // data.setSystemName("");
        // 开票类型 0:正数发票（蓝票） 1：负数发票（红票）默认0
        // data.setInvoiceType("0");
        // 红冲原因[不用]
        //data.setRedIssueReason("");
        // 扩展字段
        // Map<String, Object> ext = new HashMap<String, Object>();
        // data.setExt(ext);
        // 合同号
        // data.setContractNumber("");
        // 原发票号码， invoiceType=1，税控负数普票开具时必传；红票选数电票时，此项可为空。
        // data.setOriginalInvoiceNo("");
        // 0：无清单；1：带清单 电票不考虑[不用]
        // data.setInvoiceListMark("0");
        // 凭证号
        // data.setVoucherNo("");
        // 客户电话
        // data.setBuyerPhone("");
        // 购买方电话，发票类型代码为01、02时该字段可用
        // data.setBuyerTelphone("");
        // 用户账号，用于个人维度数据标记
        // data.setUserAccount("");
        // 销方银行名称，发票类型代码为01、02时该字段可用
        // data.setSellerBankName("");
        // 原发票代码， invoiceType=1，税控负数普票开具时必传；红票选数电票时，此项可为空
        // data.setOriginalInvoiceCode("");
        // 销方电话，发票类型代码为01、02时该字段可用
        // data.setSellerTelphone("");
        // 数电纸质发票标志，Y：是，N：否。税控类发票开具不校字段；暂只支持用数电电票红冲数电纸
        //data.setPaperInvoiceFlag("N");
        // 卷式发票票样 01 02 03 04 05 06 07
        // data.setMainGoodsName("");
        // 数电不用
        // data.setSellerAddressPhone("");
        // 购买方银行名称，发票类型代码为01、02时该字段可用
        // data.setBuyerBankName("");
        // 数电不用
        // data.setDiscountType("");
        // 购方地址及电话， 增值税专用发票开具时必填，发票类型代码为01、02时该字段拆分为地址电话两个字段
        // data.setBuyerAddressPhone(bookInvoiceVO.getInvoicePhone());
        // 第三方系统id
        // data.setSystemId("");
        // 扣除额， taxationLabel=2，差额征税时必传。数值必须小于价税合计
        // data.setDeductibleAmount(BigDecimal.valueOf(0.0));
        //开票人，税票取值逻辑：如果终端有值取终端，如果没有去机构获取，如果都没有会自动获取机构下随机用户名称。数电票Web连接器取值逻辑：taxUserName＞drawer＞默认开 票人＞终端授权开票人。数电票乐企连接器长度：300字符
        // data.setDrawer("\u5F20\u4E00\u8BFA");
        // 特殊票种标志， 00：普通发票；01：农产品销售；02：农产品收购；08：成品油 12 机动车（默认是00普通发票）;16矿产品；03稀土； 全电类发票特殊票种标志：01 成品油发票；03：建筑服务发票；04：货物运输服务发票；05：不动产销售服务发票；06：不动产租赁服务发票；09：旅客运输发票；13：拖拉机和联合收割机；14：机动车；16：农产品收购
        // data.setInvoiceSpecialMark("00");
        // 销方银行账号，发票类型代码为01、02时该字段可用
        /// data.setSellerBankNumber("");
        // 购买方银行账号，发票类型代码为01、02时该字段可用
        // data.setBuyerBankNumber("");
        // 销方开户行及账号，发票类型代码为01、02时不用此字段
        // data.setSellerBankAccount("");

        // 开票流水号， 唯一标志开票请求。支持数字字母下划线组合。
        data.setSerialNo(conInvBatchVO.getBatchNo());
        // 含税标志， 0：不含税；1：含税（默认不含税）
        data.setPriceTaxMark("1");
        // 购方单位名称 全电为100个字符,发票抬头(去空格)
        data.setBuyerName(bookInvoiceVO.getInvoiceTitle());
        //购方税号
        data.setBuyerTaxNo(bookInvoiceVO.getTaxNo());
        // 购方地址及电话，专票必填
//        data.setBuyerAddressPhone(bookInvoiceVO.getInvoicePhone());
        // 购方开户行及账号，专票必填
        data.setBuyerBankAccount(bookInvoiceVO.getInvoiceAccount());
        data.setBuyerBankName(bookInvoiceVO.getDepositBank());
        data.setBuyerBankNumber(bookInvoiceVO.getInvoiceAccount());
        data.setBuyerAddress(bookInvoiceVO.getInvoiceAddress());
//        data.setBuyerTelphone(bookInvoiceVO.getInvoicePhone());
//        data.setBuyerPhone(bookInvoiceVO.getInvoicePhone()); // 电话（收件人联系电话）
        data.setRemarks(conInvBatchVO.getInvRemark()); // 开票备注传递百望
        // 合计税额， 保留两位小数；支持价税分离
//        data.setInvoiceTotalTax(BigDecimal.valueOf(1.3));
        // 合计金额， 保留两位小数；支持价税分离
//        data.setInvoiceTotalPrice(BigDecimal.valueOf(10.0));
        // 价税合计， 保留两位小数；支持价税分离
//        data.setInvoiceTotalPriceTax(BigDecimal.valueOf(11.3));


        // 发票种类编码, 004：增值税专用发票；007：增值税普通发票；026：增值税电子发票；025：增值税卷式发票；028:增值税电子专用发票 01:全电发票(增值税专用发票) 02:全电发票(普通发票)
        switch (TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType())) {
            // 百望发票种类编码，004:增值税专用发票，007:增值税普通发票，026：增值税电子发票，025：增值税卷式发票，028：增值税电子专用发票，01：电子发票（增值税专用发票），02：电子发票（普通发票）
            case EXCLUSIVE: // 增值税专用发票
                data.setInvoiceTypeCode("004");
                break;
            case NORMAL: // 增值税普通发票
                data.setInvoiceTypeCode("007");
                break;
            case ELEC_VAT_INV: //电子发票(增值税专用发票)
                data.setInvoiceTypeCode("01");
                break;
            case ELEC_NORMAL_INV: //电子发票(普通发票)
                data.setInvoiceTypeCode("02");
                break;

        }


        // 发票商品明细
        List<OutputInvoiceIssueInvoiceDetail> invoiceDetailsList = new ArrayList<>();
        OutputInvoiceIssueInvoiceDetail outputInvoiceIssueInvoiceDetail = new OutputInvoiceIssueInvoiceDetail();
        outputInvoiceIssueInvoiceDetail.setGoodsTaxRate(BigDecimal.valueOf(0.13));
        // 发票行性质，0：正常行 1：折扣行 2：被折扣行
        outputInvoiceIssueInvoiceDetail.setInvoiceLineNature("0");
        outputInvoiceIssueInvoiceDetail.setGoodsCode(invoiceItem.getGoodsCode());
        // 发票内容
        outputInvoiceIssueInvoiceDetail.setGoodsName(invoiceItem.getGoodsName());
        // 默认1
        outputInvoiceIssueInvoiceDetail.setGoodsLineNo(1);
        // 默认1
        outputInvoiceIssueInvoiceDetail.setGoodsQuantity(BigDecimal.valueOf(1));
        outputInvoiceIssueInvoiceDetail.setGoodsPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);// 单价默认为0
        outputInvoiceIssueInvoiceDetail.setGoodsTaxRate(conInvBatchVO.getTaxRate() != null ? conInvBatchVO.getTaxRate() : BigDecimal.ZERO);  // 发票类型/税率
        outputInvoiceIssueInvoiceDetail.setGoodsTotalPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO); // 批次开票金额

        invoiceDetailsList.add(outputInvoiceIssueInvoiceDetail);
        data.setInvoiceDetailsList(invoiceDetailsList);


        OutputInvoiceIssueRequest request = new OutputInvoiceIssueRequest();
        request.setIsSplit(false);
        // request.setCompletionCustom("");
        request.setData(data);
//        request.setOrgCode("");
//        request.setInvoiceTerminalCode("dzpzd008");
        request.setTaxNo(taxRegNo);
        request.setFormatGenerate(true);
        request.setFormatPushType(true);
//        request.setTaxDiskNo("");
//        request.setTaxUserName("cccccccb");

        try {
            OutputInvoiceIssueResponse response = invoiceSendMsgService.outputInvoice(request);//  发送至百望
// 经测试，不抛异常，即为成功
            log.info("[开票信息发送百望系统成功],response=" + response);
            // 发送成功后拉取发票
//            getInvoicesFromBaiwang();
            // 直接将查询结果保存数据库
            if (response.getSuccess() == true) {
                List<OutputInvoiceIssueInvoiceResult> OutputInvoiceIssueInvoiceResult = response.getResponse().getSuccess();
                saveInvoiceMessage(OutputInvoiceIssueInvoiceResult, conInvBatchVO);
            } else {
                throw new BusinessException("开票信息发送百望系统失败。");
            }
        } catch (BWOpenException e) {
            //"请联系当前企业税务人员，请前往税务系统重新登录认证全电账号";
            log.error("[开票信息发送百望系统失败],返回信息：", e);
            throw new BusinessException("开票信息发送百望系统失败。" + e.getSubMessage());
        }
    }


    private void saveInvoiceMessage(List<OutputInvoiceIssueInvoiceResult> reInvs, ConInvBatchVO conInvBatchVO) {
        if (!CollectionUtils.isEmpty(reInvs)) {
            // 保存发票
            for (OutputInvoiceIssueInvoiceResult mainInfo : reInvs) {
                //插入前判断重复，存在就不插入 inv_no
                String invNo = mainInfo.getInvoiceNo();
                int num = conInvBatchInvdtlRepo.countInvByNo(invNo);
                if (num > 0) {
                    log.info(String.format("发票%s已存在,跳过插入", num));
                    continue;
                }
                ConInvBatchInvdtlDO invbatchInvdtl = new ConInvBatchInvdtlDO();
                invbatchInvdtl.setInvbatchId(conInvBatchVO.getId());// 开票批次id
                invbatchInvdtl.setInvNo(mainInfo.getInvoiceNo()); // 发票号
                invbatchInvdtl.setNetAmt(mainInfo.getInvoiceTotalPrice());   // 合计金额
                invbatchInvdtl.setTaxAmt(mainInfo.getInvoiceTotalTax()); // 合计税额
                invbatchInvdtl.setInvAmt(mainInfo.getInvoiceTotalPriceTax()); // 价税合计
                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                invbatchInvdtl.setInvStatus("NORMAL");
                //税率
                invbatchInvdtl.setTaxRate(conInvBatchVO.getTaxRate());
                //实际开票日期
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDate date = LocalDate.parse(mainInfo.getInvoiceDate(), formatter);
                invbatchInvdtl.setActualInvDate(date);
                //对百望的下载链接，先做下载，然后上传文件系统，返回下载链接
                //发票地址
                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());

                invbatchInvdtl.setComeFrom("BAIWANG"); // 百望 :BAIWANG
                conInvBatchInvdtlDAO.save(invbatchInvdtl);
            }

        } else {
            log.info("[百望系统获取开票信息成功，发票列表为空],TW批次号：" + conInvBatchVO.getBatchNo());
        }
    }

    /**
     * 发送流水单信息到百望
     *
     * @param invId
     */
    @Override
    public void sendInvInfoToBaiwang(Long invId, Integer invOrRefund) {
        ConInvBatchVO conInvBatchVO = queryByKey(invId);
        //查询合同开票所关联的合同的的ouId
//        Long subContractId = conInvBatchVO.getSubContractId();
        Long conOuId = conInvBatchVO.getInvOuId();
        // 判断开票主体是否存在
        if (conOuId == null) {
            throw new BusinessException("无法查询到开票主体");
        }
        //业务伙伴优化 todo
        // PrdOrgCompanyDO prdOrgCompanyDO = prdOrgCompanyRepo.findById(conOuId).orElse(null);
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(conOuId);

        String taxRegNo = "";
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {

            taxRegNo = businessPartnerVOS.get(0).getIdenNo();
        }
        //增值税专用发票\增值税普通发票\电子发票(增值税专用发票)\电子发票(普通发票)要发送申请
        if (SHAPE.equals(TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
            // 只有形式发票不向百望发申请
            return;
        }
        if (conInvBatchVO.getInvAmt() != null && conInvBatchVO.getInvAmt().compareTo(BigDecimal.ZERO) < 0) {
            // 如果票面金额是负数，则不向百望发送数据
            return;
        }
        // 限制只有埃林哲的开票信息向百望发送数据 TODO: 后续设计会动态修改过滤信息
//        if (prdOrgCompanyDO == null || prdOrgCompanyDO.getCompanyName() == null || !prdOrgCompanyDO.getCompanyName().contains("埃林哲")) {
//            return;
//        }
// 限制只有埃林哲的开票信息向百望发送数据 TODO: 后续设计会动态修改过滤信息
        if (CollectionUtils.isEmpty(businessPartnerVOS) || !StringUtils.hasText(businessPartnerVOS.get(0).getPartnerName()) || !businessPartnerVOS.get(0).getPartnerName().contains("埃林哲")) {
            return;
        }
        // 发票商品信息
        InvItemVO invoiceItem = conInvBatchVO.getInvItemVO();
        if (invoiceItem == null) {
            throw new BusinessException("发票【" + invId + "】商品信息获取失败" + conInvBatchVO.getInvItemId());
        }
        //   PrdAbInvoiceVO prdAbInvoiceVO = conInvBatchVO.getPrdAbInvoiceVO();
        BookInvoiceVO bookInvoiceVO = conInvBatchVO.getPrdAbInvoiceVO();
        // 单独查询地址簿开票信息表获取税号等信息
        if (bookInvoiceVO == null) {
            throw new BusinessException("发票【" + invId + "】开票信息获取失败");
        }

        OutputTransactionUploadFlowSheetDetail flowSingleInfo = new OutputTransactionUploadFlowSheetDetail();

        flowSingleInfo.setGoodsCode(invoiceItem.getGoodsCode());
        flowSingleInfo.setGoodsName(invoiceItem.getGoodsName());  // 发票内容

        flowSingleInfo.setInvoiceLineNature("0"); // 发票行性质，0：正常行 1：折扣行 2：被折扣行
        flowSingleInfo.setGoodsLineNo("1"); // 默认 1
        flowSingleInfo.setGoodsQuantity(BigDecimal.ONE); // 默认 1
        flowSingleInfo.setGoodsPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);// 单价默认为0
        flowSingleInfo.setGoodsTaxRate(conInvBatchVO.getTaxRate() != null ? conInvBatchVO.getTaxRate() : BigDecimal.ZERO);  // 发票类型/税率
        flowSingleInfo.setGoodsTotalPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO); // 批次开票金额

        List<OutputTransactionUploadFlowSheetDetail> listFlowSingleInfo = new ArrayList<>();
        listFlowSingleInfo.add(flowSingleInfo);

        OutputTransactionUploadFlowSheet flowSingle = new OutputTransactionUploadFlowSheet();
        flowSingle.setFlowSheetDetailList(listFlowSingleInfo);

        flowSingle.setSerialNo(conInvBatchVO.getBatchNo());
        switch (TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType())) {
            // 百望发票种类编码，004:增值税专用发票，007:增值税普通发票，026：增值税电子发票，025：增值税卷式发票，028：增值税电子专用发票，01：电子发票（增值税专用发票），02：电子发票（普通发票）
            case EXCLUSIVE: // 增值税专用发票
                flowSingle.setInvoiceTypeCode("004");
                break;
            case NORMAL: // 增值税普通发票
                flowSingle.setInvoiceTypeCode("007");
                break;
            case ELEC_VAT_INV: //电子发票(增值税专用发票)
                flowSingle.setInvoiceTypeCode("01");
                break;
            case ELEC_NORMAL_INV: //电子发票(普通发票)
                flowSingle.setInvoiceTypeCode("02");
                break;

        }
        if (conInvBatchVO.getBatchDate() != null) {
            Date date = Date.from(conInvBatchVO.getBatchDate().atStartOfDay(ZoneId.systemDefault()).toInstant());
            flowSingle.setCreateDate(date);
        }


        flowSingle.setPriceTaxMark(invoiceItem.getPriceTaxMark()); //  含税标志0：不含税 1：含税
        flowSingle.setContractNo(conInvBatchVO.getSubContractNo()); // 合同号
        flowSingle.setBuyerName(bookInvoiceVO.getInvoiceTitle());  // 发票抬头(去空格)
        flowSingle.setBuyerTaxNo(bookInvoiceVO.getTaxNo());//购方税号
        flowSingle.setBuyerAddressPhone(bookInvoiceVO.getInvoicePhone());  // 购方地址及电话，专票必填
        flowSingle.setBuyerBankAccount(bookInvoiceVO.getInvoiceAccount()); // 购方开户行及账号，专票必填
        flowSingle.setBuyerBankName(bookInvoiceVO.getDepositBank());
        flowSingle.setBuyerBankNumber(bookInvoiceVO.getInvoiceAccount());
        flowSingle.setBuyerAddress(bookInvoiceVO.getInvoiceAddress());
        flowSingle.setBuyerTelphone(bookInvoiceVO.getInvoicePhone());
//        flowSingle.setOrganizationName(inv.getCustName());
//        flowSingle.setOrganizationCode(inv.getTaxNo());
        flowSingle.setBuyerPhone(bookInvoiceVO.getInvoicePhone()); // 电话（收件人联系电话）
//        flowSingle.setBuyerEmail(conInvBatchVO.getInvEmail());// 邮件发送给收件人
        // 邮件发送给收件人，抄送给发起人\项目经理\销售人员
//        Long createUserId = conInvBatchVO.getCreateUserId();
//        Long pmUserId = conInvBatchVO.getPmUserId();
//        Long saleManUserId = conInvBatchVO.getSaleManUserId();
//        List<String> mailByUserId = new ArrayList<>();
//        if (createUserId != null) {
//            //创建人
//            String createUserIdMail = employeeRepo.queryEmailByUserId(createUserId);
//            if (createUserIdMail != null) {
//                mailByUserId.add(createUserIdMail);
//            }
//        }
//        if (createUserId != null) {
//            //项目经理
//            String pmUserIdMail = employeeRepo.queryEmailByUserId(pmUserId);
//            if (pmUserIdMail != null) {
//                mailByUserId.add(pmUserIdMail);
//            }
//        }
//        if (createUserId != null) {
//            //销售人员
//            String saleManUserIdMail = employeeRepo.queryEmailByUserId(saleManUserId);
//            if (saleManUserIdMail != null) {
//                mailByUserId.add(saleManUserIdMail);
//            }
//        }
//        flowSingle.setEmailCarbonCopy(mailByUserId.stream().collect(Collectors.joining(",")));//抄送收件人邮箱

//        flowSingle.setRemarks(conInvBatchVO.getBatchNo() + "-" + (conInvBatchVO.getSubContractNo() == null ? "" : conInvBatchVO.getSubContractNo())); // 开票批次号-参考合同号
        flowSingle.setRemarks(conInvBatchVO.getInvRemark()); // 开票备注传递百望
        List<OutputTransactionUploadFlowSheet> data = new ArrayList<>();
        data.add(flowSingle);
        OutputTransactionUploadRequest request = new OutputTransactionUploadRequest();
        request.setTaxNo(taxRegNo); // 销方税号
        request.setData(data);
        try {
            OutputTransactionUploadResponse response = invoiceSendMsgService.flowSingleImport(request);//  发送至百望
            // 经测试，不抛异常，即为成功
            log.info("[开票信息发送百望系统成功],response=", response);
        } catch (BWOpenException e) {
            log.error("[开票信息发送百望系统失败],返回信息：", e);
            throw new BusinessException("开票信息发送百望系统失败。" + e.getSubMessage());
        }
    }


    @Override
    public void deleteInvInfoToBaiwang(Long invId, Integer invOrRefund) {
        if (invOrRefund == 1) {
            // 判断是否已经存在发票信息，若存在，则不可退回
            int invNum = conInvBatchInvdtlRepo.findInvBatchInvDtlsCount(invId);
            if (invNum > 0) {
                throw new BusinessException("单据已存在发票信息，禁止退回。");
            }
        }
        log.info("待删除开票id::::" + invId);
        ConInvBatchVO conInvBatchVO = queryByKey(invId);
        log.info("合同开票vo::::" + conInvBatchVO);
        log.info("合同开票vo::::" + conInvBatchVO.toString());
        //查询合同开票所关联的合同的的ouId
//        Long subContractId = conInvBatchVO.getSubContractId();
        Long conOuId = conInvBatchVO.getInvOuId();
        log.info("合同开票void::::" + conInvBatchVO.getInvOuId());
        // 判断开票主体是否存在
        if (conOuId == null) {
            log.info("无法查询到开票主体::::：：：：：：：：：：：：：：：：：：：：：：：：：：");
            throw new BusinessException("无法查询到开票主体");
        }
//        PrdOrgCompanyDO prdOrgCompanyDO = prdOrgCompanyRepo.findById(conOuId).orElse(null);
//        String taxRegNo = "";
//        if (prdOrgCompanyDO != null) {
//            taxRegNo = prdOrgCompanyDO.getTaxNo();
//            if (!StringUtils.hasText(taxRegNo)) {
//                throw new BusinessException("无法查询到开票主体的税号");
//            }
//        }
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(conOuId);
        String taxRegNo = "";
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
            taxRegNo = businessPartnerVOS.get(0).getIdenNo();
            if (!StringUtils.hasText(taxRegNo)) {
                throw new BusinessException("无法查询到开票主体的税号");
            }
        }


        //增值税专用发票\增值税普通发票\电子发票(增值税专用发票)\电子发票(普通发票)要发送申请
        if (SHAPE.equals(TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
            // 只有形式发票不向百望发申请
            return;
        }
        boolean flag = false;
        try {
            OutputTransactionQueryRequest queryRequest = new OutputTransactionQueryRequest();
            OutputTransactionQueryParam data = new OutputTransactionQueryParam();
//            data.setSerialNo(conInvBatchVO.getBatchNo());
            data.setSerialNo(conInvBatchVO.getBatchNo());
            queryRequest.setTaxNo(taxRegNo);
            queryRequest.setData(data);
            OutputTransactionQueryResponse queryResponse = invoiceSendMsgService.flowSingleQuery(queryRequest);
            if (queryResponse.getSuccess() && queryResponse.getResponse().size() > 0) {
                // 成功，则说明 百望系统中有流水单信息
                flag = true;
            }
        } catch (BopException e) {
            log.error("[开票信息从百望系统删除失败(查询流水单信息失败)],返回信息：", e);
            if (!e.getMessage().contains("根据流水单编号未查询到数据！")) {
                throw new BusinessException("该开票申请在百望系统的流水单已无法删除，不能拒绝流程，请联系财务。");
            }
        }
        if (flag) {
            try {
                OutputTransactionDeleteRequest request = new OutputTransactionDeleteRequest();
                request.setTaxNo(taxRegNo);
                request.setData(conInvBatchVO.getBatchNo());
                if (conInvBatchVO.getBatchNo() != null) {
                    OutputTransactionDeleteResponse response = invoiceSendMsgService.flowSingleDelete(request); //  删除流水单
                    // 经测试，不抛异常，即为成功
                    log.info("[开票信息从百望系统删除成功],response=", response);
                }
            } catch (BopException e) {
                log.error("[开票信息从百望系统删除失败],返回信息：", e);
                throw new BusinessException("该开票申请在百望系统的流水单已无法删除，不能拒绝流程，请联系财务。");
            }
        }

    }


    @Override
    public int getInvoicesFromBaiwang() {
        // 获取配置列表,只拉取配置里面有的公司的发票
        ConInvSettingQuery query = new ConInvSettingQuery();
        query.setInvYear(LocalDate.now().getYear());
        List<ConInvSettingVO> conInvSettingVOS = conInvSettingDAO.queryListDynamic(query);
        List<Long> ouIds = conInvSettingVOS.stream().map(e -> e.getInvOuId()).collect(Collectors.toList());
        // 获取 所有已批准待开票 （非 形式发票）的开票批次号信息
        List<ConInvBatchDO> invBatchNos = conInvBatchRepo.findByBatchStatusInAndInvTypeNotAndInvOuIdIn(Arrays.asList(BatchStatusEnum.APPROVETOINV.getCode(), BatchStatusEnum.APPROVINGINVBACK.getCode()), SHAPE.getType(), ouIds);
        for (ConInvBatchDO batchDO : invBatchNos) {
            String batchNo = batchDO.getBatchNo();
            Long invBatchId = batchDO.getId();
            BigDecimal invAmt = batchDO.getInvAmt() == null ? BigDecimal.ZERO : batchDO.getInvAmt(); // 金额
            // 查询开票主体的税号
            Long invOuId = batchDO.getInvOuId();
            // 判断开票主体是否存在
            if (invOuId == null) {
                // 跳过
                XxlJobLogger.log("无法查询到开票主体,跳过,批次号" + batchNo);
                continue;
            }
//            PrdOrgCompanyDO prdOrgCompanyDO = prdOrgCompanyRepo.findById(invOuId).orElse(null);
//            String taxRegNo = "";
//            if (prdOrgCompanyDO != null) {
//                taxRegNo = prdOrgCompanyDO.getTaxNo();
//            }
            List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(invOuId);
            String taxRegNo = "";
            if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
                taxRegNo = businessPartnerVOS.get(0).getIdenNo();
//                // 上海埃林哲管理咨询有限公司调用会报错-该appKey无权操作此税号信息—税号=[91310115342467102N]
//                if(taxRegNo.equals("91310115342467102N")){
//                    continue;
//                }
            }
            // 备注：因百望拆发票(当前发票明细只有1个商品)，流水单号会改变（原单号-> 原单号-1，原单号-2），所以需要取得金额，除以 MAX_INV_AMT ，得到 拆分的发票数量，然后根据发票数量 进行单据查询
            int length = invAmt.divide((invoiceProperties.getMaxInvAmt()), 0, BigDecimal.ROUND_CEILING).intValue();// 计算开发票的数量
            List<String> batchNos = new ArrayList<>();// 拼装拆分的发票数量
            if (length == 1 || length == 0) { // 长度为0,1 ，不需要修改单号
                batchNos.add(batchNo);
            } else {
                length = length + 1;
                for (int i = 1; i < length; i++) {
                    batchNos.add(batchNo + "-" + i);
                }
            }

            for (String tempBatchNo : batchNos) {
                OutputEinvoiceQueryRequest request = new OutputEinvoiceQueryRequest();
                OutputEinvoiceQueryInvoiceQueryParam data = new OutputEinvoiceQueryInvoiceQueryParam();
                data.setPageNo(1);
                data.setPageSize(500);
                data.setSerialNo(tempBatchNo);//流水单号
                request.setData(data);
                //税号
                request.setTaxNo(taxRegNo);
                try {
                    // 调用发票查询接口
                    OutputEinvoiceQueryResponse response = invoiceSendMsgService.invoiceQuery(request);
                    if (response.getSuccess() && response.getResponse().size() > 0) {
                        List<OutputEinvoiceQuery> reInvs = response.getResponse();
                        if (!CollectionUtils.isEmpty(reInvs)) {
                            // 保存发票
                            for (OutputEinvoiceQuery mainInfo : reInvs) {
                                //插入前判断重复，存在就不插入 inv_no
                                String invNo = mainInfo.getInvoiceNo();
                                int num = conInvBatchInvdtlRepo.countInvByNo(invNo);
                                if (num > 0) {
                                    log.info(String.format("发票%s已存在,跳过插入", num));
                                    continue;
                                }
                                ConInvBatchInvdtlDO invbatchInvdtl = new ConInvBatchInvdtlDO();
                                invbatchInvdtl.setInvbatchId(invBatchId);
                                invbatchInvdtl.setInvNo(mainInfo.getInvoiceNo()); // 发票号
                                invbatchInvdtl.setNetAmt(mainInfo.getInvoiceTotalPrice());   // 合计金额
                                invbatchInvdtl.setTaxAmt(mainInfo.getInvoiceTotalTax()); // 合计税额
                                invbatchInvdtl.setInvAmt(mainInfo.getInvoiceTotalPriceTax()); // 价税合计
                                if ("00".equals(mainInfo.getInvoiceStatus())) { // 00开具成功 02空白发票作废 03:已开发票作废
                                    invbatchInvdtl.setInvStatus("NORMAL");
                                } else {//03作废
                                    invbatchInvdtl.setInvStatus("INVALID");
                                }
//                                if ("05".equals(mainInfo.getRedDashedStatus())) { // 05已红冲
//                                    invbatchInvdtl.setInvStatus("CHARGEOFF");
//                                }
                                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                                //税率
                                invbatchInvdtl.setTaxRate(batchDO.getTaxRate());
                                //实际开票日期
                                invbatchInvdtl.setActualInvDate(LocalDate.parse(mainInfo.getInvoiceDate().substring(0, 10)));
                                //对百望的下载链接，先做下载，然后上传文件系统，返回下载链接
//                                FileUtil.upload();
//                                File file = FileUtil.upload(multipartFile, fileProperties.getPath().getPath() + type + File.separator);
                                //发票地址
                                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());

                                invbatchInvdtl.setComeFrom("BAIWANG"); // 百望 :BAIWANG
                                conInvBatchInvdtlDAO.save(invbatchInvdtl);
//                                invoiceDate = mainInfo.getInvoiceDate();
                            }
//                            ConInvBatchPayload invBatchPayload = new ConInvBatchPayload();
//                            invBatchPayload.setId(invBatchId);
//                            invBatchPayload.setBatchDate(!StringUtils.hasText(invoiceDate)?LocalDate.now():LocalDate.parse(invoiceDate.split(" ")[0]));
//                            // 更新开票日期
//                            conInvBatchDAO.updateByKeyDynamic(invBatchPayload);

                        } else {
                            log.info("[百望系统获取开票信息成功，发票列表为空],TW批次号：", batchNo, ",百望流水号：", tempBatchNo, ",response=", response);
                        }
                    } else {
                        log.info("[百望系统获取开票信息成功，返回信息为空],TW批次号：", batchNo, ",百望流水号：", tempBatchNo, ",response=", response);
                    }
                } catch (BopException e) {
                    log.error("[百望系统获取开票信息失败],TW批次号：", batchNo, ",百望流水号：", tempBatchNo, ",response=", e);
                }
            }
        }
        return 0;
    }

    @Override
    public void downloadBatch(HttpServletResponse response, ConInvBatchQuery query) {
        try {
            Workbook workbook = null;
            String fileName = "合同开票数据-" + LocalDate.now();
            log.info("=============================开始查询=======================================");
            List<ConInvBatchVO> conInvBatchVOS = conInvBatchDAO.queryListDynamic(query);
            log.info("=============================结束查询=======================================");
            download(conInvBatchVOS, response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<ConInvBatchVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        records = udcUtil.translateList(records);
        //定义文件名称
        String sheetName = "收款计划数据";
        List<ConInvBatchExcelExport> resultList = ConInvBatchConvert.INSTANCE.voListVoExcelExport(records);
//        resultList = udcUtil.translateList(resultList);
        for (ConInvBatchExcelExport record : resultList) {
            record.setOrder(String.valueOf(order));
            order++;
        }
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), ConInvBatchExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConInvBatchExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    /**
     * 已开票待收款记录退回到开票退回状态
     *
     * @param ids
     * @return
     */
    @Override
    public String reject(Long[] ids) {
        // 根据ids获取合同开票数据
        List<Long> idsList = Arrays.asList(ids);
        ConInvBatchQuery query = new ConInvBatchQuery();
        query.setIds(idsList);
        List<ConInvBatchVO> invList = conInvBatchDAO.queryListDynamic(query);
        if (invList == null || invList.size() == 0) {
            return "未查询到有效的合同开票信息；合同开票表主键" + Arrays.toString(ids);
        }
        // 获取收款计划数据
        ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
        planQuery.setInvBatchIds(idsList);
        List<ConReceivablePlanVO> planList = receivablePlanDAO.queryListDynamic(planQuery);
        if (planList == null || planList.size() <= 0) {
            return "未查询到收款计划信息；合同开票表主键" + Arrays.toString(ids);
        }
        // 检查合同开票的批次状态是否是 已开票待收款
        boolean allMatch = invList.stream().allMatch(inv -> "4".equals(inv.getBatchStatus()));
        if (!allMatch) {
            invList.stream()
                    .filter(inv -> !"4".equals(inv.getBatchStatus()))
                    .forEach(
                            inv ->
                                    log.info(
                                            "开票批次不是【已开票未收款】合同开票表id=" + inv.getId() + ";批次状态=" + inv.getBatchStatus()));
            return "开票批次状态不是[已开票未收款],不能退回！";
        }
        // 检查收款计划的收款状态=已开票 ACC:RECV_STATUS=4(1:未收款)
        allMatch = planList.stream().allMatch(plan -> "4".equals(plan.getReceStatus()));
        if (!allMatch) {
            planList.stream()
                    .filter(plan -> !"4".equals(plan.getReceStatus()))
                    .forEach(
                            plan ->
                                    log.info(
                                            "收款计划的计划状态不是【已开票】收款计划表id" + plan.getId() + ";收款状态" + plan.getReceStatus()));
            return "收款计划的计划状态不是【已开票】,不能退回";
        }
        // 修改开票状态为已批准待开票
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setIds(idsList);
        conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETOINV.getCode());
        conInvBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        // 修改收款计划的收款状态为未开票
        List<Long> planIds = planList.stream().map(e -> e.getId()).collect(Collectors.toList());
        ConReceivablePlanPayload receivablePlan = new ConReceivablePlanPayload();
        receivablePlan.setIds(planIds);
        receivablePlan.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
        receivablePlanDAO.updateByKeyDynamic(receivablePlan);
        return "";
    }

    @Override
    public void syncContractInvBatchTo4(String param) {
        String syncType = "contract_invbatch_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 11, 1, 0, 0);
            } else {
                //将同步时间提前30秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(30);
            }
        }
        XxlJobLogger.log("合同开票步到4.0开始...");
        XxlJobLogger.log("syncContractInvBatchTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConInvBatchDO> invBatchDOS = conInvBatchRepo.findByModifyTimeStart(format);
        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(invBatchDOS)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConInvBatchDO temDo : invBatchDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    // 翻译创建人与更新人
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
                    map.put("taxRate", temDo.getTaxRate().multiply(BigDecimal.valueOf(100)));
//                    String resultMain = httpUtil.sendPost(tw4_url + contractInvBatch, map);
//                    Map<String, Object> data = (Map) JSON.parse(resultMain);
                    Map<String, Object> data = new HashMap<>();
                    if ((data.get("ok") + "").equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        conInvBatchRepo.updateInvBatchIdV4(idV4, temDo.getId());
                    } else {
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "合同开票id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + data.get("datum"), null);
                        //更新该条合同的更新时间，下一次处理;
                        conInvBatchRepo.updateRemark(temDo.getId());
                        failNum++;
                    }
                } catch (Exception e) {
                    XxlJobLogger.log("合同开票" + temDo.getBatchNo() + "同步异常......" + e);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "合同开票id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                    failNum++;
                    //更新该条合同的更新时间，下一次处理;
                    conInvBatchRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "更新了" + (invBatchDOS.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
//            }else{
//                syncData = "合同开票数据未变化";
//            }
        } else {
            syncData = "合同开票数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步合同开票结束..." + logDO);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    @Override
    public void syncContractInvBatchInvDtlTo4(String param) {
        String syncType = "contract_invbatch_invdtl_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 11, 1, 0, 0);
            } else {
                //将同步时间提前30秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(30);
            }
        }
        XxlJobLogger.log("合同开票发票同步到4.0开始...");
        XxlJobLogger.log("syncContractInvBatchTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConInvBatchInvdtlDO> invBatchInvdtlDOS = conInvBatchInvdtlRepo.findByModifyTimeStart(format);
//        // 开票批次列表
//        List<ConInvBatchDO> invBatchDOS = conInvBatchRepo.findAll();
//        Map<Long, Long> invBatchMap = invBatchDOS.stream().collect(HashMap::new,(empMap,item) ->empMap.put(item.getId(),item.getInvBatchIdV4()),HashMap::putAll);
        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(invBatchInvdtlDOS)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConInvBatchInvdtlDO temDo : invBatchInvdtlDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    // 翻译创建人与更新人
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
//                    String resultMain = httpUtil.sendPost(tw4_url + contractInvBatchInvDtl, map);
//                    Map<String, Object> data = (Map) JSON.parse(resultMain);
                    Map<String, Object> data = new HashMap<>();
                    if ((data.get("ok") + "").equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        conInvBatchInvdtlRepo.updateInvBatchInvdtlIdV4(idV4, temDo.getId());
                    } else {
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "合同开票id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + data.get("datum"), null);
                        //更新该条合同的更新时间，下一次处理;
                        conInvBatchInvdtlRepo.updateRemark(temDo.getId());
                        failNum++;
                    }
                } catch (Exception e) {
                    XxlJobLogger.log("合同开票发票" + temDo.getInvNo() + "同步异常......" + e);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "合同开票发票id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                    failNum++;
                    //更新该条合同的更新时间，下一次处理;
                    conInvBatchInvdtlRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "更新了" + (invBatchInvdtlDOS.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
        } else {
            syncData = "合同开票数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步合同开票发票结束..." + logDO);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sendEmail(ConInvBatchVO conInvBatchVO) {
        conInvBatchVO = (ConInvBatchVO) udcUtil.translate(conInvBatchVO);
        // 发送收款录入通知邮件
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20240322001501");
        Map<String, Object> result = new HashMap<>();
        result.put("custName", conInvBatchVO.getInvTitle());//发票抬头
        result.put("contractName", conInvBatchVO.getContractName());
        result.put("invoiceType", conInvBatchVO.getInvTypeDesc() + "/" + conInvBatchVO.getTaxRate().multiply(BigDecimal.valueOf(100)) + "%");
        result.put("phaseDesc", conInvBatchVO.getPhaseDesc());
        result.put("invContent", conInvBatchVO.getGoodsNameStr());
        String formattedNumber = conInvBatchVO.getBatchInvAmt() == null ? "" : String.format("%,.2f", conInvBatchVO.getBatchInvAmt());
        result.put("invAmt", formattedNumber);
        result.put("invNo", conInvBatchVO.getInvNo());
        result.put("invOuName", conInvBatchVO.getInvOuName());
        String downloadCollect = conInvBatchVO.getConInvBatchInvdtlVOS().stream().filter(e -> StringUtils.hasText(e.getDownloadUrl())).map(e -> e.getDownloadUrl()).collect(Collectors.joining(","));
        result.put("downloadUrl", downloadCollect.replaceAll("http", "https"));
        // 通知人列表
        String recipientInner = conInvBatchVO.getRecipientInner();
        List<Long> userIdList = new ArrayList<>();
        // 抄送财务应付会计
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
        userIdList.addAll(userIdsByRole);
        if (!ObjectUtils.isEmpty(recipientInner)) {
            List<Long> recipientInnerList = Arrays.stream(recipientInner.split(",")).filter(str -> !str.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
            userIdList.addAll(recipientInnerList);
//            recipientInner=recipientInner+","+userIdsByRole.stream().map(Object::toString).collect(Collectors.joining(","));
//            messageConfigService.sendMessageConfig(configVO, result, "appoint_people", recipientInner);
        }
        // 查询人员列表
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = employeeService.queryByUserIdIn(userIdList);
        List<String> emailCollect = prdOrgEmployeeVOS.stream().map(e -> e.getEmail()).collect(Collectors.toList());

        String releaseTitle = SpelUtil.parseStringExpression(configVO.getMessageTitle(), result);
        String releaseBody = SpelUtil.parseStringExpression(configVO.getMessageContent(), result);
        String recipientOuter = conInvBatchVO.getRecipientOuter();

        if (!ObjectUtils.isEmpty(recipientOuter)) {
            List<String> recipientOuterCollect = Arrays.stream(recipientOuter.split("[,;，；]")).collect(Collectors.toList());
            emailCollect.addAll(recipientOuterCollect);
//            String[] arr = recipientOuter.split("[,;，；]");
//            for (String s : arr) {
//                // 要求一个一个发所以每个人都分开
//                messageConfigService.sendEmail(Collections.singletonList(s),releaseTitle,releaseBody,configVO.getSource());
//            }
        }
        // 去重
        List<String> distinctList = emailCollect.stream()
                .distinct()
                .collect(Collectors.toList());

        // 邮件发送地址
        String invEmail = conInvBatchVO.getInvEmail();

        // 抄送列表
        distinctList.remove(invEmail);

        // 发给收件人邮箱
        messageConfigService.sendEmailWithCc(Collections.singletonList(invEmail), distinctList, releaseTitle, releaseBody, configVO.getSource());

    }

    @Override
    @Transactional
    public Long updateBatchStatusById(Long id, String batchStatus) {
        return conInvBatchDAO.updateBatchStatusById(id, batchStatus);
    }

}
