package com.elitesland.tw.tw5.server.prd.salecon.service;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingMonthService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingTypeService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingTypeConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingMonthDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingTypeDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingMonthRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingTypeRepo;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.sql.BatchUpdateException;
import java.util.*;

/**
 * ConInvSettingController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConInvSettingServiceImpl extends BaseServiceImpl implements ConInvSettingService {

    private final ConInvSettingRepo conInvSettingRepo;
    private final ConInvSettingMonthRepo conInvSettingMonthRepo;
    private final ConInvSettingTypeRepo conInvSettingTypeRepo;
    private final ConInvSettingDAO conInvSettingDAO;
    private final ConInvSettingMonthDAO conInvSettingMonthDAO;
    private final ConInvSettingTypeDAO conInvSettingTypeDAO;
    private final ConInvSettingMonthService invSettingMonthService;
    private final ConInvSettingTypeService invSettingTypeService;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<ConInvSettingVO> queryPaging(ConInvSettingQuery query){
        return conInvSettingDAO.queryPaging(query);
    }

    @Override
    public List<ConInvSettingVO> queryListDynamic(ConInvSettingQuery query){
        return conInvSettingDAO.queryListDynamic(query);
    }

    @Override
    public ConInvSettingVO queryByKey(Long key) {
        ConInvSettingDO entity = conInvSettingRepo.findById(key).orElseGet(ConInvSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingVO vo = ConInvSettingConvert.INSTANCE.toVo(entity);
        List<ConInvSettingMonthVO> conInvSettingMonthVOS = invSettingMonthService.queryByInvSetting(vo);
        List<ConInvSettingTypeVO> conInvSettingTypeVOS = invSettingTypeService.queryByInvSettingId(entity.getId());
        vo.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        vo.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        return vo;
    }

    @Override
    public ConInvSettingVO queryByInvOuIdAndYear(Long invOuId, Integer invYear) {
        ConInvSettingDO entity = conInvSettingRepo.findByInvOuIdAndInvYear(invOuId,invYear);
        if(ObjectUtils.isEmpty(entity)){
            throw TwException.error("","不存在");
        }
        ConInvSettingVO vo = ConInvSettingConvert.INSTANCE.toVo(entity);
        List<ConInvSettingMonthVO> conInvSettingMonthVOS = invSettingMonthService.queryByInvSetting(vo);
        List<ConInvSettingTypeVO> conInvSettingTypeVOS = invSettingTypeService.queryByInvSettingId(entity.getId());
        vo.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        vo.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        return vo;
    }

    /**
     * 插入校验
     * @param payload
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer insertCheck(ConInvSettingPayload payload){
        int count =0;
        if(payload.getId()!=null){
            count = conInvSettingRepo.countByInvOuIdAndInvYearAndIdNot(payload.getInvOuId(), payload.getInvYear(), payload.getId());
        } else{
            // 查询
            count = conInvSettingRepo.countByInvOuIdAndInvYear(payload.getInvOuId(), payload.getInvYear());
        }
        return count;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingVO insert(ConInvSettingPayload payload) {
        // 查询
        int count = conInvSettingRepo.countByInvOuIdAndInvYear(payload.getInvOuId(), payload.getInvYear());
        if(count>0){
            throw TwException.error("",payload.getInvYear()+"年" + cacheUtil.getCompanyNameByBookId(payload.getInvOuId()) +"已配置!");
        }
        ConInvSettingDO entityDo = ConInvSettingConvert.INSTANCE.toDo(payload);
        ConInvSettingVO   conInvSettingVO = ConInvSettingConvert.INSTANCE.toVo(conInvSettingRepo.save(entityDo));
        Long settingId = conInvSettingVO.getId();
        //保存子表数据
        List<ConInvSettingMonthPayload> conInvSettingMonthPayloadList = payload.getConInvSettingMonthPayloadList();
        conInvSettingMonthPayloadList.stream().forEach(e->e.setInvSettingId(settingId));
        if(!conInvSettingMonthPayloadList.isEmpty()){
            List<ConInvSettingMonthDO> conInvSettingMonthDOS = ConInvSettingMonthConvert.INSTANCE.toDoList(conInvSettingMonthPayloadList);
            List<ConInvSettingMonthVO> conInvSettingMonthVOS = ConInvSettingMonthConvert.INSTANCE.toVoList(conInvSettingMonthRepo.saveAll(conInvSettingMonthDOS));
            conInvSettingVO.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        }
        List<ConInvSettingTypePayload> conInvSettingTypePayloadList = payload.getConInvSettingTypePayloadList();
        conInvSettingTypePayloadList.stream().forEach(e->e.setInvSettingId(settingId));
        if(!conInvSettingTypePayloadList.isEmpty()){
            List<ConInvSettingTypeDO> conInvSettingTypeDOS = ConInvSettingTypeConvert.INSTANCE.toDoList(conInvSettingTypePayloadList);
            List<ConInvSettingTypeVO> conInvSettingTypeVOS = ConInvSettingTypeConvert.INSTANCE.toVoList(conInvSettingTypeRepo.saveAll(conInvSettingTypeDOS));
            conInvSettingVO.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        }
        return conInvSettingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingVO update(ConInvSettingPayload payload) {
        List<Long> deleteSettingMonthKeys = payload.getDeleteSettingMonthKeys();
        List<Long> deleteSettingTypeKeys = payload.getDeleteSettingTypeKeys();
        if(!CollectionUtils.isEmpty(deleteSettingMonthKeys)){
            conInvSettingMonthDAO.deleteSoft(deleteSettingMonthKeys);
        }
        if(!CollectionUtils.isEmpty(deleteSettingTypeKeys)){
            conInvSettingTypeDAO.deleteSoft(deleteSettingTypeKeys);
        }
        ConInvSettingDO entity = conInvSettingRepo.findById(payload.getId()).orElseGet(ConInvSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingDO entityDo = ConInvSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ConInvSettingVO conInvSettingVO = ConInvSettingConvert.INSTANCE.toVo(conInvSettingRepo.save(entity));
        //保存子表数据,三种情况，新增，修改，删除
        List<ConInvSettingMonthPayload> conInvSettingMonthPayloadList = payload.getConInvSettingMonthPayloadList();
        if(!conInvSettingMonthPayloadList.isEmpty()){
            List<ConInvSettingMonthDO> conInvSettingMonthDOS = ConInvSettingMonthConvert.INSTANCE.toDoList(conInvSettingMonthPayloadList);
            List<ConInvSettingMonthVO> conInvSettingMonthVOS= new ArrayList<>();
            for (ConInvSettingMonthDO conInvSettingMonthDO : conInvSettingMonthDOS) {
                if(conInvSettingMonthDO.getId()!=null){
                    ConInvSettingMonthDO monthEntity = conInvSettingMonthRepo.findById(conInvSettingMonthDO.getId()).orElseGet(ConInvSettingMonthDO::new);
                    Assert.notNull(entity.getId(), "不存在");
                    monthEntity.copy(conInvSettingMonthDO);
                    conInvSettingMonthVOS.add(ConInvSettingMonthConvert.INSTANCE.toVo(conInvSettingMonthRepo.save(monthEntity)));
                }else{
                    conInvSettingMonthDO.setInvSettingId(payload.getId());
                    conInvSettingMonthVOS.add(ConInvSettingMonthConvert.INSTANCE.toVo(conInvSettingMonthRepo.save(conInvSettingMonthDO)));
                }
            }
            conInvSettingVO.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        }
        List<ConInvSettingTypePayload> conInvSettingTypePayloadList = payload.getConInvSettingTypePayloadList();
        if(!conInvSettingTypePayloadList.isEmpty()){
            List<ConInvSettingTypeDO> conInvSettingTypeDOS = ConInvSettingTypeConvert.INSTANCE.toDoList(conInvSettingTypePayloadList);
            List<ConInvSettingTypeVO> conInvSettingTypeVOS= new ArrayList<>();
            for (ConInvSettingTypeDO conInvSettingTypeDO : conInvSettingTypeDOS) {
                if(conInvSettingTypeDO.getId()!=null){
                    ConInvSettingTypeDO typeEntity = conInvSettingTypeRepo.findById(conInvSettingTypeDO.getId()).orElseGet(ConInvSettingTypeDO::new);
                    Assert.notNull(entity.getId(), "不存在");
                    typeEntity.copy(conInvSettingTypeDO);
                    conInvSettingTypeVOS.add(ConInvSettingTypeConvert.INSTANCE.toVo(conInvSettingTypeRepo.save(typeEntity)));
                }else{
                    conInvSettingTypeDO.setInvSettingId(payload.getId());
                    conInvSettingTypeVOS.add(ConInvSettingTypeConvert.INSTANCE.toVo(conInvSettingTypeRepo.save(conInvSettingTypeDO)));
                }
            }
            conInvSettingVO.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        }
        return conInvSettingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConInvSettingPayload payload) {
        ConInvSettingDO entity = conInvSettingRepo.findById(payload.getId()).orElseGet(ConInvSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conInvSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conInvSettingDAO.deleteSoft(keys);
        }
    }

}
