package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemWorkTypeDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemWorkTypeDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemWorkTypeRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 人力成本管理dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemWorkTypeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemWorkTypeRepo repo;
    private final QPrdSystemWorkTypeDO qdo = QPrdSystemWorkTypeDO.prdSystemWorkTypeDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdSystemWorkTypeDO> saveAll(List<PrdSystemWorkTypeDO> ados) {

        return repo.saveAll(ados);
    }

    /**
     * 修改人力成本管理
     *
     * @param key
     * @param sysType
     * @param sysWork
     * @param sysLevel
     * @param unitPrice
     * @return
     */
    public long updateByKeyDynamic(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(key));

        if (sysType != null) {
            update.set(qdo.sysType, sysType);
        }
        if (sysWork != null) {
            update.set(qdo.sysWork, sysWork);
        }
        if (sysLevel != null) {
            update.set(qdo.sysLevel, sysLevel);
        }
        if (unitPrice != null) {
            update.set(qdo.unitPrice, unitPrice);
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemWorkTypeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemWorkTypeVO.class,
                qdo.id,
                qdo.sysType,
                qdo.sysWork,
                qdo.sysLevel,
                qdo.unitPrice,
                qdo.createUserId,
                qdo.createTime,
                qdoEmployee.employeeName.as("createUserName")
        )).from(qdo).leftJoin(qdoEmployee).on(qdo.createUserId.eq(qdoEmployee.userId));
    }

    /**
     * @param
     * @return
     * @Description 获取所有工种类型
     **/
    public List<PrdSystemWorkTypeVO> queryList() {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemWorkTypeVO> getJpaQueryWhere(PrdSystemWorkTypeQuery query) {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getSysType())) {
            jpaQuery.where(qdo.sysType.eq(query.getSysType()));
        }
        if (!ObjectUtils.isEmpty(query.getSysWork())) {
            jpaQuery.where(qdo.sysWork.eq(query.getSysWork()));
        }

        if (!ObjectUtils.isEmpty(query.getSysLevel())) {
            jpaQuery.where(qdo.sysLevel.eq(query.getSysLevel()));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemWorkTypeVO> queryPaging(PrdSystemWorkTypeQuery query) {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemWorkTypeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemWorkTypeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
