package com.elitesland.tw.tw5.server.prd.ts.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Api(tags = "工时审批配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ts/tsApprovalConfig")
@Slf4j
public class TsApprovalConfigController {

    private final TsApprovalConfigService tsApprovalConfigService;

    /**
     * 工时审批配置管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("工时审批配置管理-新增")
    public TwOutputUtil<TsApprovalConfigVO> insert(@RequestBody TsApprovalConfigPayload payload) {
        return TwOutputUtil.ok(tsApprovalConfigService.insert(payload));
    }

    /**
     * 工时审批配置管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("工时审批配置管理-更新")
    public TwOutputUtil<TsApprovalConfigVO> update(@RequestBody TsApprovalConfigPayload payload) {
        return TwOutputUtil.ok(tsApprovalConfigService.update(payload));
    }

    /**
     * 工时审批配置管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("工时审批配置管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TsApprovalConfigPayload payload) {
        return TwOutputUtil.ok(tsApprovalConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 工时审批配置管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("工时审批配置管理-主键查询")
    public TwOutputUtil<TsApprovalConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tsApprovalConfigService.queryByKey(key));
    }

    /**
     * 工时审批配置管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("工时审批配置管理-分页")
    public TwOutputUtil<PagingVO<TsApprovalConfigVO>> paging(TsApprovalConfigQuery query) {
        return TwOutputUtil.ok(tsApprovalConfigService.queryPaging(query));
    }

    /**
     * 工时审批配置管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("工时审批配置管理-查询列表")
    public TwOutputUtil<List<TsApprovalConfigVO>> queryList(TsApprovalConfigQuery query) {
        return TwOutputUtil.ok(tsApprovalConfigService.queryListDynamic(query));
    }

    /**
     * 工时审批配置管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("工时审批配置管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        tsApprovalConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 更具任务包id获取配置对应的审批资源）
     *
     * @param taskPackageId
     * @param finYear
     * @return
     */
    @GetMapping("/queryApprovalRes")
    @UdcNameClass
    @ApiOperation("更具任务包id获取配置对应的审批资源")
    public TwOutputUtil<List<TsApprovalConfigVO>> queryApprovalRes(Long taskPackageId, Integer finYear) {
        return TwOutputUtil.ok(tsApprovalConfigService.queryApprovalRes(taskPackageId, null));
    }

}

