package com.elitesland.tw.tw5.server.system.service;

import com.elitesland.tw.tw5.server.system.param.component.ComponentGroupVO;
import com.elitescloud.cloudt.common.base.ApiResult;

import java.util.List;
import java.util.Set;

/**
 * 组件服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/16
 */
public interface SystemComponentService {

    /**
     * 查询所有组件
     *
     * @return 所有组件信息
     */
    ApiResult<List<ComponentGroupVO>> queryAllComponents();

    /**
     * 获取禁用的组件
     *
     * @return 组件编码
     */
    ApiResult<Set<String>> queryDisabledComponents();

    /**
     * 禁用指定组件
     *
     * @param componentCode 组件编码
     * @return 更新结果
     */
    ApiResult<Boolean> updateDisabledComponent(String componentCode);

    /**
     * 启用指定组件
     *
     * @param componentCode 组件编码
     * @return 更新结果
     */
    ApiResult<Boolean> updateEnabledComponent(String componentCode);
}
