/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingTitlePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingTitleQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingTitleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingTitleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceDetailService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingTitleConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingTitleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingTitleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingTitleRepo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSettingTitleServiceImpl
extends BaseServiceImpl
implements AccReimSettingTitleService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSettingTitleServiceImpl.class);
    private final AccReimSettingTitleRepo accReimSettingTitleRepo;
    private final AccReimSettingTitleDAO accReimSettingTitleDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final InvInvoiceService invInvoiceService;
    private final InvInvoiceDetailService invInvoiceDetailService;
    private final PrdOrgCompanyService prdOrgCompanyService;
    private final BusinessPartnerService businessPartnerService;

    public PagingVO<AccReimSettingTitleVO> queryPaging(AccReimSettingTitleQuery query) {
        return this.accReimSettingTitleDAO.queryPaging(query);
    }

    public List<AccReimSettingTitleVO> queryListDynamic(AccReimSettingTitleQuery query) {
        return this.accReimSettingTitleDAO.queryListDynamic(query);
    }

    public AccReimSettingTitleVO queryByKey(Long key) {
        AccReimSettingTitleDO entity = this.accReimSettingTitleRepo.findById(key).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingTitleVO vo = AccReimSettingTitleConvert.INSTANCE.toVo(entity);
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.INVOICE_TITLE.getCode());
        List accReimSettingVOS = this.accReimSettingService.queryListDynamic(accReimSettingQuery);
        if (!CollectionUtils.isEmpty((Collection)accReimSettingVOS)) {
            vo.setAccReimSettingVO((AccReimSettingVO)accReimSettingVOS.get(0));
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingTitleVO insert(AccReimSettingTitlePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingTitleDO entityDo = AccReimSettingTitleConvert.INSTANCE.toDo(payload);
        AccReimSettingTitleVO accReimSettingTitleVO = AccReimSettingTitleConvert.INSTANCE.toVo((AccReimSettingTitleDO)this.accReimSettingTitleRepo.save(entityDo));
        Long id = accReimSettingTitleVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.INVOICE_TITLE.getCode());
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingDO));
        accReimSettingTitleVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingTitleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingTitleVO update(AccReimSettingTitlePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingTitleDO entity = this.accReimSettingTitleRepo.findById(payload.getId()).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingTitleDO entityDo = AccReimSettingTitleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingTitleVO accReimSettingTitleVO = AccReimSettingTitleConvert.INSTANCE.toVo((AccReimSettingTitleDO)this.accReimSettingTitleRepo.save(entity));
        AccReimSettingDO accReimSettingEntity = this.accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)accReimSettingEntity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingTitleVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingTitleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimSettingTitlePayload payload) {
        AccReimSettingTitleDO entity = this.accReimSettingTitleRepo.findById(payload.getId()).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimSettingTitleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimSettingTitleDAO.deleteSoft(keys);
        }
    }

    public AccReimSettingTitleVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS, Long reimUserId, Long expenseCompanyId) {
        List idList;
        BusinessPartnerVO businessPartnerVO = null;
        List businessPartnerVOS = this.businessPartnerService.queryByBookId(expenseCompanyId);
        if (CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
            throw TwException.error("", "\u62a5\u9500\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff01");
        }
        businessPartnerVO = (BusinessPartnerVO)businessPartnerVOS.get(0);
        AccReimSettingTitleVO accReimSettingTitleVO = this.queryByKey(key);
        String invoiceType = accReimSettingTitleVO.getInvType();
        List invoiceTypeList = Arrays.stream(invoiceType.split(",")).collect(Collectors.toList());
        AccReimSettingVO accReimSettingVO = accReimSettingTitleVO.getAccReimSettingVO();
        String whiteList = accReimSettingVO.getWhiteList();
        if (StringUtils.hasText((String)whiteList) && (idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList())).contains(reimUserId)) {
            return accReimSettingTitleVO;
        }
        InvInvoiceDetailQuery query = new InvInvoiceDetailQuery();
        List invoiceIds = invInvoiceVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        query.setInvIds(invoiceIds);
        List invInvoiceDetailVOS = this.invInvoiceDetailService.queryListDynamic(query);
        Map<Long, List<InvInvoiceDetailVO>> groupedInvInvoiceDetailVOSMap = invInvoiceDetailVOS.stream().collect(Collectors.groupingBy(InvInvoiceDetailVO::getInvId));
        String InconsistentTitleStr = "";
        Object remindText = "";
        Object errorText = "";
        for (InvInvoiceVO invInvoiceVO : invInvoiceVOS) {
            String taxNo;
            String saleTaxNo;
            String checkContent;
            String invNo = invInvoiceVO.getInvoiceNo();
            if (!invoiceTypeList.contains(invInvoiceVO.getInvType())) continue;
            String exceptCommodityName = accReimSettingTitleVO.getExceptCommodityName();
            List exceptList = Arrays.stream(exceptCommodityName.split(",")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)groupedInvInvoiceDetailVOSMap.get(invInvoiceVO.getId()))) {
                int end;
                String commodityName = ((InvInvoiceDetailVO)invInvoiceDetailVOS.get(0)).getCommodityName();
                int start = commodityName.indexOf("*") + 1;
                if (exceptList.contains(commodityName = commodityName.substring(start, end = commodityName.indexOf("*", start)))) continue;
            }
            if (!StringUtils.hasText((String)(checkContent = accReimSettingTitleVO.getCheckContent()))) continue;
            List collect = Arrays.stream(checkContent.split(",")).collect(Collectors.toList());
            Boolean notEqualFlag = false;
            if (collect.contains("title")) {
                String purchaserName = invInvoiceVO.getPurchaserName();
                String companyName = businessPartnerVO.getPartnerName();
                if (purchaserName == null || !purchaserName.equals(companyName)) {
                    notEqualFlag = true;
                }
            }
            if (collect.contains("taxNo") && !(saleTaxNo = invInvoiceVO.getSaleTaxNo()).equals(taxNo = businessPartnerVO.getIdenNo())) {
                notEqualFlag = true;
            }
            accReimSettingTitleVO.setNotEqualFlag(notEqualFlag);
            if (!notEqualFlag.booleanValue()) continue;
            if (accReimSettingVO.getRemindText() != null) {
                String remindTextCopy = accReimSettingVO.getRemindText();
                remindTextCopy = remindTextCopy.replace("#{1}", invNo);
                Object object = remindText = ((String)remindText).length() < 1 ? (String)remindText + remindTextCopy : (String)remindText + "," + remindTextCopy;
            }
            if (accReimSettingVO.getErrorText() == null) continue;
            String errorTextCopy = accReimSettingVO.getErrorText();
            errorTextCopy = errorTextCopy.replace("#{1}", invNo);
            errorText = ((String)errorText).length() < 1 ? (String)errorText + errorTextCopy : (String)errorText + "," + errorTextCopy;
        }
        accReimSettingVO.setRemindText((String)remindText);
        accReimSettingVO.setErrorText((String)errorText);
        return accReimSettingTitleVO;
    }

    public AccReimSettingTitleServiceImpl(AccReimSettingTitleRepo accReimSettingTitleRepo, AccReimSettingTitleDAO accReimSettingTitleDAO, AccReimSettingService accReimSettingService, AccReimSettingRepo accReimSettingRepo, InvInvoiceService invInvoiceService, InvInvoiceDetailService invInvoiceDetailService, PrdOrgCompanyService prdOrgCompanyService, BusinessPartnerService businessPartnerService) {
        this.accReimSettingTitleRepo = accReimSettingTitleRepo;
        this.accReimSettingTitleDAO = accReimSettingTitleDAO;
        this.accReimSettingService = accReimSettingService;
        this.accReimSettingRepo = accReimSettingRepo;
        this.invInvoiceService = invInvoiceService;
        this.invInvoiceDetailService = invInvoiceDetailService;
        this.prdOrgCompanyService = prdOrgCompanyService;
        this.businessPartnerService = businessPartnerService;
    }
}

