/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.common;

import cn.hutool.core.util.RandomUtil;
import java.util.HashMap;
import java.util.Map;

public class URLShortenerUtil {
    private static Map<String, String> longToShortMap = new HashMap<String, String>();
    private static Map<String, String> shortToLongMap = new HashMap<String, String>();
    private String BASE_HOST = "http://short.url/";
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int BASE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();

    public URLShortenerUtil() {
    }

    public URLShortenerUtil(String shortUrlPre) {
        this.BASE_HOST = shortUrlPre;
    }

    private String encode(int num) {
        StringBuilder sb = new StringBuilder();
        while (num > 0) {
            sb.append(ALPHABET.charAt(num % BASE));
            num /= BASE;
        }
        while (sb.length() < 6) {
            sb.append('0');
        }
        return sb.reverse().toString();
    }

    private int decode(String str) {
        int num = 0;
        for (int i = 0; i < str.length(); ++i) {
            num = num * BASE + ALPHABET.indexOf(str.charAt(i));
        }
        return num;
    }

    public String longToShortUrl(String longUrl, int id) {
        if (longToShortMap.containsKey(longUrl)) {
            return longToShortMap.get(longUrl);
        }
        String shortUrl = this.encode(id);
        longToShortMap.put(longUrl, shortUrl);
        shortToLongMap.put(shortUrl, longUrl);
        ++id;
        return shortUrl;
    }

    public String shortToLongUrl(String shortUrl) {
        return shortToLongMap.get(shortUrl);
    }

    public static void main(String[] args) {
        URLShortenerUtil urlShortener = new URLShortenerUtil();
        String longUrl = "https://www.example.com/my-long33333";
        String shortUrl = urlShortener.longToShortUrl(longUrl, RandomUtil.randomInt((int)100000));
        System.out.println("Short URL is: " + shortUrl);
        System.out.println("Long URL is: " + urlShortener.shortToLongUrl(shortUrl));
    }
}

