/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOperationPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOperationPlanDetailMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmOperationPlanDetailServiceImpl
implements CrmOperationPlanDetailService {
    private static final Logger log = LoggerFactory.getLogger(CrmOperationPlanDetailServiceImpl.class);
    private final CrmOperationPlanDetailRepo repo;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final CrmOperationPlanDetailMemberService planDetailMemberService;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserDAO prdUserDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final CrmCustomerOperationRepo customerOperationRepo;
    private final PrdFsmFileRefService fsmFileRefService;
    private final TaskExecutor taskExecutor;
    private final PrdOrgOrganizationService prdOrgOrganizationService;

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanDetailVO insert(CrmOperationPlanDetailPayload payload) {
        List memberList;
        if (null == payload.getReadFlag()) {
            payload.setReadFlag(Integer.valueOf(0));
        }
        CrmOperationPlanDetailDO entityDo = CrmOperationPlanDetailConvert.INSTANCE.toDo(payload);
        long id = ((CrmOperationPlanDetailDO)((Object)this.repo.save((Object)entityDo))).getId();
        if (StringUtils.hasText((String)payload.getFileCodes())) {
            for (String fileCode : payload.getFileCodes().split(",")) {
                PrdFsmFileRefPayload fsmFileRefPayload = new PrdFsmFileRefPayload();
                fsmFileRefPayload.setFileCode(fileCode);
                fsmFileRefPayload.setObjId(Long.valueOf(id));
                fsmFileRefPayload.setObjType(PrdCommentObjTypeEnum.OPER_PLAN_MAIN.getCode());
                this.fsmFileRefService.insert(fsmFileRefPayload);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(memberList = payload.getMemberList()))) {
            memberList.stream().filter(member -> member.getUserId() != null).forEach(member -> {
                if (null == member.getOperId()) {
                    member.setOperId(entityDo.getOperId());
                    member.setPlanDetailId(entityDo.getId());
                }
                this.planDetailMemberService.insert(member);
            });
        }
        this.logService.saveNewLog(entityDo.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        return CrmOperationPlanDetailConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanDetailVO update(CrmOperationPlanDetailPayload payload) {
        CrmOperationPlanDetailDO entity = this.repo.findById(payload.getId()).orElseGet(CrmOperationPlanDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanDetailDO entityLog = new CrmOperationPlanDetailDO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)entityLog));
        CrmOperationPlanDetailDO entityDo = CrmOperationPlanDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        CrmOperationPlanDetailDO save = (CrmOperationPlanDetailDO)((Object)this.repo.save((Object)entity));
        this.fsmFileRefService.deleteSoftByObjIdAndObjType(payload.getId(), PrdCommentObjTypeEnum.OPER_PLAN_MAIN.getCode());
        if (StringUtils.hasText((String)payload.getFileCodes())) {
            for (String fileCode : payload.getFileCodes().split(",")) {
                PrdFsmFileRefPayload fsmFileRefPayload = new PrdFsmFileRefPayload();
                fsmFileRefPayload.setFileCode(fileCode);
                fsmFileRefPayload.setObjId(payload.getId());
                fsmFileRefPayload.setObjType(PrdCommentObjTypeEnum.OPER_PLAN_MAIN.getCode());
                this.fsmFileRefService.insert(fsmFileRefPayload);
            }
        }
        this.logService.saveNewLog(entityDo.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), fieldsUpdateLog.toString());
        }
        return CrmOperationPlanDetailConvert.INSTANCE.toVo(save);
    }

    private void sendQwxMessage(CrmOperationPlanDetailPayload payload) {
        if (null != payload.getPerformerId()) {
            String loginUserName = GlobalUtil.getLoginUserName();
            String planName = payload.getPlanName();
            this.qyWxCommunicationService.sendMessageToUser(payload.getPerformerId(), loginUserName + "\u5728\u201c" + planName + "\u201d\u5c06\u4f60\u8bbe\u4e3a\u6267\u884c\u8005");
        }
    }

    public CrmOperationPlanDetailVO queryByKey(Long key) {
        Optional operOptional;
        CrmOperationPlanDetailDO entity = this.repo.findById(key).orElseGet(CrmOperationPlanDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanDetailVO crmCustomerOperationVO = CrmOperationPlanDetailConvert.INSTANCE.toVo(entity);
        if (entity.getOperId() != null && (operOptional = this.customerOperationRepo.findById(entity.getOperId())).isPresent()) {
            crmCustomerOperationVO.setCustOperStatus(((CrmCustomerOperationDO)((Object)operOptional.get())).getCustOperStatus());
        }
        return crmCustomerOperationVO;
    }

    public List<CrmOperationPlanDetailVO> queryList(CrmOperationPlanDetailQuery query) {
        List custOperOrgIdList;
        List prdOrgOrganizationRefVOS1;
        List saleOperOrgIdList;
        if (query.getSubSaleOperBuFlag() != null && query.getSubSaleOperBuFlag().booleanValue() && query.getSaleOperBu() != null && !CollectionUtils.isEmpty(saleOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getSaleOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
            query.setSaleOperBu(null);
            query.setSaleOperBuList(saleOperOrgIdList);
        }
        if (query.getSubCustOperBuFlag() != null && query.getSubCustOperBuFlag().booleanValue() && query.getCustOperBu() != null && !CollectionUtils.isEmpty(custOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getCustOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
            query.setCustOperBu(null);
            query.setCustOperBuList(custOperOrgIdList);
        }
        List all = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        return CrmOperationPlanDetailConvert.INSTANCE.toVoList(all);
    }

    public List<CrmOperationPlanDetailVO> queryListDataFilter(CrmOperationPlanDetailQuery query) {
        Specification<CrmOperationPlanDetailDO> specification = this.where(query);
        return CrmOperationPlanDetailConvert.INSTANCE.toVoList(this.repo.findAll(specification));
    }

    public long count(CrmOperationPlanDetailQuery query) {
        return this.repo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public PagingVO<CrmOperationPlanDetailVO> paging(CrmOperationPlanDetailQuery query) {
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmOperationPlanDetailConvert.INSTANCE::toVo));
    }

    public PagingVO<CrmOperationPlanDetailVO> pagingDataFilter(CrmOperationPlanDetailQuery query) {
        Specification<CrmOperationPlanDetailDO> specification = this.where(query);
        Page page = this.repo.findAll(specification, (Pageable)query.getPageRequest());
        Page mapedPage = page.map(CrmOperationPlanDetailConvert.INSTANCE::toVo);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(1000);
        if (!CollectionUtils.isEmpty((Collection)mapedPage.getContent())) {
            CompletableFuture[] futures = new CompletableFuture[mapedPage.getContent().size()];
            for (int i = 0; i < mapedPage.getContent().size(); ++i) {
                CrmOperationPlanDetailVO planDetailVO = (CrmOperationPlanDetailVO)mapedPage.getContent().get(i);
                futures[i] = CompletableFuture.runAsync(() -> {
                    Optional operationDOOptional = this.customerOperationRepo.findById(planDetailVO.getOperId());
                    if (operationDOOptional.isPresent()) {
                        CrmCustomerOperationDO operationDO = (CrmCustomerOperationDO)((Object)((Object)operationDOOptional.get()));
                        planDetailVO.setCustOperBu(operationDO.getCustOperBu());
                        planDetailVO.setCustOperManagerId(operationDO.getCustOperManagerId());
                        planDetailVO.setSaleOperBu(operationDO.getSaleOperBu());
                        planDetailVO.setSaleOperManagerId(operationDO.getSaleOperManagerId());
                    }
                    CrmOperationPlanDetailMemberQuery memberQuery = new CrmOperationPlanDetailMemberQuery();
                    memberQuery.setPlanDetailId(planDetailVO.getId());
                    memberQuery.setOperId(planDetailVO.getOperId());
                    planDetailVO.setMemberList(this.planDetailMemberService.queryList(memberQuery));
                }, taskExecutor);
            }
            try {
                CompletableFuture.allOf(futures).get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u7ecf\u8425\u548c\u8ba1\u5212\u53c2\u4e0e\u8005\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return PageUtil.toPageVo(mapedPage);
    }

    private Specification<CrmOperationPlanDetailDO> where(CrmOperationPlanDetailQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            List custOperOrgIdList;
            List prdOrgOrganizationRefVOS1;
            List saleOperOrgIdList;
            Predicate predicate = QueryHelp.getPredicate(root, query, criteriaBuilder);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(predicate);
            ArrayList<Predicate> dataFilterQuery = new ArrayList<Predicate>();
            Join operObj = root.join("operObj", JoinType.LEFT);
            Join memberJoin = root.join("memberList", JoinType.LEFT);
            if (!query.isManagerFlag()) {
                Predicate predMember = criteriaBuilder.equal((javax.persistence.criteria.Expression)memberJoin.get("userId"), (Object)userId);
                Predicate performerId = criteriaBuilder.equal((javax.persistence.criteria.Expression)root.get("performerId"), (Object)userId);
                Predicate createUserId = criteriaBuilder.equal((javax.persistence.criteria.Expression)root.get("createUserId"), (Object)userId);
                Predicate[] predicatesList = new Predicate[]{predMember, performerId, createUserId};
                dataFilterQuery.addAll(Arrays.asList(predicatesList));
                Join operMemberJoin = operObj.join("memberList", JoinType.LEFT);
                Predicate operPredMember = criteriaBuilder.equal((javax.persistence.criteria.Expression)operMemberJoin.get("userId"), (Object)userId);
                List<PrdOrgEmployeeRefVO> empRef = this.prdUserDAO.queryLowListByKey(null, GlobalUtil.getLoginUserId());
                Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(userId);
                Predicate pred2 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("createUserId"), (Object)userId);
                Predicate pred3 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("saleOperManagerId"), (Object)userId);
                Predicate pred4 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("custOperManagerId"), (Object)userId);
                Predicate pred5 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("channelUserId"), (Object)userId);
                Predicate pred6 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("productUserId"), (Object)userId);
                Predicate pred7 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("serviceUserId"), (Object)userId);
                Predicate pred8 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("businessUserId"), (Object)userId);
                Predicate pred9 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("careUserId"), (Object)userId);
                Predicate pred10 = criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("operationUserId"), (Object)userId);
                Predicate[] predicatesListOper = new Predicate[]{operPredMember, pred2, pred3, pred4, pred5, pred6, pred7, pred8, pred9, pred10};
                dataFilterQuery.addAll(Arrays.asList(predicatesListOper));
                if (!CollectionUtils.isEmpty(empRefUserIdList)) {
                    Predicate pred11 = operObj.get("serviceUserId").in(empRefUserIdList);
                    dataFilterQuery.add(pred11);
                    Predicate pred12 = operObj.get("businessUserId").in(empRefUserIdList);
                    dataFilterQuery.add(pred12);
                    Predicate pred13 = operObj.get("careUserId").in(empRefUserIdList);
                    dataFilterQuery.add(pred13);
                    Predicate pred14 = operObj.get("operationUserId").in(empRefUserIdList);
                    dataFilterQuery.add(pred11);
                    dataFilterQuery.add(pred14);
                }
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    Set orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                    Predicate pred15 = operObj.get("custOperBu").in(orgIdList);
                    Predicate pred16 = operObj.get("saleOperBu").in(orgIdList);
                    dataFilterQuery.add(pred15);
                    dataFilterQuery.add(pred16);
                }
            }
            if (!dataFilterQuery.isEmpty()) {
                Predicate[] predicatesListResult = dataFilterQuery.toArray(new Predicate[dataFilterQuery.size()]);
                predicates.add(criteriaBuilder.or(predicatesListResult));
            }
            if (StringUtils.hasText((String)query.getCustName())) {
                Predicate custName = criteriaBuilder.like((javax.persistence.criteria.Expression)operObj.get("custName"), SqlUtil.toSqlLikeString(query.getCustName()));
                predicates.add(custName);
            }
            if (query.getSubSaleOperBuFlag() != null && query.getSubSaleOperBuFlag().booleanValue() && query.getSaleOperBu() != null && !CollectionUtils.isEmpty(saleOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getSaleOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
                query.setSaleOperBuList(saleOperOrgIdList);
                predicates.add(operObj.get("saleOperBu").in((Collection)query.getSaleOperBuList()));
            }
            if (query.getSubCustOperBuFlag() != null && query.getSubCustOperBuFlag().booleanValue() && query.getCustOperBu() != null && !CollectionUtils.isEmpty(custOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getCustOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
                query.setCustOperBuList(custOperOrgIdList);
                predicates.add(operObj.get("custOperBu").in((Collection)query.getCustOperBuList()));
            }
            if (!(query.getCustOperBu() == null || query.getSubCustOperBuFlag() != null && query.getSubCustOperBuFlag().booleanValue())) {
                predicates.add(criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("custOperBu"), (Object)query.getCustOperBu()));
            }
            if (query.getCustOperManagerId() != null) {
                predicates.add(criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("custOperManagerId"), (Object)query.getCustOperManagerId()));
            }
            if (!(query.getSaleOperBu() == null || query.getSubSaleOperBuFlag() != null && query.getSubSaleOperBuFlag().booleanValue())) {
                predicates.add(criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("saleOperBu"), (Object)query.getSaleOperBu()));
            }
            if (query.getSaleOperManagerId() != null) {
                predicates.add(criteriaBuilder.equal((javax.persistence.criteria.Expression)operObj.get("saleOperManagerId"), (Object)query.getSaleOperManagerId()));
            }
            if (StringUtils.hasText((String)query.getMemberUserIds())) {
                predicates.add(memberJoin.get("userId").in((Object[])query.getMemberUserIds().split(",")));
            }
            if (query.getStartDate() != null) {
                LocalDateTime startTimeFrom = LocalDateTime.of(query.getStartDate(), LocalTime.MIN);
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((javax.persistence.criteria.Expression)root.get("startTime"), (Comparable)startTimeFrom));
            }
            if (query.getEndDate() != null) {
                LocalDateTime endTimeTo = LocalDateTime.of(query.getEndDate().plusDays(1L), LocalTime.MIN);
                predicates.add(criteriaBuilder.lessThan((javax.persistence.criteria.Expression)root.get("endTime"), (Comparable)endTimeTo));
            }
            criteriaQuery.distinct(true);
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return specification;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.repo.deleteSoft(keys);
            AtomicReference operId = new AtomicReference();
            this.planDetailMemberService.deleteSoftByPlanDetailIds(keys);
            this.logService.saveNewLog((Long)operId.get(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByOperIds(List<Long> operIds) {
        if (!operIds.isEmpty()) {
            QCrmOperationPlanDetailDO qdo = QCrmOperationPlanDetailDO.crmOperationPlanDetailDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set(qdo.deleteFlag, (Object)1).where(new com.querydsl.core.types.Predicate[]{qdo.operId.in(operIds)});
            update.execute();
        }
    }

    public void saveAll(List<CrmOperationPlanDetailPayload> planDetailPayloadS) {
        List<CrmOperationPlanDetailDO> list = CrmOperationPlanDetailConvert.INSTANCE.toDoList(planDetailPayloadS);
        this.repo.saveAll(list);
    }

    public List<PrdSystemLogVO> queryLogList(Long key) {
        return this.logService.queryLogList(key, PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode());
    }

    public List<CrmOperationPlanDetailVO> listForTimeSheet() {
        CrmOperationPlanDetailQuery query = new CrmOperationPlanDetailQuery();
        Long userId = GlobalUtil.getLoginUserId();
        query.setPerformerId(userId);
        QCrmOperationPlanDetailDO qdo = QCrmOperationPlanDetailDO.crmOperationPlanDetailDO;
        QCrmOperationPlanDetailMemberDO qMemberDo = QCrmOperationPlanDetailMemberDO.crmOperationPlanDetailMemberDO;
        QCrmCustomerOperationDO qdoOperation = QCrmCustomerOperationDO.crmCustomerOperationDO;
        BooleanExpression expression = qdo.deleteFlag.eq((Object)0);
        expression = expression.and((com.querydsl.core.types.Predicate)qMemberDo.deleteFlag.eq((Object)0));
        expression = expression.and((com.querydsl.core.types.Predicate)qdoOperation.saleOperManagerId.eq((Object)userId).or((com.querydsl.core.types.Predicate)qdoOperation.custOperManagerId.eq((Object)userId).or((com.querydsl.core.types.Predicate)qdo.performerId.eq((Object)userId).or((com.querydsl.core.types.Predicate)qMemberDo.userId.eq((Object)userId)))));
        List list = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qdo).from((EntityPath)qdo)).leftJoin((EntityPath)qMemberDo)).on((com.querydsl.core.types.Predicate)qdo.id.eq(qMemberDo.planDetailId))).leftJoin((EntityPath)qdoOperation)).on((com.querydsl.core.types.Predicate)qdo.operId.eq(qdoOperation.id))).where((com.querydsl.core.types.Predicate)expression)).groupBy(qdo.id)).fetch();
        return CrmOperationPlanDetailConvert.INSTANCE.toVoList(list);
    }

    public CrmOperationPlanDetailServiceImpl(CrmOperationPlanDetailRepo repo, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, QyWxCommunicationService qyWxCommunicationService, CrmOperationPlanDetailMemberService planDetailMemberService, JPAQueryFactory jpaQueryFactory, PrdUserDAO prdUserDAO, PrdOrgOrganizationDAO prdOrgOrganizationDAO, CrmCustomerOperationRepo customerOperationRepo, PrdFsmFileRefService fsmFileRefService, TaskExecutor taskExecutor, PrdOrgOrganizationService prdOrgOrganizationService) {
        this.repo = repo;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.planDetailMemberService = planDetailMemberService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.prdUserDAO = prdUserDAO;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.customerOperationRepo = customerOperationRepo;
        this.fsmFileRefService = fsmFileRefService;
        this.taskExecutor = taskExecutor;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
    }
}

