/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdEvaluateServiceImpl
implements PrdEvaluateService {
    private static final Logger log = LoggerFactory.getLogger(PrdEvaluateServiceImpl.class);
    private final PrdEvaluateDao prdEvaluateDao;
    private final PrdEvaluateRepo prdEvaluateRepo;
    private final PrdEvaluateDtlService prdEvaluateDtlService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateVO save(PrdEvaluatePayload prdEvaluatePayload) {
        this.checkData(prdEvaluatePayload);
        if (null == prdEvaluatePayload.getState()) {
            prdEvaluatePayload.setState(Integer.valueOf(1));
        }
        PrdEvaluateDO prdEvaluateDO = new PrdEvaluateDO();
        prdEvaluateDO = PrdEvaluateConvert.INSTANCE.p2d(prdEvaluatePayload);
        prdEvaluateDO.setEvalDate(LocalDate.now());
        BigDecimal average = prdEvaluatePayload.getPrdEvaluateDtlPayloadList().stream().map(vo -> ObjectUtils.isEmpty((Object)vo.getScore()) ? new BigDecimal(0) : vo.getScore()).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(prdEvaluatePayload.getPrdEvaluateDtlPayloadList().size()), 2, 4);
        prdEvaluateDO.setAverageScore(average);
        PrdEvaluateDO res = (PrdEvaluateDO)((Object)this.prdEvaluateRepo.save((Object)prdEvaluateDO));
        for (PrdEvaluateDtlPayload prdEvaluateDtlPayload : prdEvaluatePayload.getPrdEvaluateDtlPayloadList()) {
            prdEvaluateDtlPayload.setEvalId(res.getId());
            this.prdEvaluateDtlService.save(prdEvaluateDtlPayload);
        }
        return PrdEvaluateConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateVO update(PrdEvaluatePayload prdEvaluatePayload) {
        Assert.notNull((Object)prdEvaluatePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdEvaluateVO res = this.save(prdEvaluatePayload);
        return res;
    }

    public PrdEvaluateVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdEvaluateVO res = this.prdEvaluateDao.get(id);
        if (null != res) {
            PrdEvaluateDtlQuery prdEvaluateDtlQuery = new PrdEvaluateDtlQuery();
            prdEvaluateDtlQuery.setEvalId(id);
            List list = this.prdEvaluateDtlService.getList(prdEvaluateDtlQuery);
            res.setPrdEvaluateDtlVOList(list);
        }
        return res;
    }

    public PagingVO<PrdEvaluateVO> page(PrdEvaluateQuery prdEvaluateQuery) {
        prdEvaluateQuery.setState(Integer.valueOf(1));
        PagingVO<PrdEvaluateVO> res = this.prdEvaluateDao.page(prdEvaluateQuery);
        res.getRecords().forEach(x -> {
            x.setTypeDesc(this.cacheUtil.transferSystemSelection("org:employee:evalClass", x.getType()));
            x.setCateDesc(this.cacheUtil.transferSystemSelection("org:employee:evalClass", x.getCate()));
        });
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdEvaluateDao.del(ids);
        Long dels = this.prdEvaluateDtlService.delByEvalIds(ids);
        return res;
    }

    public List<PrdEvaluateVO> getList(PrdEvaluateQuery prdEvaluateQuery) {
        prdEvaluateQuery.setState(Integer.valueOf(1));
        List<PrdEvaluateVO> res = this.prdEvaluateDao.getList(prdEvaluateQuery);
        for (PrdEvaluateVO prdEvaluateVO : res) {
            PrdEvaluateDtlQuery prdEvaluateDtlQuery = new PrdEvaluateDtlQuery();
            prdEvaluateDtlQuery.setEvalId(prdEvaluateVO.getId());
            List list = this.prdEvaluateDtlService.getList(prdEvaluateDtlQuery);
            prdEvaluateVO.setPrdEvaluateDtlVOList(list);
        }
        return res;
    }

    private void checkData(PrdEvaluatePayload prdEvaluatePayload) {
        if (null == prdEvaluatePayload.getConfigId()) {
            throw new BusinessException("\u8bc4\u4ef7\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluatePayload.getCate())) {
            throw new BusinessException("\u8bc4\u4ef7\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluatePayload.getType())) {
            throw new BusinessException("\u8bc4\u4ef7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEvaluatePayload.getFromId()) {
            throw new BusinessException("\u8bc4\u4ef7\u6765\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEvaluatePayload.getEvalUserId()) {
            throw new BusinessException("\u8bc4\u4ef7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluatePayload.getEvalUser())) {
            throw new BusinessException("\u8bc4\u4ef7\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEvaluatePayload.getToEvalUserId()) {
            throw new BusinessException("\u88ab\u8bc4\u4ef7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluatePayload.getToEvalUser())) {
            throw new BusinessException("\u88ab\u8bc4\u4ef7\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluatePayload.getItemName())) {
            throw new BusinessException("\u8bc4\u4ef7\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdEvaluatePayload prdEvaluatePayload) {
        Assert.notNull((Object)prdEvaluatePayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdEvaluateDao.update(prdEvaluatePayload);
        return res;
    }

    @Transactional
    public Boolean batchSave(List<PrdEvaluatePayload> prdEvaluatePayloadList) {
        for (PrdEvaluatePayload prdEvaluatePayload : prdEvaluatePayloadList) {
            this.save(prdEvaluatePayload);
        }
        return true;
    }

    @Transactional
    public Long updateStateByFormId(PrdEvaluatePayload prdEvaluatePayload) {
        Long res = this.prdEvaluateDao.updateStateByFormId(prdEvaluatePayload);
        return res;
    }

    public List<PrdEvaluateVO> getScoreListByUserId(PrdEvaluateQuery prdEvaluateQuery) {
        List<PrdEvaluateVO> res = this.prdEvaluateDao.getScoreListByUserId(prdEvaluateQuery);
        return res;
    }

    public PrdEvaluateServiceImpl(PrdEvaluateDao prdEvaluateDao, PrdEvaluateRepo prdEvaluateRepo, PrdEvaluateDtlService prdEvaluateDtlService, CacheUtil cacheUtil) {
        this.prdEvaluateDao = prdEvaluateDao;
        this.prdEvaluateRepo = prdEvaluateRepo;
        this.prdEvaluateDtlService = prdEvaluateDtlService;
        this.cacheUtil = cacheUtil;
    }
}

