/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamRangeConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamRangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamRangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamRangeRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdPerformanceExamRangeServiceImpl
implements PrdPerformanceExamRangeService {
    private static final Logger log = LoggerFactory.getLogger(PrdPerformanceExamRangeServiceImpl.class);
    private final PrdPerformanceExamRangeDao prdPerformanceExamRangeDao;
    private final PrdPerformanceExamRangeRepo prdPerformanceExamRangeRepo;
    private final PrdPerformanceExamResultService prdPerformanceExamResultService;
    private final PrdPerformanceExamService prdPerformanceExamService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamRangeVO save(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        this.checkData(prdPerformanceExamRangePayload);
        PrdPerformanceExamVO examVO = this.prdPerformanceExamService.get(prdPerformanceExamRangePayload.getExamId());
        if (null == examVO) {
            throw new BusinessException("id\u9519\u8bef\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ee9\u6548\u8003\u6838");
        }
        PrdPerformanceExamRangeDO prdPerformanceExamRangeDO = new PrdPerformanceExamRangeDO();
        prdPerformanceExamRangeDO = PrdPerformanceExamRangeConvert.INSTANCE.p2d(prdPerformanceExamRangePayload);
        PrdPerformanceExamRangeDO res = (PrdPerformanceExamRangeDO)((Object)this.prdPerformanceExamRangeRepo.save((Object)prdPerformanceExamRangeDO));
        PrdPerformanceExamResultPayload prdPerformanceExamResultPayload = new PrdPerformanceExamResultPayload();
        prdPerformanceExamResultPayload.setRangeId(res.getId());
        prdPerformanceExamResultPayload.setExamName(examVO.getName());
        prdPerformanceExamResultPayload.setExamId(examVO.getId());
        prdPerformanceExamResultPayload.setState(ProcInstStatus.NOTSUBMIT.name());
        prdPerformanceExamResultPayload.setExamStartPeriod(examVO.getStartPeriod());
        prdPerformanceExamResultPayload.setExamEndPeriod(examVO.getEndPeriod());
        prdPerformanceExamResultPayload.setExamCreatTime(LocalDateTime.now());
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        prdPerformanceExamResultPayload.setExamCreatUserId(loginUser.getId());
        prdPerformanceExamResultPayload.setExamCreatUser(loginUser.getUsername());
        prdPerformanceExamResultPayload.setScoreMin(examVO.getScoreMin());
        prdPerformanceExamResultPayload.setScoreMax(examVO.getScoreMax());
        prdPerformanceExamResultPayload.setResType(prdPerformanceExamRangePayload.getResType());
        prdPerformanceExamResultPayload.setCoopType(prdPerformanceExamRangePayload.getCoopType());
        prdPerformanceExamResultPayload.setBaseBuId(prdPerformanceExamRangePayload.getBuId());
        prdPerformanceExamResultPayload.setBaseBuName(prdPerformanceExamRangePayload.getBuName());
        prdPerformanceExamResultPayload.setEmpName(prdPerformanceExamRangePayload.getResName());
        prdPerformanceExamResultPayload.setUserId(prdPerformanceExamRangePayload.getUserId());
        prdPerformanceExamResultPayload.setEmpId(prdPerformanceExamRangePayload.getResId());
        prdPerformanceExamResultPayload.setExamDesc(examVO.getExamDesc());
        PrdPerformanceExamResultVO resultVO = this.prdPerformanceExamResultService.save(prdPerformanceExamResultPayload);
        return PrdPerformanceExamRangeConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamRangeVO update(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        Assert.notNull((Object)prdPerformanceExamRangePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdPerformanceExamRangeVO res = this.save(prdPerformanceExamRangePayload);
        return res;
    }

    public PrdPerformanceExamRangeVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdPerformanceExamRangeVO res = this.prdPerformanceExamRangeDao.get(id);
        return res;
    }

    public PagingVO<PrdPerformanceExamRangeVO> page(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {
        PagingVO<PrdPerformanceExamRangeVO> res = this.prdPerformanceExamRangeDao.page(prdPerformanceExamRangeQuery);
        res.getRecords().forEach(x -> {
            String userName = this.cacheUtil.getUserName(x.getUserId());
            x.setResName(userName);
        });
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdPerformanceExamRangeDao.del(ids);
        this.prdPerformanceExamResultService.delByRangeIds(ids);
        return res;
    }

    public List<PrdPerformanceExamRangeVO> getList(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {
        List<PrdPerformanceExamRangeVO> res = this.prdPerformanceExamRangeDao.getList(prdPerformanceExamRangeQuery);
        return res;
    }

    private void checkData(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        if (null == prdPerformanceExamRangePayload.getUserId()) {
            throw new BusinessException("userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdPerformanceExamRangePayload.getBuId()) {
            throw new BusinessException("buId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdPerformanceExamRangePayload.getExamId()) {
            throw new BusinessException("examId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        Assert.notNull((Object)prdPerformanceExamRangePayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdPerformanceExamRangeDao.update(prdPerformanceExamRangePayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean batchSave(List<PrdPerformanceExamRangePayload> prdPerformanceExamRangePayload) {
        prdPerformanceExamRangePayload.forEach(x -> {
            Assert.notNull((Object)x.getExamId(), (String)"\u7ee9\u6548id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.save((PrdPerformanceExamRangePayload)x);
        });
        return true;
    }

    @Transactional
    public Long delByExamId(Long id) {
        Long res = this.prdPerformanceExamRangeDao.delByExamId(id);
        return res;
    }

    public PrdPerformanceExamRangeServiceImpl(PrdPerformanceExamRangeDao prdPerformanceExamRangeDao, PrdPerformanceExamRangeRepo prdPerformanceExamRangeRepo, PrdPerformanceExamResultService prdPerformanceExamResultService, PrdPerformanceExamService prdPerformanceExamService, CacheUtil cacheUtil) {
        this.prdPerformanceExamRangeDao = prdPerformanceExamRangeDao;
        this.prdPerformanceExamRangeRepo = prdPerformanceExamRangeRepo;
        this.prdPerformanceExamResultService = prdPerformanceExamResultService;
        this.prdPerformanceExamService = prdPerformanceExamService;
        this.cacheUtil = cacheUtil;
    }
}

