/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/api/crm/businessCustomerInfo"})
public class BusinessCustomerInfoController {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerInfoController.class);
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final UdcUtil udcUtil;

    @PostMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody BusinessCustomerInfoPayload payload) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.insert(payload));
    }

    @PostMapping(value={"/updateCustomerManageTeamMember"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u66f4\u65b0\u5ba2\u6237\u7ba1\u7406\u7684\u56e2\u961f\u6210\u5458")
    public TwOutputUtil updateCustomerManageTeamMember(@RequestBody BusinessCutomerManagePayload businessCutomerManagePayload) {
        this.businessCustomerInfoService.updateCustomerManageTeamMember(businessCutomerManagePayload);
        return TwOutputUtil.ok();
    }

    @PutMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f-\u66f4\u65b0")
    public TwOutputUtil<BusinessCustomerInfoVO> update(@RequestBody BusinessCustomerInfoPayload payload) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.update(payload));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BusinessCustomerInfoVO>> queryList(BusinessCustomerInfoQuery query) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.businessCustomerInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/listSimple"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f-\u67e5\u8be2\u6240\u6709\u5ba2\u6237")
    public TwOutputUtil<List<BusinessCustomerSimpleVO>> listSimple(String identity, String customerStatus) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.listSimple(identity, customerStatus));
    }

    @GetMapping(value={"/listSimplePaging"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u4fe1\u606f\u5206\u9875-\u67e5\u8be2\u6240\u6709\u5ba2\u6237")
    public TwOutputUtil<PagingVO<BusinessCustomerSimpleVO>> listSimplePaging(BusinessPartnerListSimpleQuery query) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.listSimplePaging(query));
    }

    @GetMapping(value={"/queryCustomerManage"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2")
    public TwOutputUtil<PagingVO<BusinessCutomerManageVO>> queryCustomerManage(BusinessCustomerInfoQuery query) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.queryCustomerManage(query));
    }

    @GetMapping(value={"/queryCustomerManageByPartnerId/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2")
    public TwOutputUtil<BusinessCutomerManageVO> queryCustomerManageByPartnerId(@PathVariable Long key) {
        return TwOutputUtil.ok(this.businessCustomerInfoService.queryCustomerManageByPartnerId(key));
    }

    @GetMapping(value={"/exportCustomerManage"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u7ba1\u7406\u5bfc\u51fa")
    public void exportCustomerManage(BusinessCustomerInfoQuery query, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sheetName = "\u5ba2\u6237\u7ba1\u7406";
        List businessCutomerManageVOS = this.businessCustomerInfoService.queryCustomerManageList(query);
        if (!CollectionUtils.isEmpty((Collection)businessCutomerManageVOS)) {
            businessCutomerManageVOS = this.udcUtil.translateList(businessCutomerManageVOS);
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), BusinessCutomerManageVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, BusinessCutomerManageVO.class, null);
            sheet.doWrite(businessCutomerManageVOS);
        }
    }

    @GetMapping(value={"/activeCustomer"})
    @ApiOperation(value="\u5ba2\u6237\u7ba1\u7406-\u5ba2\u6237\u6fc0\u6d3b")
    public TwOutputUtil activeCustomer(Long partnerId, String partnerName, Long bookId) {
        this.businessCustomerInfoService.activeCustomer(partnerId, partnerName, bookId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/activeCustomerWithWorkFlow"})
    @ApiOperation(value="\u5ba2\u6237\u7ba1\u7406-\u5ba2\u6237\u6fc0\u6d3b\u65e0\u6d41\u7a0b")
    public TwOutputUtil activeCustomerWithWorkFlow(Long partnerId, String partnerName, Long bookId) {
        this.businessCustomerInfoService.activeCustomerWithWorkFlow(partnerId, partnerName, bookId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/activeCustomer/check"})
    @ApiOperation(value="\u5ba2\u6237\u7ba1\u7406-\u5ba2\u6237\u6fc0\u6d3b\u524d\u6821\u9a8c true\u901a\u8fc7false\u4e0d\u901a\u8fc7")
    public TwOutputUtil activeCustomerCheck(Long bookId) {
        Boolean res = this.businessCustomerInfoService.activeCustomerCheck(bookId);
        return TwOutputUtil.ok(res);
    }

    public BusinessCustomerInfoController(BusinessCustomerInfoService businessCustomerInfoService, UdcUtil udcUtil) {
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.udcUtil = udcUtil;
    }
}

