/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.controller;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductClassService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea7\u54c1\u5206\u7c7b"})
@RestController
@RequestMapping(value={"/api/prdProductClass"})
public class PrdProductClassController {
    private static final Logger log = LoggerFactory.getLogger(PrdProductClassController.class);
    private final PrdProductClassService prdProductClassService;

    @PostMapping
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody PrdProductClassPayload payload) {
        return TwOutputUtil.ok(this.prdProductClassService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PrdProductClassPayload payload) {
        return TwOutputUtil.ok(this.prdProductClassService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.prdProductClassService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u5206\u9875")
    public TwOutputUtil paging(PrdProductClassQuery query) {
        return TwOutputUtil.ok(this.prdProductClassService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(PrdProductClassQuery query) {
        return TwOutputUtil.ok(this.prdProductClassService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.prdProductClassService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/querySubClassBySeniorId"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u901a\u8fc7\u4e0a\u7ea7\u67e5\u8be2\u5c0f\u7c7b")
    public TwOutputUtil querySubClassBySeniorId(Long seniorId) {
        return TwOutputUtil.ok(this.prdProductClassService.querySubClassBySeniorId(seniorId));
    }

    @GetMapping(value={"/tree"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b-\u6811")
    public TwOutputUtil tree() {
        return TwOutputUtil.ok(this.prdProductClassService.getClassTrees(null));
    }

    public PrdProductClassController(PrdProductClassService prdProductClassService) {
        this.prdProductClassService = prdProductClassService;
    }
}

