/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementDetailsVO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import com.elitesland.tw.tw5.server.prd.purchase.service.PurchaseAgreementServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseAgreementDetailsServiceImpl
extends BaseServiceImpl
implements PurchaseAgreementDetailsService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementDetailsServiceImpl.class);
    private final PurchaseAgreementDetailsRepo purchaseAgreementDetailsRepo;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO;
    @Autowired
    private PurchaseAgreementServiceImpl purchaseAgreementService;
    private final PrdProductClassRepo productClassRepo;
    private final PrdProductRepo productRepo;

    public PagingVO<PurchaseAgreementDetailsVO> queryPaging(PurchaseAgreementDetailsQuery query) {
        PagingVO<PurchaseAgreementDetailsVO> paging = this.purchaseAgreementDetailsDAO.queryPaging(query);
        List records = paging.getRecords();
        this.transfer(records);
        return paging;
    }

    public List<PurchaseAgreementDetailsVO> queryListDynamic(PurchaseAgreementDetailsQuery query) {
        List<PurchaseAgreementDetailsVO> vos = this.purchaseAgreementDetailsDAO.queryListDynamic(query);
        this.transfer(vos);
        return vos;
    }

    public PurchaseAgreementDetailsVO queryByKey(Long key) {
        PurchaseAgreementDetailsDO entity = this.purchaseAgreementDetailsRepo.findById(key).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementDetailsVO vo = PurchaseAgreementDetailsConvert.INSTANCE.toVo(entity);
        this.transfer(Collections.singletonList(vo));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementDetailsVO insert(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entityDo = PurchaseAgreementDetailsConvert.INSTANCE.toDo(payload);
        PurchaseAgreementDetailsDO save = (PurchaseAgreementDetailsDO)this.purchaseAgreementDetailsRepo.save(entityDo);
        this.extracted(payload);
        return PurchaseAgreementDetailsConvert.INSTANCE.toVo(save);
    }

    private void extracted(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
        purchaseAgreementDetailsQuery.setAgreementId(payload.getAgreementId());
        List<PurchaseAgreementDetailsVO> vos = this.queryListDynamic(purchaseAgreementDetailsQuery);
        List<PurchaseAgreementDetailsPayload> purchaseAgreementDetailsPayloads = PurchaseAgreementDetailsConvert.INSTANCE.toPayloadList(vos);
        PurchaseAgreementPayload purchaseAgreementPayload = PurchaseAgreementConvert.INSTANCE.toPayload(this.purchaseAgreementService.queryByKey(payload.getAgreementId()));
        PurchaseAgreementDO purchaseAgreementDO = PurchaseAgreementConvert.INSTANCE.toDo(purchaseAgreementPayload);
        this.purchaseAgreementService.countTax(purchaseAgreementDetailsPayloads, purchaseAgreementDO);
        this.purchaseAgreementRepo.save(purchaseAgreementDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementDetailsVO update(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entity = this.purchaseAgreementDetailsRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementDetailsDO entityDo = PurchaseAgreementDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PurchaseAgreementDetailsDO save = (PurchaseAgreementDetailsDO)this.purchaseAgreementDetailsRepo.save(entity);
        this.extracted(payload);
        return PurchaseAgreementDetailsConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entity = this.purchaseAgreementDetailsRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.purchaseAgreementDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            PurchaseAgreementDetailsVO purchaseAgreementDetailsVO = this.purchaseAgreementDetailsDAO.queryByKey(keys.get(0));
            Long agreementId = purchaseAgreementDetailsVO.getAgreementId();
            keys.stream().forEach(id -> {
                Optional optional = this.purchaseAgreementDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    PurchaseAgreementDetailsDO purchaseAgreementDetailsDO = (PurchaseAgreementDetailsDO)optional.get();
                }
            });
            this.purchaseAgreementDetailsDAO.deleteSoft(keys);
            PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
            purchaseAgreementDetailsQuery.setAgreementId(agreementId);
            List<PurchaseAgreementDetailsVO> vos = this.queryListDynamic(purchaseAgreementDetailsQuery);
            List<PurchaseAgreementDetailsPayload> purchaseAgreementDetailsPayloads = PurchaseAgreementDetailsConvert.INSTANCE.toPayloadList(vos);
            PurchaseAgreementPayload purchaseAgreementPayload = PurchaseAgreementConvert.INSTANCE.toPayload(this.purchaseAgreementService.queryByKey(agreementId));
            PurchaseAgreementDO purchaseAgreementDO = PurchaseAgreementConvert.INSTANCE.toDo(purchaseAgreementPayload);
            this.purchaseAgreementService.countTax(purchaseAgreementDetailsPayloads, purchaseAgreementDO);
            this.purchaseAgreementRepo.save(purchaseAgreementDO);
        }
    }

    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        this.purchaseAgreementDetailsDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    public List<PurConOrAgreementDetailsSimpleVO> queryByPurAgreementId(Long purAgreementId) {
        return this.purchaseAgreementDetailsDAO.queryByPurAgreementId(purAgreementId);
    }

    private void transfer(List<PurchaseAgreementDetailsVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Long, String> productClassMap = this.productClassRepo.findAll().stream().collect(Collectors.toMap(BaseModel::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
        Map<Long, String> productMap = this.productRepo.findAll().stream().collect(Collectors.toMap(BaseModel::getId, PrdProductDO::getProdName, (key1, key2) -> key2));
        for (PurchaseAgreementDetailsVO vo : list) {
            String subClassName;
            String subClassId;
            String className;
            String classId;
            String relatedProductDesc;
            Long relatedProductId = vo.getRelatedProductId();
            if (!ObjectUtils.isEmpty((Object)relatedProductId) && StringUtils.hasText((String)(relatedProductDesc = productMap.get(relatedProductId)))) {
                vo.setRelatedProductName(relatedProductDesc);
            }
            if (StringUtils.hasText((String)(classId = vo.getClassId())) && StringUtils.hasText((String)(className = productClassMap.get(Long.parseLong(classId))))) {
                vo.setClassName(className);
            }
            if (!StringUtils.hasText((String)(subClassId = vo.getSubClassId())) || !StringUtils.hasText((String)(subClassName = productClassMap.get(Long.parseLong(subClassId))))) continue;
            vo.setSubClassName(subClassName);
        }
    }

    public PurchaseAgreementDetailsServiceImpl(PurchaseAgreementDetailsRepo purchaseAgreementDetailsRepo, PurchaseAgreementRepo purchaseAgreementRepo, PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO, PrdProductClassRepo productClassRepo, PrdProductRepo productRepo) {
        this.purchaseAgreementDetailsRepo = purchaseAgreementDetailsRepo;
        this.purchaseAgreementRepo = purchaseAgreementRepo;
        this.purchaseAgreementDetailsDAO = purchaseAgreementDetailsDAO;
        this.productClassRepo = productClassRepo;
        this.productRepo = productRepo;
    }
}

