/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.workflow;

import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PURCAHSE_CONTRACT/callBack"})
@Transactional
public class PurchaseContractCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractCallBackController.class);
    private final PurchaseContractManagerService service;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        if (taskKey.equals("Activity_1y3wzml")) {
            PurchaseContractManagerVO purchaseContractManagerVO = this.service.queryByKey(Long.valueOf(businessKey));
            if (!StringUtils.hasText((String)purchaseContractManagerVO.getStampFileCodes())) {
                throw TwException.error("", "\u8bf7\u4e0a\u4f20\u76d6\u7ae0\u9644\u4ef6");
            }
            PurchaseContractManagerPayload purchaseContractManagerPayload = new PurchaseContractManagerPayload();
            purchaseContractManagerPayload.setId(Long.valueOf(businessKey));
            purchaseContractManagerPayload.setFilingFlag(Integer.valueOf(1));
            this.service.updateByKeyDynamic(purchaseContractManagerPayload);
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PurchaseContractManagerPayload purchaseContractManagerPayload = new PurchaseContractManagerPayload();
        purchaseContractManagerPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        PurchaseContractManagerVO purchaseContractManagerVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (purchaseContractManagerVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractManagerPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    this.service.deleteSoft(Collections.singletonList(purchaseContractManagerPayload.getId()));
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.REJECT.getCode());
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchaseContractManagerPayload.setApprovedTime(LocalDateTime.now());
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
                    break;
                }
                case APPROVING: {
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.APPROVING.getCode());
                }
            }
            this.service.updateByKeyDynamic(purchaseContractManagerPayload);
        }
        return WorkflowResult.success(null);
    }

    public PurchaseContractCallBackController(PurchaseContractManagerService service) {
        this.service = service;
    }
}

