/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConServicePricePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConServicePriceQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConServicePriceService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConServicePriceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConServicePriceConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConServicePriceDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConServicePriceDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConServicePriceRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ConServicePriceServiceImpl
extends BaseServiceImpl
implements ConServicePriceService {
    private static final Logger log = LoggerFactory.getLogger(ConServicePriceServiceImpl.class);
    private final ConServicePriceRepo conServicePriceRepo;
    private final ConServicePriceDAO conServicePriceDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<ConServicePriceVO> queryPaging(ConServicePriceQuery query) {
        PagingVO<ConServicePriceVO> conServicePriceVOPagingVO = this.conServicePriceDAO.queryPaging(query);
        conServicePriceVOPagingVO.getRecords().forEach(this::transfer);
        return conServicePriceVOPagingVO;
    }

    public List<ConServicePriceVO> queryListDynamic(ConServicePriceQuery query) {
        List<ConServicePriceVO> conServicePriceVOS = this.conServicePriceDAO.queryListDynamic(query);
        conServicePriceVOS.forEach(this::transfer);
        return conServicePriceVOS;
    }

    public ConServicePriceVO queryByKey(Long key) {
        ConServicePriceDO entity = this.conServicePriceRepo.findById(key).orElseGet(ConServicePriceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConServicePriceVO vo = ConServicePriceConvert.INSTANCE.toVo(entity);
        this.transfer(vo);
        return vo;
    }

    private void transfer(ConServicePriceVO vo) {
        vo.setSettlementMethodDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.Settlement_Method.getCode(), vo.getSettlementMethod()));
        vo.setSettlementCycleDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.Settlement_Period.getCode(), vo.getSettlementCycle()));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConServicePriceVO insert(ConServicePricePayload payload) {
        ConServicePriceDO entityDo = ConServicePriceConvert.INSTANCE.toDo(payload);
        return ConServicePriceConvert.INSTANCE.toVo((ConServicePriceDO)this.conServicePriceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConServicePriceVO update(ConServicePricePayload payload) {
        ConServicePriceDO entity = this.conServicePriceRepo.findById(payload.getId()).orElseGet(ConServicePriceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConServicePriceDO entityDo = ConServicePriceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConServicePriceConvert.INSTANCE.toVo((ConServicePriceDO)this.conServicePriceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConServicePricePayload payload) {
        ConServicePriceDO entity = this.conServicePriceRepo.findById(payload.getId()).orElseGet(ConServicePriceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conServicePriceDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conServicePriceDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBySaleConId(Long saleConId, String settlementCycle, String settlementMethod) {
        if (!StringUtils.hasText((String)settlementCycle) && !StringUtils.hasText((String)settlementMethod)) {
            throw TwException.error("", "\u7ed3\u7b97\u5468\u671f\u548c\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        this.conServicePriceDAO.updateBySaleConId(saleConId, settlementCycle, settlementMethod);
    }

    public ConServicePriceServiceImpl(ConServicePriceRepo conServicePriceRepo, ConServicePriceDAO conServicePriceDAO, CacheUtil cacheUtil) {
        this.conServicePriceRepo = conServicePriceRepo;
        this.conServicePriceDAO = conServicePriceDAO;
        this.cacheUtil = cacheUtil;
    }
}

