/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdActivityCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdActivityCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdActivityCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdActivityCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdActivityCalendarRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdActivityCalendarDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdActivityCalendarRepo repo;
    private final QPrdActivityCalendarDO qdo = QPrdActivityCalendarDO.prdActivityCalendarDO;

    private JPAQuery<PrdActivityCalendarVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdActivityCalendarVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.title, this.qdo.type, this.qdo.startTime, this.qdo.endTime, this.qdo.city, this.qdo.location, this.qdo.scale, this.qdo.manageUserId, this.qdo.participants, this.qdo.liveUrl, this.qdo.scheduleId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdActivityCalendarVO> getJpaQueryWhere(PrdActivityCalendarQuery query) {
        JPAQuery<PrdActivityCalendarVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PrdActivityCalendarQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PrdActivityCalendarQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTitle())) {
            list.add(this.qdo.title.eq((Object)query.getTitle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getType())) {
            list.add(this.qdo.type.eq((Object)query.getType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartTime())) {
            list.add(this.qdo.startTime.eq((Object)query.getStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndTime())) {
            list.add(this.qdo.endTime.eq((Object)query.getEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCity())) {
            list.add(this.qdo.city.eq((Object)query.getCity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLocation())) {
            list.add(this.qdo.location.eq((Object)query.getLocation()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            list.add(this.qdo.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParticipants())) {
            list.add(this.qdo.participants.eq((Object)query.getParticipants()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLiveUrl())) {
            list.add(this.qdo.liveUrl.eq((Object)query.getLiveUrl()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectTime())) {
            list.add(this.qdo.startTime.between((Comparable)query.getProjectTime().atTime(0, 0, 0), (Comparable)query.getProjectTime().atTime(23, 59, 59)).or((Predicate)this.qdo.endTime.between((Comparable)query.getProjectTime().atTime(0, 0, 0), (Comparable)query.getProjectTime().atTime(23, 59, 59))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getYearMonthDate())) {
            list.add(this.qdo.startTime.loe((Comparable)query.getYearMonthDate().with(TemporalAdjusters.lastDayOfMonth()).atTime(23, 59, 59)));
            list.add(this.qdo.endTime.goe((Comparable)query.getYearMonthDate().with(TemporalAdjusters.firstDayOfMonth()).atTime(0, 0, 0)));
        }
        return ExpressionUtils.allOf(list);
    }

    public PrdActivityCalendarVO queryByKey(Long id) {
        JPAQuery<PrdActivityCalendarVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdActivityCalendarVO)jpaQuery.fetchFirst();
    }

    public List<PrdActivityCalendarVO> queryListDynamic(PrdActivityCalendarQuery query) {
        JPAQuery<PrdActivityCalendarVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdActivityCalendarVO> queryPaging(PrdActivityCalendarQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdActivityCalendarVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PrdActivityCalendarDO save(PrdActivityCalendarDO ado) {
        return (PrdActivityCalendarDO)((Object)this.repo.save((Object)ado));
    }

    public List<PrdActivityCalendarDO> saveAll(List<PrdActivityCalendarDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PrdActivityCalendarPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTitle() != null) {
            update.set((Path)this.qdo.title, (Object)payload.getTitle());
        }
        if (payload.getType() != null) {
            update.set((Path)this.qdo.type, (Object)payload.getType());
        }
        if (payload.getStartTime() != null) {
            update.set(this.qdo.startTime, (Object)payload.getStartTime());
        }
        if (payload.getEndTime() != null) {
            update.set(this.qdo.endTime, (Object)payload.getEndTime());
        }
        if (payload.getCity() != null) {
            update.set((Path)this.qdo.city, (Object)payload.getCity());
        }
        if (payload.getLocation() != null) {
            update.set((Path)this.qdo.location, (Object)payload.getLocation());
        }
        if (payload.getScale() != null) {
            update.set((Path)this.qdo.scale, (Object)payload.getScale());
        }
        if (payload.getManageUserId() != null) {
            update.set(this.qdo.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getParticipants() != null) {
            update.set((Path)this.qdo.participants, (Object)payload.getParticipants());
        }
        if (payload.getLiveUrl() != null) {
            update.set((Path)this.qdo.liveUrl, (Object)payload.getLiveUrl());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("title")) {
                update.setNull((Path)this.qdo.title);
            }
            if (nullFields.contains("type")) {
                update.setNull((Path)this.qdo.type);
            }
            if (nullFields.contains("startTime")) {
                update.setNull(this.qdo.startTime);
            }
            if (nullFields.contains("endTime")) {
                update.setNull(this.qdo.endTime);
            }
            if (nullFields.contains("city")) {
                update.setNull((Path)this.qdo.city);
            }
            if (nullFields.contains("location")) {
                update.setNull((Path)this.qdo.location);
            }
            if (nullFields.contains("scale")) {
                update.setNull((Path)this.qdo.scale);
            }
            if (nullFields.contains("manageUserId")) {
                update.setNull(this.qdo.manageUserId);
            }
            if (nullFields.contains("participants")) {
                update.setNull((Path)this.qdo.participants);
            }
            if (nullFields.contains("liveUrl")) {
                update.setNull((Path)this.qdo.liveUrl);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PrdActivityCalendarDAO(JPAQueryFactory jpaQueryFactory, PrdActivityCalendarRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

