/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ts.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalRoleResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TsEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsApprovalConfigConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsApprovalConfigDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsApprovalConfigRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TsApprovalConfigServiceImpl
extends BaseServiceImpl
implements TsApprovalConfigService {
    private static final Logger log = LoggerFactory.getLogger(TsApprovalConfigServiceImpl.class);
    private final TsApprovalConfigRepo tsApprovalConfigRepo;
    private final TsApprovalConfigDAO tsApprovalConfigDAO;
    private final CacheUtil cacheUtil;
    private final TaskPackageService taskPackageService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final BudgetService budgetService;
    private final BudgetCommonService budgetCommonService;
    private final UdcUtil udcUtil;

    public PagingVO<TsApprovalConfigVO> queryPaging(TsApprovalConfigQuery query) {
        PagingVO<TsApprovalConfigVO> tsApprovalConfigVOPagingVO = this.tsApprovalConfigDAO.queryPaging(query);
        if (tsApprovalConfigVOPagingVO.getTotal() > 0L) {
            tsApprovalConfigVOPagingVO.getRecords().forEach(this::translateData);
        }
        return tsApprovalConfigVOPagingVO;
    }

    void translateData(TsApprovalConfigVO vo) {
        TsEnum.TsBussinessRole tsBussinessRole;
        if (vo == null) {
            return;
        }
        if (StringUtils.hasText((String)vo.getApprovalType1()) && StringUtils.hasText((String)vo.getApprovalSource1())) {
            if ("1".equals(vo.getApprovalType1()) && vo.getApprovalSource1() != null) {
                tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource1());
                vo.setApprovalSource1Desc(tsBussinessRole.getDesc());
            } else {
                vo.setApprovalSource1Desc(this.cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource1())));
            }
        }
        if (StringUtils.hasText((String)vo.getApprovalType2()) && StringUtils.hasText((String)vo.getApprovalSource2())) {
            if ("1".equals(vo.getApprovalType2()) && vo.getApprovalSource2() != null) {
                tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource2());
                vo.setApprovalSource2Desc(tsBussinessRole.getDesc());
            } else {
                vo.setApprovalSource2Desc(this.cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource2())));
            }
        }
        if (StringUtils.hasText((String)vo.getApprovalType3()) && StringUtils.hasText((String)vo.getApprovalSource3())) {
            if ("1".equals(vo.getApprovalType3()) && vo.getApprovalSource3() != null) {
                tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource3());
                vo.setApprovalSource3Desc(tsBussinessRole.getDesc());
            } else {
                vo.setApprovalSource3Desc(this.cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource3())));
            }
        }
        if (StringUtils.hasText((String)vo.getWorkType())) {
            PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("salecon:work_type");
            List selectionChildren = systemSelection.getChildren();
            ArrayList<String> workTypes = new ArrayList<String>();
            for (String activity : vo.getWorkType().split(",")) {
                for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                    if (!selectionChild.getSelectionValue().equals(activity)) continue;
                    workTypes.add(selectionChild.getSelectionName());
                }
            }
            String workTypeDesc = String.join((CharSequence)",", workTypes);
            vo.setWorkTypeDesc(workTypeDesc);
        }
    }

    public List<TsApprovalConfigVO> queryListDynamic(TsApprovalConfigQuery query) {
        List<TsApprovalConfigVO> tsApprovalConfigVOS = this.tsApprovalConfigDAO.queryListDynamic(query);
        tsApprovalConfigVOS.forEach(this::translateData);
        return tsApprovalConfigVOS;
    }

    public TsApprovalConfigVO queryByKey(Long key) {
        TsApprovalConfigVO tsApprovalConfigVO = this.tsApprovalConfigDAO.queryByKey(key);
        this.translateData(tsApprovalConfigVO);
        return tsApprovalConfigVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public TsApprovalConfigVO insert(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entityDo = TsApprovalConfigConvert.INSTANCE.toDo(payload);
        return TsApprovalConfigConvert.INSTANCE.toVo((TsApprovalConfigDO)this.tsApprovalConfigRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public TsApprovalConfigVO update(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entity = this.tsApprovalConfigRepo.findById(payload.getId()).orElseGet(TsApprovalConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TsApprovalConfigDO entityDo = TsApprovalConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TsApprovalConfigConvert.INSTANCE.toVo((TsApprovalConfigDO)this.tsApprovalConfigRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entity = this.tsApprovalConfigRepo.findById(payload.getId()).orElseGet(TsApprovalConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tsApprovalConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tsApprovalConfigDAO.deleteSoft(keys);
        }
    }

    public List<TsApprovalResPayload> queryApprovalRes(Long taskPackageId, Integer finYear) {
        TsApprovalConfigVO tsApprovalConfig;
        PrdOrgOrganizationRefVO buLevel1;
        TaskPackageVO taskPackageVO;
        if (taskPackageId == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (finYear == null) {
            finYear = LocalDate.now().getYear();
        }
        if ((taskPackageVO = this.taskPackageService.queryByKey(taskPackageId, Boolean.valueOf(false))) == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
        }
        TsApprovalRoleResVO roleResVO = new TsApprovalRoleResVO();
        TsApprovalConfigQuery query = new TsApprovalConfigQuery();
        query.setStatusFlag(Integer.valueOf(1));
        query.setFinYear(finYear);
        query.setReasonType(taskPackageVO.getReasonType());
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(taskPackageVO.getReceiverResId());
        query.setResType(employee.getExtString6());
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(taskPackageVO.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "\u6240\u9009\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            query.setWorkType(pmsProjectVO.getWorkType());
            query.setCostLevel(pmsProjectVO.getCostLevel());
            query.setDeliBuId(pmsProjectVO.getDeliBuId());
            query.setBudgetType("1");
            String riskLevel = this.budgetService.queryBudgetRiskLevel(taskPackageVO.getReasonId(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO.getContractId());
            query.setBudgetData(riskLevel);
            BudgetCommonVO commonVO = new BudgetCommonVO();
            commonVO.setReasonId(taskPackageVO.getReasonId());
            commonVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            this.budgetCommonService.queryBudgetEqva(commonVO, null);
            BigDecimal totalEqva = commonVO.getUsedEqva().add(commonVO.getOccupyEqva());
            if (pmsProjectVO.getTotalEqva() != null && pmsProjectVO.getTotalEqva().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal divide = totalEqva.multiply(BigDecimal.valueOf(100L)).divide(pmsProjectVO.getTotalEqva(), 2, RoundingMode.HALF_UP);
                query.setBudgetData0(divide);
            } else {
                query.setBudgetData0(BigDecimal.ZERO);
            }
            roleResVO.setApprovalResId1(pmsProjectVO.getPmResId());
            roleResVO.setApprovalResId2(pmsProjectVO.getDeliUserId());
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(pmsProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            buLevel1 = this.cacheUtil.getBULevel1ByOrgId(pmsProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());
            }
        }
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            PrdOrgOrganizationVO org2;
            PrdOrgOrganizationVO org1;
            CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
            crmOpportunityQuery.setProjectId(taskPackageVO.getReasonId());
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(crmOpportunityQuery);
            if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            CrmOpportunityListVO crmOpportunityListVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(crmOpportunityListVO.getDeliOrgId());
            roleResVO.setApprovalResId2(crmOpportunityListVO.getDeliUserId());
            roleResVO.setApprovalResId7(crmOpportunityListVO.getManageUserId());
            roleResVO.setApprovalResId8(crmOpportunityListVO.getPreSaleUserId());
            PrdOrgOrganizationVO org0 = this.cacheUtil.getOrg(crmOpportunityListVO.getOrgId());
            if (org0 != null) {
                roleResVO.setApprovalResId9(org0.getManageId());
                PrdOrgOrganizationRefVO buLevel12 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getOrgId());
                if (buLevel12 != null) {
                    roleResVO.setApprovalResId11(buLevel12.getManageId());
                }
            }
            if ((org1 = this.cacheUtil.getOrg(crmOpportunityListVO.getDeliOrgId())) != null) {
                roleResVO.setApprovalResId3(org1.getManageId());
                buLevel1 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getDeliOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId4(buLevel1.getManageId());
                }
            }
            if ((org2 = this.cacheUtil.getOrg(crmOpportunityListVO.getPreSaleOrgId())) != null) {
                roleResVO.setApprovalResId10(org2.getManageId());
                PrdOrgOrganizationRefVO buLevel13 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getPreSaleOrgId());
                if (buLevel13 != null) {
                    roleResVO.setApprovalResId12(buLevel13.getManageId());
                }
            }
        }
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(taskPackageVO.getReasonId());
            if (ObjectUtils.isEmpty((Object)buProjectVO)) {
                throw TwException.error("", "\u6240\u9009BU\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(buProjectVO.getDeliBuId());
            roleResVO.setApprovalResId1(buProjectVO.getPmResId());
            roleResVO.setApprovalResId2(buProjectVO.getDeliUserId());
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(buProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            PrdOrgOrganizationRefVO buLevel14 = this.cacheUtil.getBULevel1ByOrgId(buProjectVO.getDeliBuId());
            if (buLevel14 != null) {
                roleResVO.setApprovalResId4(buLevel14.getManageId());
            }
        }
        if (ObjectUtils.isEmpty((Object)(tsApprovalConfig = this.tsApprovalConfigDAO.getTsApprovalConfig(query)))) {
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5de5\u65f6\u5ba1\u6279\u914d\u7f6e\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5ba1\u6279\u4eba\uff01");
        }
        List<TsApprovalResPayload> resPayloads = this.getApprovalResPayload(tsApprovalConfig, roleResVO);
        return resPayloads;
    }

    public List<TsApprovalResPayload> queryApprovalResDib(Long reasonId, String reasonType, Long tsUserId, Integer finYear) {
        TsApprovalConfigVO tsApprovalConfig;
        PrdOrgOrganizationRefVO buLevel1;
        PrdOrgOrganizationVO org;
        if (reasonId == null) {
            throw TwException.error("", "reasonId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reasonType)) {
            throw TwException.error("", "reasonType\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (finYear == null) {
            finYear = LocalDate.now().getYear();
        }
        TsApprovalRoleResVO roleResVO = new TsApprovalRoleResVO();
        TsApprovalConfigQuery query = new TsApprovalConfigQuery();
        query.setStatusFlag(Integer.valueOf(1));
        query.setFinYear(finYear);
        query.setReasonType(reasonType);
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(tsUserId);
        query.setResType(employee.getExtString6());
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(reasonId);
            if (pmsProjectVO == null) {
                throw TwException.error("", "\u6240\u9009\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            query.setWorkType(pmsProjectVO.getWorkType());
            query.setCostLevel(pmsProjectVO.getCostLevel());
            query.setDeliBuId(pmsProjectVO.getDeliBuId());
            roleResVO.setApprovalResId1(pmsProjectVO.getPmResId());
            roleResVO.setApprovalResId2(pmsProjectVO.getDeliUserId());
            roleResVO.setApprovalResId16(pmsProjectVO.getSuperResId());
            org = this.cacheUtil.getOrg(pmsProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            buLevel1 = this.cacheUtil.getBULevel1ByOrgId(pmsProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            PrdOrgOrganizationVO org2;
            PrdOrgOrganizationVO org1;
            CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
            crmOpportunityQuery.setProjectId(reasonId);
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(crmOpportunityQuery);
            if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            CrmOpportunityListVO crmOpportunityListVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(crmOpportunityListVO.getDeliOrgId());
            roleResVO.setApprovalResId2(crmOpportunityListVO.getDeliUserId());
            roleResVO.setApprovalResId7(crmOpportunityListVO.getManageUserId());
            roleResVO.setApprovalResId8(crmOpportunityListVO.getPreSaleUserId());
            PrdOrgOrganizationVO org0 = this.cacheUtil.getOrg(crmOpportunityListVO.getOrgId());
            if (org0 != null) {
                roleResVO.setApprovalResId9(org0.getManageId());
                PrdOrgOrganizationRefVO buLevel12 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getOrgId());
                if (buLevel12 != null) {
                    roleResVO.setApprovalResId11(buLevel12.getManageId());
                }
            }
            if ((org1 = this.cacheUtil.getOrg(crmOpportunityListVO.getDeliOrgId())) != null) {
                roleResVO.setApprovalResId3(org1.getManageId());
                PrdOrgOrganizationRefVO buLevel13 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getDeliOrgId());
                if (buLevel13 != null) {
                    roleResVO.setApprovalResId4(buLevel13.getManageId());
                }
            }
            if ((org2 = this.cacheUtil.getOrg(crmOpportunityListVO.getPreSaleOrgId())) != null) {
                roleResVO.setApprovalResId10(org2.getManageId());
                PrdOrgOrganizationRefVO buLevel14 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getPreSaleOrgId());
                if (buLevel14 != null) {
                    roleResVO.setApprovalResId12(buLevel14.getManageId());
                }
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty((Object)buProjectVO)) {
                throw TwException.error("", "\u6240\u9009BU\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(buProjectVO.getDeliBuId());
            roleResVO.setApprovalResId1(buProjectVO.getPmResId());
            roleResVO.setApprovalResId2(buProjectVO.getDeliUserId());
            org = this.cacheUtil.getOrg(buProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            buLevel1 = this.cacheUtil.getBULevel1ByOrgId(buProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());
            }
        }
        if (ObjectUtils.isEmpty((Object)(tsApprovalConfig = this.tsApprovalConfigDAO.getTsApprovalConfig(query)))) {
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5de5\u65f6\u5ba1\u6279\u914d\u7f6e\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5ba1\u6279\u4eba\uff01");
        }
        List<TsApprovalResPayload> resPayloads = this.getApprovalResPayload(tsApprovalConfig, roleResVO);
        return resPayloads;
    }

    List<TsApprovalResPayload> getApprovalResPayload(TsApprovalConfigVO tsApprovalConfig, TsApprovalRoleResVO roleResVO) {
        ArrayList<TsApprovalResPayload> resPayloads = new ArrayList<TsApprovalResPayload>();
        if (tsApprovalConfig != null) {
            String systemSelectionNameByValue;
            TsApprovalResPayload resPayload;
            log.info("tsApprovalConfigId:{}", (Object)tsApprovalConfig.getId());
            log.info("tsApprovalConfig:{}", (Object)tsApprovalConfig);
            ArrayList<Long> appResIds = new ArrayList<Long>();
            if (StringUtils.hasText((String)tsApprovalConfig.getApprovalType1()) && StringUtils.hasText((String)tsApprovalConfig.getApprovalSource1())) {
                resPayload = new TsApprovalResPayload();
                resPayload.setConfigType("TASK");
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
                resPayload.setSortIndex(Integer.valueOf(1));
                resPayload.setLastFlag(Integer.valueOf(0));
                if ("1".equals(tsApprovalConfig.getApprovalType1())) {
                    this.initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource1());
                    systemSelectionNameByValue = this.cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource1());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType1())) {
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource1()));
                }
            } else {
                throw TwException.error("", "\u83b7\u53d6\u5ba1\u6279\u914d\u7f6e\u8282\u70b91\u9519\u8bef,\u914d\u7f6eid:" + tsApprovalConfig.getId());
            }
            resPayloads.add(resPayload);
            appResIds.add(resPayload.getApprovalResId());
            if (StringUtils.hasText((String)tsApprovalConfig.getApprovalType2()) && StringUtils.hasText((String)tsApprovalConfig.getApprovalSource2())) {
                resPayload = new TsApprovalResPayload();
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(Integer.valueOf(resPayloads.size() + 1));
                resPayload.setLastFlag(Integer.valueOf(0));
                if ("1".equals(tsApprovalConfig.getApprovalType2())) {
                    this.initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource2());
                    systemSelectionNameByValue = this.cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource2());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType2())) {
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource2()));
                }
                if (!appResIds.contains(resPayload.getApprovalResId())) {
                    resPayloads.add(resPayload);
                    appResIds.add(resPayload.getApprovalResId());
                }
            } else {
                throw TwException.error("", "\u83b7\u53d6\u5ba1\u6279\u914d\u7f6e\u8282\u70b92\u9519\u8bef,\u914d\u7f6eid:" + tsApprovalConfig.getId());
            }
            if (StringUtils.hasText((String)tsApprovalConfig.getApprovalType3()) && StringUtils.hasText((String)tsApprovalConfig.getApprovalSource3())) {
                resPayload = new TsApprovalResPayload();
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(Integer.valueOf(resPayloads.size() + 1));
                resPayload.setLastFlag(Integer.valueOf(1));
                if ("1".equals(tsApprovalConfig.getApprovalType3())) {
                    this.initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource3());
                    systemSelectionNameByValue = this.cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource3());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType3())) {
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource3()));
                }
                if (!appResIds.contains(resPayload.getApprovalResId())) {
                    resPayloads.add(resPayload);
                    appResIds.add(resPayload.getApprovalResId());
                }
            }
        } else {
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5de5\u65f6\u5ba1\u6279\u914d\u7f6e\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5ba1\u6279\u4eba\uff01");
        }
        TsApprovalResPayload resPayload = resPayloads.stream().reduce((first, second) -> second).orElse(null);
        resPayload.setLastFlag(Integer.valueOf(1));
        return resPayloads;
    }

    void initApproalRes(TsApprovalResPayload resPayload, TsApprovalRoleResVO roleResVO, String approvalSource) {
        TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(approvalSource);
        switch (tsBussinessRole) {
            case business_role1: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId1());
                break;
            }
            case business_role2: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId2());
                break;
            }
            case business_role3: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId3());
                break;
            }
            case business_role4: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId4());
                break;
            }
            case business_role5: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId5());
                break;
            }
            case business_role6: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId6());
                break;
            }
            case business_role7: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId7());
                break;
            }
            case business_role8: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId8());
                break;
            }
            case business_role9: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId9());
                break;
            }
            case business_role10: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId10());
                break;
            }
            case business_role11: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId11());
                break;
            }
            case business_role12: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId12());
            }
            case business_role13: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId13());
            }
            case business_role14: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId14());
            }
            case business_role15: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId15());
            }
            case business_role16: {
                resPayload.setApprovalResId(roleResVO.getApprovalResId16());
            }
        }
    }

    public TsApprovalConfigServiceImpl(TsApprovalConfigRepo tsApprovalConfigRepo, TsApprovalConfigDAO tsApprovalConfigDAO, CacheUtil cacheUtil, TaskPackageService taskPackageService, PmsProjectService pmsProjectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, PrdOrgOrganizationService prdOrgOrganizationService, BudgetService budgetService, BudgetCommonService budgetCommonService, UdcUtil udcUtil) {
        this.tsApprovalConfigRepo = tsApprovalConfigRepo;
        this.tsApprovalConfigDAO = tsApprovalConfigDAO;
        this.cacheUtil = cacheUtil;
        this.taskPackageService = taskPackageService;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.budgetService = budgetService;
        this.budgetCommonService = budgetCommonService;
        this.udcUtil = udcUtil;
    }
}

