/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.work.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentDO;
import com.elitesland.tw.tw5.server.prd.work.entity.QPrdWorkAssignmentDO;
import com.elitesland.tw.tw5.server.prd.work.repo.PrdWorkAssignmentRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class PrdWorkAssignmentDAO {
    private final PrdWorkAssignmentRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdWorkAssignmentDO qdo = QPrdWorkAssignmentDO.prdWorkAssignmentDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgEmployeeDO qdoEmployee = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");

    public PrdWorkAssignmentDO save(PrdWorkAssignmentDO ado) {
        return (PrdWorkAssignmentDO)this.repo.save(ado);
    }

    public long updateByKeyDynamic(PrdWorkAssignmentPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getAssignmentNo() != null) {
            update.set((Path)this.qdo.assignmentNo, (Object)payload.getAssignmentNo());
        }
        if (payload.getAssignmentName() != null) {
            update.set((Path)this.qdo.assignmentName, (Object)payload.getAssignmentName());
        }
        if (payload.getPriority() != null) {
            update.set((Path)this.qdo.priority, (Object)payload.getPriority());
        }
        if (payload.getAssignUserId() != null) {
            update.set(this.qdo.assignUserId, (Object)payload.getAssignUserId());
        }
        if (payload.getAssistUserIds() != null) {
            update.set((Path)this.qdo.assistUserIds, (Object)payload.getAssistUserIds());
        }
        if (payload.getAssignmentType() != null) {
            update.set((Path)this.qdo.assignmentType, (Object)payload.getAssignmentType());
        }
        if (payload.getStartDate() != null) {
            update.set(this.qdo.startDate, (Object)payload.getStartDate());
        }
        if (payload.getFinishDate() != null) {
            update.set(this.qdo.finishDate, (Object)payload.getFinishDate());
        }
        if (payload.getAssignmentStatus() != null) {
            update.set((Path)this.qdo.assignmentStatus, (Object)payload.getAssignmentStatus());
        }
        if (payload.getActualStartDate() != null) {
            update.set(this.qdo.actualStartDate, (Object)payload.getActualStartDate());
        }
        if (payload.getActualFinishDate() != null) {
            update.set(this.qdo.actualFinishDate, (Object)payload.getActualFinishDate());
        }
        if (payload.getTaskId() != null) {
            update.set(this.qdo.taskId, (Object)payload.getTaskId());
        }
        if (payload.getFinishUserId() != null) {
            update.set(this.qdo.finishUserId, (Object)payload.getFinishUserId());
        }
        if (payload.getProgress() != null) {
            update.set(this.qdo.progress, (Object)payload.getProgress());
        }
        if (payload.getAssignmentDesc() != null) {
            update.set((Path)this.qdo.assignmentDesc, (Object)payload.getAssignmentDesc());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdo.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdo.remark);
        }
        return update.execute();
    }

    public PrdWorkAssignmentVO queryByKey(Long id) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdWorkAssignmentVO)jpaQuery.fetchFirst();
    }

    public long updateAssignmentStatusByIds(List<Long> ids, String assignmentStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.assignmentStatus, (Object)assignmentStatus).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public long updateActualStartDateByIds(List<Long> ids, LocalDate actualStartDate) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.actualStartDate, (Object)actualStartDate).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public long updateActualFinishDateByIds(List<Long> ids, LocalDate actualFinishDate) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.actualFinishDate, (Object)actualFinishDate).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public long updateProgressByIds(List<Long> ids, Integer progress) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.progress, (Object)progress).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public long updateFinishUserById(List<Long> ids, Long userId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.finishUserId, (Object)userId).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public List<PrdWorkAssignmentVO> queryListDynamic(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    private JPAQuery<PrdWorkAssignmentVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdWorkAssignmentVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.updater, this.qdo.modifyUserId, this.qdo.modifyTime, this.qdo.remark, this.qdo.assignmentNo, this.qdo.assignmentName, this.qdo.priority, this.qdo.assignUserId, this.qdo.assistUserIds, this.qdo.assignmentType, this.qdo.startDate, this.qdo.finishDate, this.qdo.assignmentStatus, this.qdo.actualStartDate, this.qdo.actualFinishDate, this.qdo.taskId, this.qdo.finishUserId, this.qdo.progress, this.qdo.assignmentDesc, this.qdo.fileCodes, this.qdo.parentId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.assignUserId.eq(this.qdoRef.userId).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)));
    }

    public PagingVO<PrdWorkAssignmentVO> queryPaging(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdWorkAssignmentVO> getJpaQueryWhere(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getAssignmentNo())) {
            jpaQuery.where((Predicate)this.qdo.assignmentNo.like(SqlUtil.toSqlLikeString(query.getAssignmentNo())));
        }
        if (StringUtils.hasText((String)query.getAssignmentName())) {
            jpaQuery.where((Predicate)this.qdo.assignmentName.like(SqlUtil.toSqlLikeString(query.getAssignmentName())));
        }
        if (StringUtils.hasText((String)query.getAssignmentStatus())) {
            jpaQuery.where((Predicate)this.qdo.assignmentStatus.like(SqlUtil.toSqlLikeString(query.getAssignmentStatus())));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getAssignmentStatusList())) {
            jpaQuery.where((Predicate)this.qdo.assignmentStatus.in((Collection)query.getAssignmentStatusList()));
        }
        if (StringUtils.hasText((String)query.getPriority())) {
            jpaQuery.where((Predicate)this.qdo.priority.eq((Object)query.getPriority()));
        }
        if (StringUtils.hasText((String)query.getAssignmentType())) {
            jpaQuery.where((Predicate)this.qdo.assignmentType.eq((Object)query.getAssignmentType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAssistUserIds())) {
            jpaQuery.where((Predicate)this.qdo.assistUserIds.contains(query.getAssistUserIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAssignUserId())) {
            jpaQuery.where((Predicate)this.qdo.assignUserId.eq((Object)query.getAssignUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParticipantUserId())) {
            jpaQuery.where((Predicate)this.qdo.assistUserIds.like(String.valueOf(query.getParticipantUserId())).or((Predicate)this.qdo.assignUserId.eq((Object)query.getParticipantUserId()).or((Predicate)this.qdo.createUserId.eq((Object)query.getParticipantUserId()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEmpUserId())) {
            jpaQuery.where((Predicate)this.qdo.assignUserId.eq((Object)query.getEmpUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSearchStartDate()) && !ObjectUtils.isEmpty((Object)query.getSearchEndDate())) {
            jpaQuery.where((Predicate)this.qdo.startDate.between((Comparable)query.getSearchStartDate(), (Comparable)query.getSearchEndDate()).or((Predicate)this.qdo.finishDate.between((Comparable)query.getSearchStartDate(), (Comparable)query.getSearchEndDate())).or((Predicate)this.qdo.actualStartDate.between((Comparable)query.getSearchStartDate(), (Comparable)query.getSearchEndDate())).or((Predicate)this.qdo.actualFinishDate.between((Comparable)query.getSearchStartDate(), (Comparable)query.getSearchEndDate())).or((Predicate)this.qdo.startDate.after((Comparable)query.getSearchStartDate()).and((Predicate)this.qdo.finishDate.before((Comparable)query.getSearchEndDate()))).or((Predicate)this.qdo.actualStartDate.after((Comparable)query.getSearchStartDate()).and((Predicate)this.qdo.actualFinishDate.before((Comparable)query.getSearchEndDate()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate()) && !ObjectUtils.isEmpty((Object)query.getEndDate())) {
            jpaQuery.where((Predicate)this.qdo.startDate.between((Comparable)query.getStartDate(), (Comparable)query.getEndDate()).or((Predicate)this.qdo.finishDate.between((Comparable)query.getStartDate(), (Comparable)query.getEndDate())));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return (JPAQuery)jpaQuery.distinct();
    }

    public PrdWorkAssignmentDAO(PrdWorkAssignmentRepo repo, JPAQueryFactory jpaQueryFactory) {
        this.repo = repo;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

